/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.circuits.hs.HSAuthenticationException;
import com.subgraph.orchid.circuits.hs.HSDescriptorCookie;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.crypto.TorStreamCipher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HSAuthentication {
    private static final int BASIC_ID_LENGTH = 4;
    private final HSDescriptorCookie cookie;

    public HSAuthentication(HSDescriptorCookie cookie) {
        this.cookie = cookie;
    }

    public byte[] decryptIntroductionPoints(byte[] content) throws HSAuthenticationException {
        ByteBuffer buffer = ByteBuffer.wrap(content);
        int firstByte = buffer.get() & 0xFF;
        if (firstByte == 1) {
            return this.decryptIntroductionPointsWithBasicAuth(buffer);
        }
        if (firstByte == 2) {
            return this.decryptIntroductionPointsWithStealthAuth(buffer);
        }
        throw new HSAuthenticationException("Introduction points section begins with unrecognized byte (" + firstByte + ")");
    }

    private BasicAuthEntry createEntry(ByteBuffer bb) {
        byte[] id = new byte[4];
        byte[] skey = new byte[16];
        bb.get(id);
        bb.get(skey);
        return new BasicAuthEntry(id, skey);
    }

    private byte[] decryptIntroductionPointsWithBasicAuth(ByteBuffer buffer) throws HSAuthenticationException {
        if (this.cookie == null || this.cookie.getType() != HSDescriptorCookie.CookieType.COOKIE_BASIC) {
            throw new TorParsingException("Introduction points encrypted with 'basic' authentication and no cookie available to decrypt");
        }
        List<BasicAuthEntry> entries = this.readBasicEntries(buffer);
        byte[] iv = this.readAuthIV(buffer);
        byte[] id = this.generateAuthId(iv);
        byte[] k = this.findKeyInAuthEntries(entries, id);
        return this.decryptRemaining(buffer, k, iv);
    }

    private List<BasicAuthEntry> readBasicEntries(ByteBuffer b) {
        int blockCount = b.get() & 0xFF;
        int entryCount = blockCount * 16;
        ArrayList<BasicAuthEntry> entries = new ArrayList<BasicAuthEntry>(entryCount);
        for (int i = 0; i < entryCount; ++i) {
            entries.add(this.createEntry(b));
        }
        return entries;
    }

    private byte[] readAuthIV(ByteBuffer b) {
        byte[] iv = new byte[16];
        b.get(iv);
        return iv;
    }

    private byte[] generateAuthId(byte[] iv) {
        TorMessageDigest md = new TorMessageDigest();
        md.update(this.cookie.getValue());
        md.update(iv);
        byte[] digest = md.getDigestBytes();
        byte[] id = new byte[4];
        System.arraycopy(digest, 0, id, 0, 4);
        return id;
    }

    private byte[] findKeyInAuthEntries(List<BasicAuthEntry> entries, byte[] id) throws HSAuthenticationException {
        for (BasicAuthEntry e : entries) {
            if (!Arrays.equals(id, e.id)) continue;
            return this.decryptAuthEntry(e);
        }
        throw new HSAuthenticationException("Could not find matching cookie id for basic authentication");
    }

    private byte[] decryptAuthEntry(BasicAuthEntry entry) throws HSAuthenticationException {
        TorStreamCipher cipher = TorStreamCipher.createFromKeyBytes(this.cookie.getValue());
        cipher.encrypt(entry.skey);
        return entry.skey;
    }

    private byte[] decryptRemaining(ByteBuffer buffer, byte[] key, byte[] iv) {
        TorStreamCipher streamCipher = TorStreamCipher.createFromKeyBytesWithIV(key, iv);
        byte[] remaining = new byte[buffer.remaining()];
        buffer.get(remaining);
        streamCipher.encrypt(remaining);
        return remaining;
    }

    private byte[] decryptIntroductionPointsWithStealthAuth(ByteBuffer buffer) {
        if (this.cookie == null || this.cookie.getType() != HSDescriptorCookie.CookieType.COOKIE_STEALTH) {
            throw new TorParsingException("Introduction points encrypted with 'stealth' authentication and no cookie available to descrypt");
        }
        byte[] iv = this.readAuthIV(buffer);
        return this.decryptRemaining(buffer, this.cookie.getValue(), iv);
    }

    private static class BasicAuthEntry {
        final byte[] id;
        final byte[] skey;

        BasicAuthEntry(byte[] id, byte[] skey) {
            this.id = id;
            this.skey = skey;
        }
    }
}

