/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.circuits.hs.IntroductionPoint;
import com.subgraph.orchid.crypto.TorPublicKey;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class HSDescriptor {
    private static final long MS_24_HOURS = 86400000L;
    private final HiddenService hiddenService;
    private HexDigest descriptorId;
    private Timestamp publicationTime;
    private HexDigest secretIdPart;
    private TorPublicKey permanentKey;
    private int[] protocolVersions;
    private List<IntroductionPoint> introductionPoints;

    public HSDescriptor(HiddenService hiddenService) {
        this.hiddenService = hiddenService;
        this.introductionPoints = new ArrayList<IntroductionPoint>();
    }

    HiddenService getHiddenService() {
        return this.hiddenService;
    }

    void setPublicationTime(Timestamp ts) {
        this.publicationTime = ts;
    }

    void setSecretIdPart(HexDigest secretIdPart) {
        this.secretIdPart = secretIdPart;
    }

    void setDescriptorId(HexDigest descriptorId) {
        this.descriptorId = descriptorId;
    }

    void setPermanentKey(TorPublicKey permanentKey) {
        this.permanentKey = permanentKey;
    }

    void setProtocolVersions(int[] protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    void addIntroductionPoint(IntroductionPoint ip) {
        this.introductionPoints.add(ip);
    }

    HexDigest getDescriptorId() {
        return this.descriptorId;
    }

    int getVersion() {
        return 2;
    }

    TorPublicKey getPermanentKey() {
        return this.permanentKey;
    }

    HexDigest getSecretIdPart() {
        return this.secretIdPart;
    }

    Timestamp getPublicationTime() {
        return this.publicationTime;
    }

    int[] getProtocolVersions() {
        return this.protocolVersions;
    }

    boolean isExpired() {
        long then;
        long now = System.currentTimeMillis();
        return now - (then = this.publicationTime.getTime()) > 86400000L;
    }

    List<IntroductionPoint> getIntroductionPoints() {
        return new ArrayList<IntroductionPoint>(this.introductionPoints);
    }

    List<IntroductionPoint> getShuffledIntroductionPoints() {
        return this.shuffle(this.getIntroductionPoints());
    }

    private List<IntroductionPoint> shuffle(List<IntroductionPoint> list) {
        TorRandom r = new TorRandom();
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            this.swap(list, i, r.nextInt(sz));
        }
        return list;
    }

    private void swap(List<IntroductionPoint> list, int a, int b) {
        if (a == b) {
            return;
        }
        IntroductionPoint tmp = list.get(a);
        list.set(a, list.get(b));
        list.set(b, tmp);
    }
}

