/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.hs.HSDescriptor;
import com.subgraph.orchid.circuits.hs.HSDescriptorDirectory;
import com.subgraph.orchid.circuits.hs.HSDescriptorParser;
import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.directory.DocumentFieldParserImpl;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import com.subgraph.orchid.directory.downloader.HttpConnection;
import com.subgraph.orchid.directory.parsing.DocumentParsingResultHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class HSDescriptorDownloader {
    private static final Logger logger = Logger.getLogger(HSDescriptorDirectory.class.getName());
    private final HiddenService hiddenService;
    private final CircuitManagerImpl circuitManager;
    private final List<HSDescriptorDirectory> directories;

    public HSDescriptorDownloader(HiddenService hiddenService, CircuitManagerImpl circuitManager, List<HSDescriptorDirectory> directories) {
        this.hiddenService = hiddenService;
        this.circuitManager = circuitManager;
        this.directories = directories;
    }

    public HSDescriptor downloadDescriptor() {
        for (HSDescriptorDirectory d : this.directories) {
            HSDescriptor descriptor = this.downloadDescriptorFrom(d);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSDescriptor downloadDescriptorFrom(HSDescriptorDirectory dd) {
        logger.fine("Downloading descriptor from " + dd.getDirectory());
        Stream stream = null;
        try {
            stream = this.openHSDirectoryStream(dd.getDirectory());
            HttpConnection http = new HttpConnection(stream);
            http.sendGetRequest("/tor/rendezvous2/" + dd.getDescriptorId().toBase32());
            http.readResponse();
            if (http.getStatusCode() == 200) {
                HSDescriptor hSDescriptor = this.readDocument(dd, http.getMessageBody());
                return hSDescriptor;
            }
            logger.fine("HS descriptor download for " + this.hiddenService.getOnionAddressForLogging() + " failed with status " + http.getStatusCode());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            HSDescriptor hSDescriptor = null;
            return hSDescriptor;
        }
        catch (TimeoutException e) {
            logger.fine("Timeout downloading HS descriptor from " + dd.getDirectory());
            e.printStackTrace();
            HSDescriptor hSDescriptor = null;
            return hSDescriptor;
        }
        catch (IOException e) {
            logger.info("IOException downloading HS descriptor from " + dd.getDirectory() + " : " + e);
            HSDescriptor hSDescriptor = null;
            return hSDescriptor;
        }
        catch (OpenFailedException e) {
            logger.info("Failed to open stream to HS directory " + dd.getDirectory() + " : " + e.getMessage());
            HSDescriptor hSDescriptor = null;
            return hSDescriptor;
        }
        catch (DirectoryRequestFailedException e) {
            logger.info("Directory request to HS directory " + dd.getDirectory() + " failed " + e.getMessage());
            HSDescriptor hSDescriptor = null;
            return hSDescriptor;
        }
        finally {
            if (stream != null) {
                stream.close();
                stream.getCircuit().markForClose();
            }
        }
        return null;
    }

    private Stream openHSDirectoryStream(Router directory) throws TimeoutException, InterruptedException, OpenFailedException {
        InternalCircuit circuit = this.circuitManager.getCleanInternalCircuit();
        try {
            DirectoryCircuit dc = circuit.cannibalizeToDirectory(directory);
            return dc.openDirectoryStream(10000L, true);
        }
        catch (StreamConnectFailedException e) {
            circuit.markForClose();
            throw new OpenFailedException("Failed to open directory stream");
        }
        catch (TorException e) {
            circuit.markForClose();
            throw new OpenFailedException("Failed to extend circuit to HS directory: " + e.getMessage());
        }
    }

    private HSDescriptor readDocument(HSDescriptorDirectory dd, ByteBuffer body) {
        DocumentFieldParserImpl fieldParser = new DocumentFieldParserImpl(body);
        HSDescriptorParser parser = new HSDescriptorParser(this.hiddenService, fieldParser, this.hiddenService.getAuthenticationCookie());
        DescriptorParseResult result = new DescriptorParseResult(dd);
        parser.parse(result);
        return result.getDescriptor();
    }

    private static class DescriptorParseResult
    implements DocumentParsingResultHandler<HSDescriptor> {
        HSDescriptorDirectory dd;
        HSDescriptor descriptor;

        public DescriptorParseResult(HSDescriptorDirectory dd) {
            this.dd = dd;
        }

        HSDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public void documentParsed(HSDescriptor document) {
            this.descriptor = document;
        }

        @Override
        public void documentInvalid(HSDescriptor document, String message) {
            logger.info("Invalid HS descriptor document received from " + this.dd.getDirectory() + " for descriptor " + this.dd.getDescriptorId());
        }

        @Override
        public void parsingError(String message) {
            logger.info("Failed to parse HS descriptor document received from " + this.dd.getDirectory() + " for descriptor " + this.dd.getDescriptorId() + " : " + message);
        }
    }
}

