/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.path;

import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.path.ConfigNodeFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TorConfigNodeFilter {
    private static final String EXCLUDE_NODES_FILTER = "ExcludeNodes";
    private static final String EXCLUDE_EXIT_NODES_FILTER = "ExcludeExitNodes";
    private static final String ENTRY_NODES_FILTER = "EntryNodes";
    private static final String EXIT_NODES_FILTER = "ExitNodes";
    private final Map<String, ConfigNodeFilter> filters = new HashMap<String, ConfigNodeFilter>();

    TorConfigNodeFilter(TorConfig config) {
        TorConfigNodeFilter.addFilter(this.filters, EXCLUDE_NODES_FILTER, config.getExcludeNodes());
        TorConfigNodeFilter.addFilter(this.filters, EXCLUDE_EXIT_NODES_FILTER, config.getExcludeExitNodes());
        TorConfigNodeFilter.addFilter(this.filters, ENTRY_NODES_FILTER, config.getEntryNodes());
        TorConfigNodeFilter.addFilter(this.filters, EXIT_NODES_FILTER, config.getExitNodes());
    }

    private static void addFilter(Map<String, ConfigNodeFilter> filters, String name, List<String> filterStrings) {
        if (filterStrings == null || filterStrings.isEmpty()) {
            return;
        }
        filters.put(name, ConfigNodeFilter.createFromStrings(filterStrings));
    }

    List<Router> filterExitCandidates(List<Router> candidates) {
        ArrayList<Router> filtered = new ArrayList<Router>();
        for (Router r : candidates) {
            if (!this.isExitNodeIncluded(r)) continue;
            filtered.add(r);
        }
        return filtered;
    }

    boolean isExitNodeIncluded(Router exitRouter) {
        return this.isIncludedByFilter(exitRouter, EXIT_NODES_FILTER) && !this.isExcludedByFilter(exitRouter, EXCLUDE_EXIT_NODES_FILTER) && !this.isExcludedByFilter(exitRouter, EXCLUDE_NODES_FILTER);
    }

    boolean isIncludedByFilter(Router r, String filterName) {
        ConfigNodeFilter f = this.filters.get(filterName);
        if (f == null || f.isEmpty()) {
            return true;
        }
        return f.filter(r);
    }

    boolean isExcludedByFilter(Router r, String filterName) {
        ConfigNodeFilter f = this.filters.get(filterName);
        if (f == null || f.isEmpty()) {
            return false;
        }
        return f.filter(r);
    }
}

