/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.crypto.TorMessageDigest;
import java.nio.ByteBuffer;

public class TorKeyDerivation {
    private final byte[] kdfBuffer;
    private int round;

    public TorKeyDerivation(byte[] seed) {
        this.kdfBuffer = new byte[seed.length + 1];
        System.arraycopy(seed, 0, this.kdfBuffer, 0, seed.length);
    }

    public void deriveKeys(byte[] keyMaterialOut, byte[] verifyHashOut) {
        ByteBuffer keyData = this.deriveKeys(keyMaterialOut.length + verifyHashOut.length);
        keyData.get(verifyHashOut);
        keyData.get(keyMaterialOut);
    }

    public ByteBuffer deriveKeys(int length) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(length);
        this.round = 0;
        while (outputBuffer.hasRemaining()) {
            byte[] bs = this.calculateRoundData();
            int n = Math.min(outputBuffer.remaining(), bs.length);
            outputBuffer.put(bs, 0, n);
        }
        outputBuffer.flip();
        return outputBuffer;
    }

    private byte[] calculateRoundData() {
        TorMessageDigest md = new TorMessageDigest();
        this.kdfBuffer[this.kdfBuffer.length - 1] = (byte)this.round;
        ++this.round;
        md.update(this.kdfBuffer);
        return md.getDigestBytes();
    }
}

