/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.dashboard;

import com.subgraph.orchid.dashboard.Dashboard;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DashboardConnection
implements Runnable {
    private static final int REFRESH_INTERVAL = 1000;
    private final Dashboard dashboard;
    private final Socket socket;
    private final ScheduledExecutorService refreshExecutor;

    public DashboardConnection(Dashboard dashboard, Socket socket) {
        this.dashboard = dashboard;
        this.socket = socket;
        this.refreshExecutor = new ScheduledThreadPoolExecutor(1);
    }

    @Override
    public void run() {
        ScheduledFuture<?> handle = null;
        try {
            PrintWriter writer = new PrintWriter(this.socket.getOutputStream());
            handle = this.refreshExecutor.scheduleAtFixedRate(this.createRefreshRunnable(writer), 0L, 1000L, TimeUnit.MILLISECONDS);
            this.runInputLoop(this.socket.getInputStream());
        }
        catch (IOException e) {
            this.closeQuietly(this.socket);
        }
        finally {
            if (handle != null) {
                handle.cancel(true);
            }
            this.refreshExecutor.shutdown();
        }
    }

    private void closeQuietly(Socket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void runInputLoop(InputStream input) throws IOException {
        int c;
        block4: while ((c = input.read()) != -1) {
            switch (c) {
                case 99: {
                    this.toggleFlagWithVerbose(1, 2);
                    continue block4;
                }
                case 112: {
                    this.toggleFlag(4);
                    continue block4;
                }
            }
        }
    }

    private void toggleFlagWithVerbose(int basicFlag, int verboseFlag) {
        if (this.dashboard.isEnabled(verboseFlag)) {
            this.dashboard.disableFlag(basicFlag | verboseFlag);
        } else if (this.dashboard.isEnabled(basicFlag)) {
            this.dashboard.enableFlag(verboseFlag);
        } else {
            this.dashboard.enableFlag(basicFlag);
        }
    }

    private void toggleFlag(int flag) {
        if (this.dashboard.isEnabled(flag)) {
            this.dashboard.disableFlag(flag);
        } else {
            this.dashboard.enableFlag(flag);
        }
    }

    private void hideCursor(Writer writer) throws IOException {
        this.emitCSI(writer);
        writer.write("?25l");
    }

    private void emitCSI(Writer writer) throws IOException {
        writer.append('\u001b');
        writer.append('[');
    }

    private void clear(PrintWriter writer) throws IOException {
        this.emitCSI(writer);
        writer.write("2J");
    }

    private void moveTo(PrintWriter writer, int x, int y) throws IOException {
        this.emitCSI(writer);
        writer.printf("%d;%dH", x + 1, y + 1);
    }

    private void refresh(PrintWriter writer) {
        try {
            if (this.socket.isClosed()) {
                return;
            }
            this.hideCursor(writer);
            this.clear(writer);
            this.moveTo(writer, 0, 0);
            this.dashboard.renderAll(writer);
            writer.flush();
        }
        catch (IOException e) {
            this.closeQuietly(this.socket);
        }
    }

    private Runnable createRefreshRunnable(final PrintWriter writer) {
        return new Runnable(){

            @Override
            public void run() {
                DashboardConnection.this.refresh(writer);
            }
        };
    }
}

