/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.sockets;

import com.subgraph.orchid.Tor;
import com.subgraph.orchid.TorClient;
import com.subgraph.orchid.sockets.AndroidSocket;
import com.subgraph.orchid.sockets.OrchidSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class OrchidSocketFactory
extends SocketFactory {
    private final TorClient torClient;
    private final boolean exceptionOnLocalBind;

    public OrchidSocketFactory(TorClient torClient) {
        this(torClient, true);
    }

    public OrchidSocketFactory(TorClient torClient, boolean exceptionOnLocalBind) {
        this.torClient = torClient;
        this.exceptionOnLocalBind = exceptionOnLocalBind;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.createSocketInstance();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket s = this.createSocketInstance();
        return this.connectOrchidSocket(s, host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (this.exceptionOnLocalBind) {
            throw new UnsupportedOperationException("Cannot bind to local address");
        }
        return this.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket s = this.createSocketInstance();
        return this.connectOrchidSocket(s, address.getHostAddress(), port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.exceptionOnLocalBind) {
            throw new UnsupportedOperationException("Cannot bind to local address");
        }
        return this.createSocket(address, port);
    }

    private Socket connectOrchidSocket(Socket s, String host, int port) throws IOException {
        InetSocketAddress endpoint = InetSocketAddress.createUnresolved(host, port);
        s.connect(endpoint);
        return s;
    }

    private Socket createSocketInstance() throws SocketException {
        OrchidSocketImpl impl = new OrchidSocketImpl(this.torClient);
        if (Tor.isAndroidRuntime()) {
            return new AndroidSocket(impl);
        }
        return new Socket(impl){};
    }
}

