/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.sockets;

import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.Threading;
import com.subgraph.orchid.TorClient;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;

public class OrchidSocketImpl
extends SocketImpl {
    private final TorClient torClient;
    private Lock streamLock = Threading.lock("stream");
    private Stream stream;

    OrchidSocketImpl(TorClient torClient) {
        this.torClient = torClient;
        this.fd = new FileDescriptor();
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        if (optID == 128) {
            return 0;
        }
        if (optID == 1) {
            return Boolean.TRUE;
        }
        if (optID == 4102) {
            return 0;
        }
        return 0;
    }

    @Override
    protected void create(boolean stream) throws IOException {
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        InetSocketAddress endpoint = InetSocketAddress.createUnresolved(host, port);
        this.connect(endpoint, 0);
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        InetSocketAddress endpoint = InetSocketAddress.createUnresolved(address.getHostAddress(), port);
        this.connect(endpoint, 0);
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress inetAddress = (InetSocketAddress)address;
        this.doConnect(this.addressToName(inetAddress), inetAddress.getPort());
    }

    private String addressToName(InetSocketAddress address) {
        if (address.getAddress() != null) {
            return address.getAddress().getHostAddress();
        }
        return address.getHostName();
    }

    private void doConnect(String host, int port) throws IOException {
        this.streamLock.lock();
        Stream stream = this.stream;
        this.streamLock.unlock();
        if (stream != null) {
            throw new SocketException("Already connected");
        }
        try {
            stream = this.torClient.openExitStreamTo(host, port);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SocketException("connect() interrupted");
        }
        catch (TimeoutException e) {
            throw new SocketTimeoutException();
        }
        catch (OpenFailedException e) {
            throw new ConnectException(e.getMessage());
        }
        this.streamLock.lock();
        if (this.stream != null) {
            this.streamLock.unlock();
            stream.close();
        } else {
            this.stream = stream;
            this.streamLock.unlock();
        }
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void listen(int backlog) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        throw new UnsupportedOperationException();
    }

    private Stream getStream() throws IOException {
        this.streamLock.lock();
        try {
            if (this.stream == null) {
                throw new IOException("Not connected");
            }
            Stream stream = this.stream;
            return stream;
        }
        finally {
            this.streamLock.unlock();
        }
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.getStream().getInputStream();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.getStream().getOutputStream();
    }

    @Override
    protected int available() throws IOException {
        return this.getStream().getInputStream().available();
    }

    @Override
    protected void close() throws IOException {
        this.streamLock.lock();
        Stream toClose = this.stream;
        this.stream = null;
        this.streamLock.unlock();
        if (toClose != null) {
            toClose.close();
        }
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void shutdownInput() throws IOException {
    }

    @Override
    protected void shutdownOutput() throws IOException {
    }
}

