/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.bsc.async.AsyncGenerator;

public class AsyncGeneratorQueue {
    public static <E, Q extends BlockingQueue<AsyncGenerator.Data<E>>> AsyncGenerator<E> of(Q queue, Consumer<Q> consumer) {
        return AsyncGeneratorQueue.of(queue, consumer, ForkJoinPool.commonPool());
    }

    public static <E, Q extends BlockingQueue<AsyncGenerator.Data<E>>> AsyncGenerator<E> of(Q queue, Consumer<Q> consumer, Executor executor) {
        Objects.requireNonNull(queue);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(consumer);
        executor.execute(() -> {
            try {
                consumer.accept(queue);
            }
            catch (Throwable ex) {
                CompletableFuture error = new CompletableFuture();
                error.completeExceptionally(ex);
                queue.add(AsyncGenerator.Data.of(error));
            }
            finally {
                queue.add(AsyncGenerator.Data.done());
            }
        });
        return new Generator(queue);
    }

    @Deprecated
    public static <E, Q extends BlockingQueue<AsyncGenerator.Data<E>>> AsyncGenerator<E> of(Q queue, Executor executor, Consumer<Q> consumer) {
        return AsyncGeneratorQueue.of(queue, consumer, executor);
    }

    public static class Generator<E>
    implements AsyncGenerator<E> {
        AsyncGenerator.Data<E> isEnd = null;
        final BlockingQueue<AsyncGenerator.Data<E>> queue;

        public Generator(BlockingQueue<AsyncGenerator.Data<E>> queue) {
            this.queue = queue;
        }

        public BlockingQueue<AsyncGenerator.Data<E>> queue() {
            return this.queue;
        }

        @Override
        public AsyncGenerator.Data<E> next() {
            while (this.isEnd == null) {
                AsyncGenerator.Data value = (AsyncGenerator.Data)this.queue.poll();
                if (value == null) continue;
                if (value.isDone()) {
                    this.isEnd = value;
                }
                return value;
            }
            return this.isEnd;
        }
    }
}

