/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bsc.async.AsyncGenerator;

class InternalIterator<E>
implements Iterator<E> {
    private final AsyncGenerator<E> delegate;
    private AsyncGenerator.Data<E> currentFetchedData;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock r = this.rwl.readLock();
    private final ReentrantReadWriteLock.WriteLock w = this.rwl.writeLock();

    public InternalIterator(AsyncGenerator<E> delegate) {
        this.delegate = delegate;
        this.currentFetchedData = delegate.next();
    }

    @Override
    public boolean hasNext() {
        try {
            this.r.lock();
            AsyncGenerator.Data<E> value = this.currentFetchedData;
            boolean bl = value != null && !value.isDone();
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public E next() {
        try {
            this.w.lock();
            AsyncGenerator.Data<E> next = this.currentFetchedData;
            if (next == null || next.isDone()) {
                throw new IllegalStateException("no more elements into iterator");
            }
            if (!next.isError()) {
                this.currentFetchedData = this.delegate.next();
            }
            Object e = next.data.join();
            return e;
        }
        finally {
            this.w.unlock();
        }
    }
}

