/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bsc.async.FlatMapper;
import org.bsc.async.InternalIterator;
import org.bsc.async.Mapper;
import org.bsc.async.internal.UnmodifiableDeque;

public interface AsyncGenerator<E>
extends Iterable<E> {
    public static Optional<Object> resultValue(AsyncGenerator<?> generator) {
        if (generator instanceof HasResultValue) {
            HasResultValue withResult = (HasResultValue)((Object)generator);
            return withResult.resultValue();
        }
        return Optional.empty();
    }

    public static Optional<Object> resultValue(Iterator<?> iterator) {
        if (iterator instanceof HasResultValue) {
            HasResultValue withResult = (HasResultValue)((Object)iterator);
            return withResult.resultValue();
        }
        return Optional.empty();
    }

    public Data<E> next();

    public Executor executor();

    default public <U> AsyncGenerator<U> map(Function<E, U> mapFunction) {
        return new Mapper<E, U>(this, mapFunction);
    }

    default public <U> AsyncGenerator<U> flatMap(Function<E, CompletableFuture<U>> mapFunction) {
        return new FlatMapper<E, U>(this, mapFunction);
    }

    private CompletableFuture<Object> forEachSync(Consumer<E> consumer) {
        Data<E> next = this.next();
        if (next.isDone()) {
            return CompletableFuture.completedFuture(next.resultValue());
        }
        if (next.embed() != null) {
            return next.embed().generator.forEachSync(consumer).thenCompose(v -> this.forEachSync(consumer));
        }
        return ((CompletableFuture)next.future().thenApply(v -> {
            consumer.accept(v);
            return null;
        })).thenCompose(v -> this.forEachSync(consumer));
    }

    default public CompletableFuture<Object> forEachAsync(Consumer<E> consumer) {
        return CompletableFuture.supplyAsync(() -> this.forEachSync(consumer), this.executor()).join();
    }

    default public <R> CompletableFuture<R> reduce(R result, BiFunction<R, E, R> reducer) {
        Data<E> next = this.next();
        if (next.isDone()) {
            return CompletableFuture.completedFuture(result);
        }
        return ((CompletableFuture)next.future().thenApply(v -> reducer.apply(result, v))).thenCompose(v -> this.reduce(result, reducer));
    }

    default public <R> CompletableFuture<R> reduceAsync(R result, BiFunction<R, E, R> reducer) {
        return CompletableFuture.supplyAsync(() -> this.reduce(result, reducer), this.executor()).join();
    }

    default public CompletableFuture<Object> toCompletableFuture() {
        Data<E> next = this.next();
        if (next.isDone()) {
            return CompletableFuture.completedFuture(next.resultValue());
        }
        return next.future().thenCompose(v -> this.toCompletableFuture());
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    @Override
    default public Iterator<E> iterator() {
        return new InternalIterator(this);
    }

    public static <E> AsyncGenerator<E> empty() {
        return new Base<E>(){

            @Override
            public Data<E> next() {
                return Data.done();
            }
        };
    }

    public static <E> AsyncGenerator<E> from(final Iterator<E> iterator) {
        return new Base<E>(){

            @Override
            public Data<E> next() {
                if (!iterator.hasNext()) {
                    return Data.done();
                }
                return Data.of(CompletableFuture.completedFuture(iterator.next()));
            }
        };
    }

    public static interface HasResultValue {
        public Optional<Object> resultValue();
    }

    public record Data<E>(CompletableFuture<E> future, Embed<E> embed, Object resultValue) {
        public boolean isDone() {
            return this.future == null && this.embed == null;
        }

        public boolean isError() {
            return this.future != null && this.future.isCompletedExceptionally();
        }

        public static <E> Data<E> of(CompletableFuture<E> future) {
            return new Data<E>(Objects.requireNonNull(future, "future task cannot be null"), null, null);
        }

        public static <E> Data<E> of(E data) {
            return new Data<E>(CompletableFuture.completedFuture(data), null, null);
        }

        public static <E> Data<E> composeWith(AsyncGenerator<E> generator, EmbedCompletionHandler onCompletion) {
            return new Data<E>(null, new Embed<E>(generator, onCompletion), null);
        }

        public static <E> Data<E> done() {
            return new Data<E>(null, null, null);
        }

        public static <E> Data<E> done(Object resultValue) {
            return new Data<E>(null, null, resultValue);
        }

        public static <E> Data<E> error(Throwable exception) {
            return Data.of(CompletableFuture.failedFuture(exception));
        }
    }

    public static class Embed<E>
    implements HasResultValue {
        final AsyncGenerator<E> generator;
        final EmbedCompletionHandler onCompletion;

        public Embed(AsyncGenerator<E> generator, EmbedCompletionHandler onCompletion) {
            Objects.requireNonNull(generator, "generator cannot be null");
            this.generator = generator;
            this.onCompletion = onCompletion;
        }

        @Override
        public Optional<Object> resultValue() {
            return AsyncGenerator.resultValue(this.generator);
        }
    }

    @FunctionalInterface
    public static interface EmbedCompletionHandler {
        public void accept(Object var1) throws Exception;
    }

    public static class WithEmbed<E>
    extends BaseCancellable<E>
    implements HasResultValue {
        protected final Deque<Embed<E>> generatorsStack = new ArrayDeque<Embed<E>>(2);
        private final Deque<Data<E>> returnValueStack = new ArrayDeque<Data<E>>(2);

        public WithEmbed(AsyncGenerator<E> delegate, EmbedCompletionHandler onGeneratorDoneWithResult) {
            this.generatorsStack.push(new Embed<E>(delegate, onGeneratorDoneWithResult));
        }

        public WithEmbed(AsyncGenerator<E> delegate) {
            this(delegate, null);
        }

        @Override
        public final Executor executor() {
            if (this.generatorsStack.isEmpty()) {
                throw new IllegalStateException("no generator found!");
            }
            return this.generatorsStack.peek().generator.executor();
        }

        public Deque<Data<E>> resultValues() {
            return new UnmodifiableDeque<Data<E>>(this.returnValueStack);
        }

        @Override
        public Optional<Object> resultValue() {
            return Optional.ofNullable(this.returnValueStack.peek()).map(Data::resultValue);
        }

        private void clearPreviousReturnsValuesIfAny() {
            if (this.returnValueStack.size() > 1 && this.returnValueStack.size() == this.generatorsStack.size()) {
                this.returnValueStack.clear();
            }
        }

        protected boolean isLastGenerator() {
            return this.generatorsStack.size() == 1;
        }

        @Override
        public Data<E> next() {
            if (this.generatorsStack.isEmpty()) {
                throw new IllegalStateException("no generator found!");
            }
            if (this.isCancelled()) {
                return Data.done(CANCELLED);
            }
            Embed<E> embed = Objects.requireNonNull(this.generatorsStack.peek(), "embed generator cannot be null");
            Data result = embed.generator.next();
            if (result.isDone()) {
                this.clearPreviousReturnsValuesIfAny();
                this.returnValueStack.push(result);
                if (embed.onCompletion != null) {
                    try {
                        embed.onCompletion.accept(result.resultValue());
                    }
                    catch (Exception e) {
                        return Data.error(e);
                    }
                }
                if (this.isLastGenerator()) {
                    return result;
                }
                this.generatorsStack.pop();
                return this.next();
            }
            if (result.embed() != null) {
                if (this.generatorsStack.size() >= 2) {
                    return Data.error(new UnsupportedOperationException("Currently recursive nested generators are not supported!"));
                }
                this.generatorsStack.push(result.embed());
                return this.next();
            }
            return result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                for (Embed<E> embed : this.generatorsStack) {
                    AsyncGenerator asyncGenerator = embed.generator;
                    if (!(asyncGenerator instanceof Cancellable)) continue;
                    Cancellable isCancellable = (Cancellable)asyncGenerator;
                    isCancellable.cancel(mayInterruptIfRunning);
                }
                return true;
            }
            return false;
        }
    }

    public static class WithResult<E>
    extends BaseCancellable<E>
    implements HasResultValue {
        protected final AsyncGenerator<E> delegate;
        private Object resultValue;

        public WithResult(AsyncGenerator<E> delegate) {
            this.delegate = delegate;
        }

        public AsyncGenerator<E> delegate() {
            return this.delegate;
        }

        @Override
        public Executor executor() {
            return this.delegate.executor();
        }

        @Override
        public Optional<Object> resultValue() {
            return Optional.ofNullable(this.resultValue);
        }

        @Override
        public Data<E> next() {
            Data result;
            Data data = result = this.isCancelled() ? Data.done(CANCELLED) : this.delegate.next();
            if (result.isDone()) {
                this.resultValue = result.resultValue();
            }
            return result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                ExecutorService service;
                Executor executor;
                AsyncGenerator<E> asyncGenerator = this.delegate;
                if (asyncGenerator instanceof IsCancellable) {
                    IsCancellable isCancellable = (IsCancellable)((Object)asyncGenerator);
                    return isCancellable.cancel(mayInterruptIfRunning);
                }
                if (mayInterruptIfRunning && (executor = this.delegate.executor()) instanceof ExecutorService && !(service = (ExecutorService)executor).isShutdown() && !service.isTerminated()) {
                    service.shutdownNow();
                    return true;
                }
            }
            return false;
        }
    }

    public static abstract class BaseCancellable<E>
    extends Base<E>
    implements Cancellable<E> {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.cancelled.compareAndSet(false, true)) {
                Executor executor = this.executor();
                if (executor instanceof ExecutorService) {
                    ExecutorService service = (ExecutorService)executor;
                    if (mayInterruptIfRunning && !service.isShutdown() && !service.isTerminated()) {
                        service.shutdownNow();
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class Base<E>
    implements AsyncGenerator<E> {
        private final ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, String.format("AsyncGenerator[%d]", this.hashCode())));

        @Override
        public Executor executor() {
            return this.executor;
        }
    }

    public static interface Cancellable<E>
    extends AsyncGenerator<E>,
    IsCancellable {
    }

    public static interface IsCancellable {
        public static final Object CANCELLED = new Object(){

            public String toString() {
                return "CANCELLED";
            }
        };

        public boolean isCancelled();

        public boolean cancel(boolean var1);
    }
}

