// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/** \brief struct RefineParameters is used by ArucoDetector
 */
@Namespace("cv::aruco") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class RefineParameters extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RefineParameters(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public RefineParameters(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public RefineParameters position(long position) {
        return (RefineParameters)super.position(position);
    }
    @Override public RefineParameters getPointer(long i) {
        return new RefineParameters((Pointer)this).offsetAddress(i);
    }

    public RefineParameters(float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/) { super((Pointer)null); allocate(minRepDistance, errorCorrectionRate, checkAllOrders); }
    private native void allocate(float minRepDistance/*=10.f*/, float errorCorrectionRate/*=3.f*/, @Cast("bool") boolean checkAllOrders/*=true*/);
    public RefineParameters() { super((Pointer)null); allocate(); }
    private native void allocate();


    /** \brief Read a new set of RefineParameters from FileNode (use FileStorage.root()).
     */
    public native @Cast("bool") boolean readRefineParameters(@Const @ByRef FileNode fn);

    /** \brief Write a set of RefineParameters to FileStorage
     */
    public native @Cast("bool") boolean writeRefineParameters(@ByRef FileStorage fs, @Str BytePointer name/*=cv::String()*/);
    public native @Cast("bool") boolean writeRefineParameters(@ByRef FileStorage fs);
    public native @Cast("bool") boolean writeRefineParameters(@ByRef FileStorage fs, @Str String name/*=cv::String()*/);

    /** \brief minRepDistance minimum distance between the corners of the rejected candidate and the reprojected marker
    in order to consider it as a correspondence.
     */
    public native float minRepDistance(); public native RefineParameters minRepDistance(float setter);

    /** \brief minRepDistance rate of allowed erroneous bits respect to the error correction capability of the used dictionary.
     *
     * -1 ignores the error correction step.
     */
    public native float errorCorrectionRate(); public native RefineParameters errorCorrectionRate(float setter);

    /** \brief checkAllOrders consider the four posible corner orders in the rejectedCorners array.
     *
     * If it set to false, only the provided corner order is considered (default true).
     */
    public native @Cast("bool") boolean checkAllOrders(); public native RefineParameters checkAllOrders(boolean setter);
}
