/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.TransactionImpl;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.TransactionManager;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCoordinator
implements RemoteCoordinator,
TransactionBeanFactoryAware,
TransactionEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionCoordinator.class);
    @Inject
    private TransactionBeanFactory beanFactory;
    private String endpoint;
    private transient boolean ready = false;
    private final Lock lock = new ReentrantLock();

    public Transaction getTransactionQuietly() {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        return transactionManager.getTransactionQuietly();
    }

    public Transaction start(TransactionContext transactionContext, int flags) throws XAException {
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        if (transactionManager.getTransactionQuietly() != null) {
            throw new XAException(-6);
        }
        TransactionXid globalXid = transactionContext.getXid();
        Transaction transaction = transactionRepository.getTransaction(globalXid);
        if (transaction == null) {
            transaction = new TransactionImpl(transactionContext);
            ((TransactionImpl)transaction).setBeanFactory(this.beanFactory);
            long expired = transactionContext.getExpiredTime();
            long current = System.currentTimeMillis();
            long timeoutMillis = (expired - current) / 1000L;
            transaction.setTransactionTimeout((int)timeoutMillis);
            transactionRepository.putTransaction(globalXid, transaction);
        }
        transactionManager.associateThread(transaction);
        return transaction;
    }

    public Transaction end(TransactionContext transactionContext, int flags) throws XAException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        return transactionManager.desociateThread();
    }

    public void start(Xid xid, int flags) throws XAException {
        TransactionXid branchXid;
        TransactionXid globalXid;
        if (0x8000000 != flags) {
            throw new XAException(-5);
        }
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        Transaction current = transactionManager.getTransactionQuietly();
        if (current != null) {
            throw new XAException(-6);
        }
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        Transaction transaction = transactionRepository.getTransaction(globalXid = xidFactory.createGlobalXid((branchXid = (TransactionXid)xid).getGlobalTransactionId()));
        if (transaction == null) {
            throw new XAException(-4);
        }
        transactionManager.associateThread(transaction);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (0x2000000 != flags) {
            throw new XAException(-5);
        }
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        Transaction transaction = transactionManager.getTransactionQuietly();
        if (transaction == null) {
            throw new XAException(-4);
        }
        TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid transactionXid = transactionContext.getXid();
        TransactionXid branchXid = (TransactionXid)xid;
        TransactionXid globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
        if (!CommonUtils.equals(globalXid, transactionXid)) {
            throw new XAException(-5);
        }
        transactionManager.desociateThread();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.checkParticipantReadyIfNecessary();
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        TransactionXid branchXid = (TransactionXid)xid;
        TransactionXid globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
        TransactionRepository repository = this.beanFactory.getTransactionRepository();
        Transaction transaction = repository.getTransaction(globalXid);
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            transaction.participantCommit(onePhase);
            transaction.forgetQuietly();
        }
        catch (SecurityException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause(ex);
            throw xaex;
        }
        catch (CommitRequiredException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause((Throwable)((Object)ex));
            throw xaex;
        }
        catch (RollbackException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator, tx has been rolled back.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(6);
            xaex.initCause(ex);
            throw xaex;
        }
        catch (HeuristicMixedException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator, tx has been completed mixed.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(5);
            xaex.initCause(ex);
            throw xaex;
        }
        catch (HeuristicRollbackException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator, tx has been rolled back heuristically.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(6);
            xaex.initCause(ex);
            throw xaex;
        }
        catch (SystemException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause(ex);
            throw xaex;
        }
        catch (RuntimeException ex) {
            logger.error("[{}] Error occurred while committing remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause(ex);
            throw xaex;
        }
    }

    public void forgetQuietly(Xid xid) {
        try {
            this.forget(xid);
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case -4: {
                    break;
                }
                default: {
                    logger.error("[{}] Error occurred while forgeting remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            logger.error("[{}] Error occurred while forgeting remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
        }
    }

    public void forget(Xid xid) throws XAException {
        this.checkParticipantReadyIfNecessary();
        if (xid == null) {
            throw new XAException(-5);
        }
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        TransactionXid branchXid = (TransactionXid)xid;
        TransactionXid globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        Transaction transaction = transactionRepository.getErrorTransaction(globalXid);
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            transaction.forget();
        }
        catch (SystemException ex) {
            logger.error("[{}] Error occurred while forgeting remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            throw new XAException(-3);
        }
        catch (RuntimeException rex) {
            logger.error("[{}] Error occurred while forgeting remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)rex);
            throw new XAException(-3);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        throw new XAException(-3);
    }

    public int prepare(Xid xid) throws XAException {
        this.checkParticipantReadyIfNecessary();
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        TransactionXid branchXid = (TransactionXid)xid;
        TransactionXid globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
        TransactionRepository repository = this.beanFactory.getTransactionRepository();
        Transaction transaction = repository.getTransaction(globalXid);
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            return transaction.participantPrepare();
        }
        catch (CommitRequiredException crex) {
            return 0;
        }
        catch (RollbackRequiredException rrex) {
            throw new XAException(-3);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        this.checkParticipantReadyIfNecessary();
        TransactionRepository repository = this.beanFactory.getTransactionRepository();
        List<Transaction> allTransactionList = repository.getActiveTransactionList();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        for (int i = 0; i < allTransactionList.size(); ++i) {
            Transaction transaction = allTransactionList.get(i);
            int transactionStatus = transaction.getTransactionStatus();
            if (transactionStatus == 2 || transactionStatus == 8 || transactionStatus == 9 || transactionStatus == 3 || transactionStatus == 4) {
                transactions.add(transaction);
                continue;
            }
            if (!transaction.getTransactionContext().isRecoveried()) continue;
            transactions.add(transaction);
        }
        Xid[] xidArray = new TransactionXid[transactions.size()];
        for (int i = 0; i < transactions.size(); ++i) {
            Transaction transaction = (Transaction)transactions.get(i);
            xidArray[i] = transaction.getTransactionContext().getXid();
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        this.checkParticipantReadyIfNecessary();
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        TransactionXid branchXid = (TransactionXid)xid;
        TransactionXid globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
        TransactionRepository repository = this.beanFactory.getTransactionRepository();
        Transaction transaction = repository.getTransaction(globalXid);
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            transaction.participantRollback();
            transaction.forgetQuietly();
        }
        catch (RollbackRequiredException rrex) {
            logger.error("[{}] Error occurred while rolling back remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)rrex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause((Throwable)((Object)rrex));
            throw xaex;
        }
        catch (SystemException ex) {
            logger.error("[{}] Error occurred while rolling back remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)ex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause(ex);
            throw xaex;
        }
        catch (RuntimeException rrex) {
            logger.error("[{}] Error occurred while rolling back remote coordinator.", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), (Object)rrex);
            repository.putErrorTransaction(globalXid, transaction);
            XAException xaex = new XAException(-3);
            xaex.initCause(rrex);
            throw xaex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markParticipantReady() {
        try {
            this.lock.lock();
            this.ready = true;
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void checkParticipantReadyIfNecessary() throws XAException {
        if (!this.ready) {
            this.checkParticipantReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkParticipantReady() throws XAException {
        try {
            this.lock.lock();
            if (!this.ready) {
                throw new XAException(-7);
            }
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public String getIdentifier() {
        return this.endpoint;
    }

    public String getApplication() {
        return this.endpoint;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

