/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.TransactionStrategy;
import org.bytesoft.bytejta.resource.XATerminatorImpl;
import org.bytesoft.bytejta.resource.XATerminatorOptd;
import org.bytesoft.bytejta.strategy.CommonTransactionStrategy;
import org.bytesoft.bytejta.strategy.LastResourceOptimizeStrategy;
import org.bytesoft.bytejta.strategy.SimpleTransactionStrategy;
import org.bytesoft.bytejta.strategy.VacantTransactionStrategy;
import org.bytesoft.bytejta.supports.jdbc.LocalXAResource;
import org.bytesoft.bytejta.supports.resource.CommonResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.LocalXAResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.RemoteResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.UnidentifiedResourceDescriptor;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.internal.SynchronizationList;
import org.bytesoft.transaction.internal.TransactionListenerList;
import org.bytesoft.transaction.internal.TransactionResourceListenerList;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.supports.TransactionListener;
import org.bytesoft.transaction.supports.TransactionResourceListener;
import org.bytesoft.transaction.supports.TransactionTimer;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImpl
implements Transaction {
    static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private transient boolean timing = true;
    private TransactionBeanFactory beanFactory;
    private TransactionStrategy transactionStrategy;
    private int transactionStatus;
    private int transactionTimeout;
    private int transactionVote;
    private Object transactionalExtra;
    private final TransactionContext transactionContext;
    private final TransactionResourceListenerList resourceListenerList = new TransactionResourceListenerList();
    private final Map<String, XAResourceArchive> applicationMap = new HashMap<String, XAResourceArchive>();
    private final Map<String, XAResourceArchive> participantMap = new HashMap<String, XAResourceArchive>();
    private XAResourceArchive participant;
    private final List<XAResourceArchive> participantList = new ArrayList<XAResourceArchive>();
    private final List<XAResourceArchive> nativeParticipantList = new ArrayList<XAResourceArchive>();
    private final List<XAResourceArchive> remoteParticipantList = new ArrayList<XAResourceArchive>();
    private final SynchronizationList synchronizationList = new SynchronizationList();
    private final TransactionListenerList transactionListenerList = new TransactionListenerList();

    public TransactionImpl(TransactionContext txContext) {
        this.transactionContext = txContext;
    }

    @Override
    public XAResourceDescriptor getResourceDescriptor(String identifier) {
        XAResourceArchive archive = this.participantMap.get(identifier);
        return archive == null ? null : archive.getDescriptor();
    }

    @Override
    public XAResourceDescriptor getRemoteCoordinator(String application) {
        XAResourceArchive archive = this.applicationMap.get(application);
        return archive == null ? null : archive.getDescriptor();
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    @Override
    public boolean isLocalTransaction() {
        return this.participantList.size() <= 1;
    }

    @Override
    public synchronized int participantPrepare() throws RollbackRequiredException, CommitRequiredException {
        if (this.transactionStatus == 4) {
            throw new RollbackRequiredException();
        }
        if (this.transactionStatus == 9) {
            throw new RollbackRequiredException();
        }
        if (this.transactionStatus == 5) {
            throw new RollbackRequiredException();
        }
        if (this.transactionStatus == 6) {
            throw new RollbackRequiredException();
        }
        if (this.transactionStatus == 2) {
            throw new CommitRequiredException();
        }
        if (this.transactionStatus == 8) {
            throw new CommitRequiredException();
        }
        if (this.transactionStatus == 3) {
            throw new CommitRequiredException();
        }
        TransactionTimer transactionTimer = this.beanFactory.getTransactionTimer();
        transactionTimer.stopTiming(this);
        this.synchronizationList.beforeCompletion();
        try {
            this.delistAllResource();
        }
        catch (RollbackRequiredException rrex) {
            this.transactionStatus = 9;
            throw new RollbackRequiredException();
        }
        catch (SystemException ex) {
            this.transactionStatus = 9;
            throw new RollbackRequiredException();
        }
        catch (RuntimeException rex) {
            this.transactionStatus = 9;
            throw new RollbackRequiredException();
        }
        TransactionXid xid = this.transactionContext.getXid();
        TransactionArchive archive = this.getTransactionArchive();
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        this.transactionStatus = 7;
        archive.setStatus(this.transactionStatus);
        transactionLogger.createTransaction(archive);
        this.transactionListenerList.onPrepareStart(xid);
        if (this.transactionStatus == 1) {
            throw new RollbackRequiredException();
        }
        try {
            TransactionStrategy currentStrategy = this.getTransactionStrategy();
            int vote = currentStrategy.prepare(xid);
            this.transactionStatus = 2;
            archive.setStatus(this.transactionStatus);
            this.transactionVote = vote;
            archive.setVote(vote);
            this.transactionListenerList.onPrepareSuccess(xid);
            int n = vote;
            return n;
        }
        catch (CommitRequiredException crex) {
            this.transactionVote = 0;
            archive.setVote(this.transactionVote);
            this.transactionStatus = 8;
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onPrepareSuccess(xid);
            throw crex;
        }
        catch (RollbackRequiredException rrex) {
            this.transactionStatus = 9;
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onPrepareFailure(xid);
            throw rrex;
        }
        catch (RuntimeException xaex) {
            this.transactionStatus = 9;
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onPrepareFailure(xid);
            RollbackRequiredException rrex = new RollbackRequiredException();
            rrex.initCause(xaex);
            throw rrex;
        }
        finally {
            transactionLogger.updateTransaction(archive);
        }
    }

    @Override
    public synchronized void recoveryCommit() throws CommitRequiredException, SystemException {
        TransactionXid xid = this.transactionContext.getXid();
        try {
            this.recoverIfNecessary();
            this.invokeParticipantCommit();
        }
        catch (HeuristicMixedException ex) {
            logger.error("[{}] recover: branch={}, status= mixed, message= {}", new Object[]{ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), ByteUtils.byteArrayToString(xid.getBranchQualifier()), ex.getMessage(), ex});
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
        catch (HeuristicRollbackException ex) {
            logger.error("[{}] recover: branch={}, status= rolledback", new Object[]{ByteUtils.byteArrayToString(xid.getGlobalTransactionId()), ByteUtils.byteArrayToString(xid.getBranchQualifier()), ex});
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
    }

    @Override
    public synchronized void participantCommit(boolean opc) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        if (this.transactionContext.isRecoveried()) {
            this.recover();
            this.invokeParticipantCommit();
        } else if (opc) {
            this.participantOnePhaseCommit();
        } else {
            this.participantTwoPhaseCommit();
        }
    }

    private void checkForTransactionExtraIfNecessary() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        if (this.transactionalExtra != null) {
            if (!this.participantList.isEmpty() && this.participant == null) {
                this.participantRollback();
                throw new HeuristicRollbackException();
            }
            if (this.participantList.size() > 1) {
                this.participantRollback();
                throw new HeuristicRollbackException();
            }
        }
    }

    private void participantOnePhaseCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        this.checkForTransactionExtraIfNecessary();
        if (this.transactionStatus == 1) {
            this.participantRollback();
            throw new HeuristicRollbackException();
        }
        if (this.transactionStatus == 9) {
            throw new HeuristicMixedException();
        }
        if (this.transactionStatus == 4) {
            throw new HeuristicRollbackException();
        }
        if (this.transactionStatus == 5) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 6) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 3) {
            return;
        }
        try {
            this.synchronizationList.beforeCompletion();
            this.delistAllResource();
            try {
                this.invokeParticipantPrepare();
            }
            catch (CommitRequiredException commitRequiredException) {
                // empty catch block
            }
            this.invokeParticipantCommit();
        }
        catch (RollbackRequiredException rrex) {
            this.participantRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)((Object)rrex));
            throw hrex;
        }
        catch (SystemException ex) {
            this.participantRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)ex);
            throw hrex;
        }
        catch (RuntimeException rex) {
            this.participantRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)rex);
            throw hrex;
        }
        finally {
            this.synchronizationList.afterCompletion(this.transactionStatus);
        }
    }

    private void participantTwoPhaseCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        if (this.transactionStatus == 0) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 1) {
            this.participantRollback();
            throw new HeuristicRollbackException();
        }
        if (this.transactionStatus == 9) {
            throw new HeuristicMixedException();
        }
        if (this.transactionStatus == 4) {
            throw new HeuristicRollbackException();
        }
        if (this.transactionStatus == 5) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 6) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 3) {
            return;
        }
        try {
            this.synchronizationList.beforeCompletion();
            this.delistAllResource();
            this.invokeParticipantCommit();
        }
        catch (RollbackRequiredException rrex) {
            this.participantRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)((Object)rrex));
            throw hrex;
        }
        catch (SystemException ex) {
            this.participantRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)ex);
            throw hrex;
        }
        catch (RuntimeException rex) {
            this.participantRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)rex);
            throw hrex;
        }
        finally {
            this.synchronizationList.afterCompletion(this.transactionStatus);
        }
    }

    private void invokeParticipantPrepare() throws RollbackRequiredException, CommitRequiredException {
        TransactionXid xid = this.transactionContext.getXid();
        TransactionArchive archive = this.getTransactionArchive();
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        logger.info("[{}] prepare-transaction start", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
        this.transactionStatus = 7;
        archive.setStatus(this.transactionStatus);
        this.transactionListenerList.onPrepareStart(xid);
        transactionLogger.updateTransaction(archive);
        boolean unFinishExists = true;
        try {
            TransactionStrategy currentStrategy = this.getTransactionStrategy();
            currentStrategy.prepare(xid);
            unFinishExists = false;
        }
        catch (CommitRequiredException ex) {
            unFinishExists = false;
            throw ex;
        }
        catch (RollbackRequiredException ex) {
            this.transactionListenerList.onPrepareFailure(xid);
            logger.info("[{}] prepare-transaction failed", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.transactionListenerList.onPrepareFailure(xid);
            logger.info("[{}] prepare-transaction failed", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
            throw ex;
        }
        finally {
            if (!unFinishExists) {
                this.transactionStatus = 2;
                archive.setStatus(this.transactionStatus);
                this.transactionListenerList.onPrepareSuccess(xid);
                transactionLogger.updateTransaction(archive);
                logger.info("[{}] prepare-transaction complete successfully", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
            }
        }
    }

    private void invokeParticipantCommit() throws HeuristicMixedException, HeuristicRollbackException, SystemException {
        TransactionXid xid = this.transactionContext.getXid();
        TransactionArchive archive = this.getTransactionArchive();
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        logger.info("[{}] commit-transaction start", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
        this.transactionStatus = 8;
        archive.setStatus(this.transactionStatus);
        this.transactionListenerList.onCommitStart(xid);
        transactionLogger.updateTransaction(archive);
        boolean unFinishExists = true;
        try {
            TransactionStrategy currentStrategy = this.getTransactionStrategy();
            currentStrategy.commit(xid);
            unFinishExists = false;
        }
        catch (HeuristicMixedException ex) {
            this.transactionListenerList.onCommitHeuristicMixed(xid);
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            this.transactionListenerList.onCommitHeuristicRolledback(xid);
            throw ex;
        }
        catch (SystemException ex) {
            this.transactionListenerList.onCommitFailure(xid);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.transactionListenerList.onCommitFailure(xid);
            throw ex;
        }
        finally {
            if (!unFinishExists) {
                this.transactionStatus = 3;
                archive.setStatus(this.transactionStatus);
                this.transactionListenerList.onCommitSuccess(xid);
                transactionLogger.updateTransaction(archive);
                logger.info("[{}] commit-transaction complete successfully", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
            }
        }
    }

    public synchronized void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        if (this.transactionStatus == 0) {
            this.fireCommit();
        } else {
            if (this.transactionStatus == 1) {
                this.fireRollback();
                throw new HeuristicRollbackException();
            }
            if (this.transactionStatus == 4) {
                throw new RollbackException();
            }
            if (this.transactionStatus == 3) {
                logger.debug("Current transaction has already been committed.");
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private void fireCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        this.beanFactory.getTransactionTimer().stopTiming(this);
        this.synchronizationList.beforeCompletion();
        try {
            this.delistAllResource();
        }
        catch (RollbackRequiredException rrex) {
            this.fireRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)((Object)rrex));
            throw hrex;
        }
        catch (SystemException ex) {
            this.fireRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)ex);
            throw hrex;
        }
        catch (RuntimeException rex) {
            this.fireRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)rex);
            throw hrex;
        }
        try {
            TransactionXid xid = this.transactionContext.getXid();
            logger.info("[{}] commit-transaction start", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
            if (this.participantList.size() == 0) {
                this.skipOnePhaseCommit();
            } else if (this.participantList.size() == 1) {
                this.fireOnePhaseCommit();
            } else {
                this.fireTwoPhaseCommit();
            }
            logger.info("[{}] commit-transaction complete successfully", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
        }
        finally {
            this.synchronizationList.afterCompletion(this.transactionStatus);
        }
    }

    public synchronized void skipOnePhaseCommit() throws HeuristicRollbackException, HeuristicMixedException, CommitRequiredException, SystemException {
        TransactionXid xid = this.transactionContext.getXid();
        this.transactionListenerList.onCommitStart(xid);
        this.transactionListenerList.onCommitSuccess(xid);
    }

    public synchronized void fireOnePhaseCommit() throws HeuristicRollbackException, HeuristicMixedException, CommitRequiredException, SystemException {
        XAResourceArchive archive = null;
        archive = this.nativeParticipantList.size() > 0 ? this.nativeParticipantList.get(0) : (this.remoteParticipantList.size() > 0 ? this.remoteParticipantList.get(0) : this.participant);
        TransactionXid xid = this.transactionContext.getXid();
        try {
            this.transactionListenerList.onCommitStart(xid);
            archive.commit(xid, true);
            this.transactionListenerList.onCommitSuccess(xid);
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 5: {
                    this.transactionListenerList.onCommitHeuristicMixed(xid);
                    HeuristicMixedException hmex = new HeuristicMixedException();
                    hmex.initCause((Throwable)xaex);
                    throw hmex;
                }
                case 7: {
                    this.transactionListenerList.onCommitSuccess(xid);
                    break;
                }
                case 6: {
                    this.transactionListenerList.onCommitHeuristicRolledback(xid);
                    HeuristicRollbackException hrex = new HeuristicRollbackException();
                    hrex.initCause((Throwable)xaex);
                    throw hrex;
                }
                default: {
                    this.transactionListenerList.onCommitFailure(xid);
                    SystemException ex = new SystemException();
                    ex.initCause((Throwable)xaex);
                    throw ex;
                }
            }
        }
        catch (RuntimeException rex) {
            this.transactionListenerList.onCommitFailure(xid);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)rex);
            throw sysEx;
        }
    }

    public synchronized void fireTwoPhaseCommit() throws HeuristicRollbackException, HeuristicMixedException, CommitRequiredException, SystemException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        TransactionStrategy currentStrategy = this.getTransactionStrategy();
        TransactionXid xid = this.transactionContext.getXid();
        TransactionArchive archive = this.getTransactionArchive();
        this.transactionStatus = 7;
        archive.setStatus(this.transactionStatus);
        transactionLogger.createTransaction(archive);
        this.transactionListenerList.onPrepareStart(xid);
        int vote = 3;
        try {
            vote = currentStrategy.prepare(xid);
        }
        catch (RollbackRequiredException xaex) {
            this.transactionListenerList.onPrepareFailure(xid);
            this.fireRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)((Object)xaex));
            throw hrex;
        }
        catch (CommitRequiredException xaex) {
            vote = 0;
        }
        catch (RuntimeException rex) {
            this.transactionListenerList.onPrepareFailure(xid);
            this.fireRollback();
            HeuristicRollbackException hrex = new HeuristicRollbackException();
            hrex.initCause((Throwable)rex);
            throw hrex;
        }
        this.transactionListenerList.onPrepareSuccess(xid);
        if (vote == 3) {
            this.transactionStatus = 2;
            this.transactionVote = 3;
            archive.setVote(3);
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onCommitStart(xid);
            this.transactionListenerList.onCommitSuccess(xid);
            transactionLogger.updateTransaction(archive);
        } else {
            this.transactionStatus = 8;
            this.transactionVote = 0;
            archive.setVote(this.transactionVote);
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onCommitStart(xid);
            transactionLogger.updateTransaction(archive);
            boolean unFinishExists = true;
            try {
                currentStrategy.commit(xid);
                unFinishExists = false;
            }
            catch (HeuristicMixedException ex) {
                this.transactionListenerList.onCommitHeuristicMixed(xid);
                throw ex;
            }
            catch (HeuristicRollbackException ex) {
                this.transactionListenerList.onCommitHeuristicRolledback(xid);
                throw ex;
            }
            catch (SystemException ex) {
                this.transactionListenerList.onCommitFailure(xid);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.transactionListenerList.onCommitFailure(xid);
                throw ex;
            }
            finally {
                if (!unFinishExists) {
                    this.transactionStatus = 3;
                    archive.setStatus(this.transactionStatus);
                    this.transactionListenerList.onCommitSuccess(xid);
                    transactionLogger.updateTransaction(archive);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.transactionStatus != 0 && this.transactionStatus != 1) {
            throw new IllegalStateException();
        }
        try {
            if (XAResourceDescriptor.class.isInstance(xaRes)) {
                boolean bl = this.delistResource((XAResourceDescriptor)xaRes, flag);
                return bl;
            }
            UnidentifiedResourceDescriptor descriptor = new UnidentifiedResourceDescriptor();
            descriptor.setDelegate(xaRes);
            descriptor.setIdentifier("");
            boolean bl = this.delistResource(descriptor, flag);
            return bl;
        }
        finally {
            if (flag == 0x20000000) {
                this.setRollbackOnlyQuietly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResourceDescriptor descriptor, int flag) throws IllegalStateException, SystemException {
        String identifier = descriptor.getIdentifier();
        XAResourceArchive archive = this.participantMap.get(identifier);
        if (archive == null) {
            throw new SystemException();
        }
        boolean success = false;
        try {
            success = this.delistResource(archive, flag);
        }
        finally {
            if (success) {
                this.resourceListenerList.onDelistResource(archive.getXid(), descriptor);
            }
        }
        return true;
    }

    private boolean delistResource(XAResourceArchive archive, int flag) throws SystemException, RollbackRequiredException {
        try {
            Xid branchXid = archive.getXid();
            switch (flag) {
                case 0x4000000: 
                case 0x20000000: {
                    archive.end(branchXid, flag);
                    archive.setDelisted(true);
                    break;
                }
                case 0x2000000: {
                    archive.end(branchXid, flag);
                    archive.setDelisted(true);
                    archive.setSuspended(true);
                    break;
                }
                default: {
                    throw new SystemException();
                }
            }
            logger.info("[{}] delist: xares= {}, branch= {}, flags= {}", new Object[]{ByteUtils.byteArrayToString(branchXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(branchXid.getBranchQualifier()), flag});
        }
        catch (XAException xae) {
            logger.error("XATerminatorImpl.delistResource(XAResourceArchive, int)", (Throwable)xae);
            switch (xae.errorCode) {
                case -6: 
                case -5: 
                case -4: {
                    return false;
                }
                case -7: 
                case -3: {
                    SystemException sysex = new SystemException();
                    sysex.initCause((Throwable)xae);
                    throw sysex;
                }
            }
            RollbackRequiredException rrex = new RollbackRequiredException();
            rrex.initCause(xae);
            throw rrex;
        }
        catch (RuntimeException ex) {
            logger.error("XATerminatorImpl.delistResource(XAResourceArchive, int)", (Throwable)ex);
            SystemException sysex = new SystemException();
            sysex.initCause((Throwable)ex);
            throw sysex;
        }
        return true;
    }

    public synchronized boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.transactionStatus == 1) {
            throw new RollbackException();
        }
        if (this.transactionStatus != 0) {
            throw new IllegalStateException();
        }
        if (XAResourceDescriptor.class.isInstance(xaRes)) {
            return this.enlistResource((XAResourceDescriptor)xaRes);
        }
        if (!XAResourceDescriptor.class.isInstance(xaRes) && this.transactionContext.isCoordinator()) {
            UnidentifiedResourceDescriptor descriptor = new UnidentifiedResourceDescriptor();
            descriptor.setIdentifier("");
            descriptor.setDelegate(xaRes);
            return this.enlistResource(descriptor);
        }
        throw new SystemException("Unknown xa resource!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResourceDescriptor descriptor) throws RollbackException, IllegalStateException, SystemException {
        block25: {
            XAResourceArchive archive;
            String identifier;
            block27: {
                block26: {
                    identifier = descriptor.getIdentifier();
                    archive = null;
                    XAResourceArchive element = this.participantMap.get(identifier);
                    if (element != null) {
                        XAResourceDescriptor xard = element.getDescriptor();
                        try {
                            archive = xard.isSameRM(descriptor) ? element : archive;
                        }
                        catch (Exception ex) {
                            logger.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    int flags = 0;
                    if (archive == null) {
                        archive = new XAResourceArchive();
                        archive.setDescriptor(descriptor);
                        archive.setIdentified(true);
                        TransactionXid globalXid = this.transactionContext.getXid();
                        XidFactory xidFactory = this.beanFactory.getXidFactory();
                        archive.setXid(xidFactory.createBranchXid(globalXid));
                    } else {
                        flags = 0x200000;
                    }
                    descriptor.setTransactionTimeoutQuietly(this.transactionTimeout);
                    if (this.participant != null && (LocalXAResourceDescriptor.class.isInstance(descriptor) || UnidentifiedResourceDescriptor.class.isInstance(descriptor))) {
                        XAResourceDescriptor lro = this.participant.getDescriptor();
                        try {
                            if (!lro.isSameRM(descriptor)) {
                                throw new SystemException("Only one non-XA resource is allowed to participate in global transaction.");
                            }
                        }
                        catch (XAException ex) {
                            SystemException sysEx = new SystemException();
                            sysEx.initCause((Throwable)ex);
                            throw sysEx;
                        }
                        catch (RuntimeException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                    boolean success = false;
                    try {
                        success = this.enlistResource(archive, flags);
                        Object var10_14 = null;
                        if (!success) break block25;
                        if (!CommonResourceDescriptor.class.isInstance(descriptor)) break block26;
                        this.nativeParticipantList.add(archive);
                    }
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        if (success) {
                            if (CommonResourceDescriptor.class.isInstance(descriptor)) {
                                this.nativeParticipantList.add(archive);
                            } else if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
                                this.remoteParticipantList.add(archive);
                            } else if (this.participant == null) {
                                this.participant = archive;
                            } else {
                                throw new SystemException("There already has a local-resource exists!");
                            }
                            this.participantList.add(archive);
                            if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
                                RemoteResourceDescriptor resourceDescriptor = (RemoteResourceDescriptor)descriptor;
                                RemoteCoordinator remoteCoordinator = resourceDescriptor.getDelegate();
                                this.applicationMap.put(remoteCoordinator.getApplication(), archive);
                            }
                            this.participantMap.put(identifier, archive);
                            this.resourceListenerList.onEnlistResource(archive.getXid(), descriptor);
                        }
                        throw throwable;
                    }
                    break block27;
                }
                if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
                    this.remoteParticipantList.add(archive);
                } else if (this.participant == null) {
                    this.participant = archive;
                } else {
                    throw new SystemException("There already has a local-resource exists!");
                }
            }
            this.participantList.add(archive);
            if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
                RemoteResourceDescriptor resourceDescriptor = (RemoteResourceDescriptor)descriptor;
                RemoteCoordinator remoteCoordinator = resourceDescriptor.getDelegate();
                this.applicationMap.put(remoteCoordinator.getApplication(), archive);
            }
            this.participantMap.put(identifier, archive);
            this.resourceListenerList.onEnlistResource(archive.getXid(), descriptor);
            {
            }
        }
        return true;
    }

    private boolean enlistResource(XAResourceArchive archive, int flag) throws SystemException, RollbackException {
        try {
            Xid branchXid = archive.getXid();
            logger.info("[{}] enlist: xares= {}, branch= {}, flags: {}", new Object[]{ByteUtils.byteArrayToString(branchXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(branchXid.getBranchQualifier()), flag});
            switch (flag) {
                case 0: {
                    long expired = this.transactionContext.getExpiredTime();
                    long current = System.currentTimeMillis();
                    long remains = expired - current;
                    int timeout = (int)(remains / 1000L);
                    archive.setTransactionTimeout(timeout);
                    archive.start(branchXid, flag);
                    return true;
                }
                case 0x200000: {
                    archive.start(branchXid, flag);
                    archive.setDelisted(false);
                    return false;
                }
                case 0x8000000: {
                    archive.start(branchXid, flag);
                    archive.setDelisted(false);
                    archive.setSuspended(false);
                    return false;
                }
            }
            throw new SystemException();
        }
        catch (XAException xae) {
            logger.error("XATerminatorImpl.enlistResource(XAResourceArchive, int)", (Throwable)xae);
            switch (xae.errorCode) {
                case -8: {
                    return false;
                }
                case -9: 
                case -6: 
                case -5: 
                case -4: {
                    return false;
                }
                case -7: 
                case -3: {
                    SystemException sysex = new SystemException();
                    sysex.initCause((Throwable)xae);
                    throw sysex;
                }
            }
            throw new RollbackException();
        }
        catch (RuntimeException ex) {
            logger.error("XATerminatorImpl.enlistResource(XAResourceArchive, int)", (Throwable)ex);
            throw new RollbackException();
        }
    }

    public int getStatus() {
        return this.transactionStatus;
    }

    public synchronized void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.transactionStatus == 1) {
            throw new RollbackException();
        }
        if (this.transactionStatus != 0) {
            throw new IllegalStateException();
        }
        this.synchronizationList.registerSynchronizationQuietly(sync);
        logger.debug("[{}] register-sync: sync= {}", (Object)ByteUtils.byteArrayToString(this.transactionContext.getXid().getGlobalTransactionId()), (Object)sync);
    }

    public synchronized void rollback() throws IllegalStateException, RollbackRequiredException, SystemException {
        if (this.transactionStatus == 5) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 6) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 3) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 4) {
            logger.debug("Current transaction has already been rolled back.");
        } else {
            this.fireRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRollback() throws IllegalStateException, RollbackRequiredException, SystemException {
        this.beanFactory.getTransactionTimer().stopTiming(this);
        try {
            this.synchronizationList.beforeCompletion();
            this.delistAllResourceQuietly();
            this.invokeParticipantRollback();
            Object var2_1 = null;
            this.synchronizationList.afterCompletion(this.transactionStatus);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.synchronizationList.afterCompletion(this.transactionStatus);
            throw throwable;
        }
    }

    @Override
    public synchronized void recoveryRollback() throws RollbackRequiredException, SystemException {
        this.recoverIfNecessary();
        this.invokeParticipantRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void participantRollback() throws IllegalStateException, RollbackRequiredException, SystemException {
        if (this.transactionStatus == 5) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 6) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 3) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 4) {
            return;
        }
        if (this.transactionContext.isRecoveried()) {
            this.recover();
            this.invokeParticipantRollback();
        } else {
            try {
                this.synchronizationList.beforeCompletion();
                this.delistAllResourceQuietly();
                this.invokeParticipantRollback();
                Object var2_1 = null;
                this.synchronizationList.afterCompletion(this.transactionStatus);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.synchronizationList.afterCompletion(this.transactionStatus);
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeParticipantRollback() throws SystemException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        TransactionXid xid = this.transactionContext.getXid();
        logger.info("[{}] rollback-transaction start", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
        this.transactionStatus = 9;
        TransactionArchive archive = this.getTransactionArchive();
        archive.setStatus(this.transactionStatus);
        this.transactionListenerList.onRollbackStart(xid);
        transactionLogger.updateTransaction(archive);
        boolean unFinishExists = true;
        try {
            try {
                TransactionStrategy currentStrategy = this.getTransactionStrategy();
                currentStrategy.rollback(xid);
                unFinishExists = false;
            }
            catch (HeuristicMixedException ex) {
                this.transactionListenerList.onRollbackFailure(xid);
                SystemException sysEx = new SystemException();
                sysEx.initCause((Throwable)ex);
                throw sysEx;
            }
            catch (HeuristicCommitException ex) {
                this.transactionListenerList.onRollbackFailure(xid);
                SystemException sysEx = new SystemException();
                sysEx.initCause((Throwable)ex);
                throw sysEx;
            }
            catch (SystemException ex) {
                this.transactionListenerList.onRollbackFailure(xid);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.transactionListenerList.onRollbackFailure(xid);
                throw ex;
            }
            Object var8_10 = null;
            if (unFinishExists) return;
            this.transactionStatus = 4;
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onRollbackSuccess(xid);
            transactionLogger.updateTransaction(archive);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (unFinishExists) throw throwable;
            this.transactionStatus = 4;
            archive.setStatus(this.transactionStatus);
            this.transactionListenerList.onRollbackSuccess(xid);
            transactionLogger.updateTransaction(archive);
            logger.info("[{}] rollback-transaction complete successfully", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
            throw throwable;
        }
        logger.info("[{}] rollback-transaction complete successfully", (Object)ByteUtils.byteArrayToString(xid.getGlobalTransactionId()));
    }

    @Override
    public void suspend() throws RollbackRequiredException, SystemException {
        boolean rollbackRequired = false;
        boolean errorExists = false;
        for (int i = 0; i < this.participantList.size(); ++i) {
            XAResourceArchive xares = this.participantList.get(i);
            if (xares.isDelisted()) continue;
            try {
                this.delistResource(xares, 0x2000000);
                continue;
            }
            catch (RollbackRequiredException ex) {
                rollbackRequired = true;
                continue;
            }
            catch (SystemException ex) {
                errorExists = true;
                continue;
            }
            catch (RuntimeException ex) {
                errorExists = true;
            }
        }
        if (rollbackRequired) {
            this.setRollbackOnlyQuietly();
            throw new RollbackRequiredException();
        }
        if (errorExists) {
            throw new SystemException(-3);
        }
    }

    @Override
    public void resume() throws RollbackRequiredException, SystemException {
        boolean rollbackRequired = false;
        boolean errorExists = false;
        for (int i = 0; i < this.participantList.size(); ++i) {
            XAResourceArchive xares = this.participantList.get(i);
            if (!xares.isDelisted()) continue;
            try {
                this.enlistResource(xares, 0x8000000);
                continue;
            }
            catch (RollbackException rex) {
                rollbackRequired = true;
                continue;
            }
            catch (SystemException rex) {
                errorExists = true;
                continue;
            }
            catch (RuntimeException rex) {
                errorExists = true;
            }
        }
        if (rollbackRequired) {
            this.setRollbackOnlyQuietly();
            throw new RollbackRequiredException();
        }
        if (errorExists) {
            throw new SystemException(-3);
        }
    }

    private void delistAllResourceQuietly() {
        try {
            this.delistAllResource();
        }
        catch (RollbackRequiredException rrex) {
            logger.warn(rrex.getMessage(), (Throwable)((Object)rrex));
        }
        catch (SystemException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
        catch (RuntimeException rex) {
            logger.warn(rex.getMessage(), (Throwable)rex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delistAllResource() throws RollbackRequiredException, SystemException {
        boolean rollbackRequired = false;
        boolean errorExists = false;
        for (int i = 0; i < this.participantList.size(); ++i) {
            Object var7_9;
            XAResourceArchive xares = this.participantList.get(i);
            if (xares.isDelisted()) continue;
            try {
                try {
                    this.delistResource(xares, 0x4000000);
                }
                catch (RollbackRequiredException ex) {
                    rollbackRequired = true;
                    var7_9 = null;
                    this.resourceListenerList.onDelistResource(xares.getXid(), xares.getDescriptor());
                    continue;
                }
                catch (SystemException ex) {
                    errorExists = true;
                    var7_9 = null;
                    this.resourceListenerList.onDelistResource(xares.getXid(), xares.getDescriptor());
                    continue;
                }
                catch (RuntimeException ex) {
                    errorExists = true;
                    var7_9 = null;
                    this.resourceListenerList.onDelistResource(xares.getXid(), xares.getDescriptor());
                    continue;
                }
                var7_9 = null;
                this.resourceListenerList.onDelistResource(xares.getXid(), xares.getDescriptor());
                continue;
            }
            catch (Throwable throwable) {
                var7_9 = null;
                this.resourceListenerList.onDelistResource(xares.getXid(), xares.getDescriptor());
                throw throwable;
            }
        }
        if (rollbackRequired) {
            throw new RollbackRequiredException();
        }
        if (errorExists) {
            throw new SystemException(-3);
        }
    }

    @Override
    public void setRollbackOnlyQuietly() {
        try {
            this.setRollbackOnly();
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
        }
    }

    public synchronized void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.transactionStatus != 0 && this.transactionStatus != 1) {
            throw new IllegalStateException();
        }
        this.transactionStatus = 1;
    }

    public void recoverIfNecessary() throws SystemException {
        if (this.transactionContext.isRecoveried()) {
            this.recover();
        }
    }

    @Override
    public synchronized void recover() throws SystemException {
        if (this.transactionStatus == 7) {
            this.recover4PreparingStatus();
        } else if (this.transactionStatus == 8) {
            this.recover4CommittingStatus();
        } else if (this.transactionStatus == 9) {
            this.recover4RollingBackStatus();
        }
    }

    public void recover4PreparingStatus() throws SystemException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean unPrepareExists = false;
        for (int i = 0; i < this.participantList.size(); ++i) {
            boolean preparedVal;
            XAResourceArchive archive = this.participantList.get(i);
            boolean prepareFlag = archive.getVote() != -1;
            boolean bl = preparedVal = archive.isReadonly() || prepareFlag;
            if (archive.isRecovered()) {
                unPrepareExists = preparedVal ? unPrepareExists : true;
                continue;
            }
            if (preparedVal) continue;
            boolean xidExists = this.recover(archive);
            unPrepareExists = !xidExists;
        }
        if (!unPrepareExists) {
            this.transactionStatus = 2;
            TransactionArchive archive = this.getTransactionArchive();
            transactionLogger.updateTransaction(archive);
        }
    }

    public void recover4CommittingStatus() throws SystemException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean rollbackExists = false;
        boolean unCommitExists = false;
        for (int i = 0; i < this.participantList.size(); ++i) {
            XAResourceArchive archive = this.participantList.get(i);
            XAResourceDescriptor descriptor = archive.getDescriptor();
            XAResource delegate = descriptor.getDelegate();
            boolean localFlag = LocalXAResource.class.isInstance(delegate);
            if (localFlag && LastResourceOptimizeStrategy.class.isInstance(this.transactionStrategy)) {
                throw new SystemException();
            }
            if (archive.isRecovered()) {
                unCommitExists = archive.isCommitted() ? unCommitExists : true;
                continue;
            }
            if (archive.isCommitted()) continue;
            boolean xidExists = this.recover(archive);
            if (localFlag) {
                rollbackExists = xidExists ? rollbackExists : true;
                continue;
            }
            unCommitExists = xidExists ? true : unCommitExists;
        }
        if (rollbackExists) {
            this.transactionStatus = 9;
            TransactionArchive archive = this.getTransactionArchive();
            transactionLogger.updateTransaction(archive);
        } else if (!unCommitExists) {
            this.transactionStatus = 3;
            TransactionArchive archive = this.getTransactionArchive();
            transactionLogger.updateTransaction(archive);
        }
    }

    public void recover4RollingBackStatus() throws SystemException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean unRollbackExists = false;
        for (int i = 0; i < this.participantList.size(); ++i) {
            XAResourceArchive archive = this.participantList.get(i);
            if (archive.isRecovered()) {
                unRollbackExists = archive.isRolledback() ? unRollbackExists : true;
                continue;
            }
            if (archive.isRolledback()) continue;
            boolean xidExists = this.recover(archive);
            unRollbackExists = xidExists ? true : unRollbackExists;
        }
        if (!unRollbackExists) {
            this.transactionStatus = 4;
            TransactionArchive archive = this.getTransactionArchive();
            transactionLogger.updateTransaction(archive);
        }
    }

    private boolean recover(XAResourceArchive archive) throws SystemException {
        TransactionXid globalXid = this.transactionContext.getXid();
        boolean xidRecovered = false;
        XAResourceDescriptor descriptor = archive.getDescriptor();
        XAResource delegate = descriptor.getDelegate();
        boolean nativeFlag = LocalXAResource.class.isInstance(delegate);
        boolean remoteFlag = RemoteCoordinator.class.isInstance(delegate);
        if (nativeFlag) {
            try {
                ((LocalXAResource)delegate).recoverable(archive.getXid());
                xidRecovered = true;
            }
            catch (XAException ex) {
                switch (ex.errorCode) {
                    case -4: {
                        break;
                    }
                    default: {
                        logger.error("[{}] recover-resource failed. branch= {}", new Object[]{ByteUtils.byteArrayToString(globalXid.getGlobalTransactionId()), ByteUtils.byteArrayToString(globalXid.getBranchQualifier()), ex});
                        throw new SystemException();
                    }
                }
            }
        } else if (archive.isIdentified()) {
            Xid thisXid = archive.getXid();
            byte[] thisGlobalTransactionId = thisXid.getGlobalTransactionId();
            byte[] thisBranchQualifier = thisXid.getBranchQualifier();
            try {
                Xid[] array = archive.recover(0x1800000);
                for (int j = 0; !xidRecovered && array != null && j < array.length; ++j) {
                    Xid thatXid = array[j];
                    byte[] thatGlobalTransactionId = thatXid.getGlobalTransactionId();
                    byte[] thatBranchQualifier = thatXid.getBranchQualifier();
                    boolean formatIdEquals = thisXid.getFormatId() == thatXid.getFormatId();
                    boolean transactionIdEquals = Arrays.equals(thisGlobalTransactionId, thatGlobalTransactionId);
                    boolean qualifierEquals = Arrays.equals(thisBranchQualifier, thatBranchQualifier);
                    xidRecovered = formatIdEquals && transactionIdEquals && (remoteFlag || qualifierEquals);
                }
            }
            catch (Exception ex) {
                logger.error("[{}] recover-resource failed. branch= {}", new Object[]{ByteUtils.byteArrayToString(globalXid.getGlobalTransactionId()), ByteUtils.byteArrayToString(globalXid.getBranchQualifier()), ex});
                throw new SystemException();
            }
        }
        archive.setRecovered(true);
        return xidRecovered;
    }

    @Override
    public synchronized void forgetQuietly() {
        TransactionXid xid = this.transactionContext.getXid();
        try {
            this.forget();
        }
        catch (SystemException ex) {
            logger.error("Error occurred while forgetting transaction: {}", (Object)ByteUtils.byteArrayToInt(xid.getGlobalTransactionId()), (Object)ex);
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while forgetting transaction: {}", (Object)ByteUtils.byteArrayToInt(xid.getGlobalTransactionId()), (Object)ex);
        }
    }

    @Override
    public synchronized void forget() throws SystemException {
        TransactionRepository repository = this.beanFactory.getTransactionRepository();
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        TransactionXid xid = this.transactionContext.getXid();
        this.cleanup();
        repository.removeErrorTransaction(xid);
        repository.removeTransaction(xid);
        transactionLogger.deleteTransaction(this.getTransactionArchive());
    }

    public synchronized void cleanup() throws SystemException {
        boolean unFinishExists = false;
        block7: for (int i = 0; i < this.participantList.size(); ++i) {
            XAResourceArchive archive = this.participantList.get(i);
            Xid currentXid = archive.getXid();
            if (!archive.isHeuristic()) continue;
            try {
                Xid branchXid = archive.getXid();
                archive.forget(branchXid);
                continue;
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case -3: {
                        unFinishExists = true;
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                        continue block7;
                    }
                    case -7: {
                        unFinishExists = true;
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                        continue block7;
                    }
                    case -6: 
                    case -5: 
                    case -4: {
                        continue block7;
                    }
                    default: {
                        unFinishExists = true;
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                    }
                }
            }
        }
        if (unFinishExists) {
            throw new SystemException("Error occurred while cleaning branch transaction!");
        }
    }

    @Override
    public TransactionArchive getTransactionArchive() {
        TransactionArchive transactionArchive = new TransactionArchive();
        transactionArchive.setVote(this.transactionVote);
        transactionArchive.setXid(this.transactionContext.getXid());
        transactionArchive.setCoordinator(this.transactionContext.isCoordinator());
        transactionArchive.setOptimizedResource(this.participant);
        transactionArchive.getNativeResources().addAll(this.nativeParticipantList);
        transactionArchive.getRemoteResources().addAll(this.remoteParticipantList);
        transactionArchive.setStatus(this.transactionStatus);
        transactionArchive.setPropagatedBy(this.transactionContext.getPropagatedBy());
        TransactionStrategy currentStrategy = this.getTransactionStrategy();
        if (CommonTransactionStrategy.class.isInstance(currentStrategy)) {
            transactionArchive.setTransactionStrategyType(2);
        } else if (SimpleTransactionStrategy.class.isInstance(currentStrategy)) {
            transactionArchive.setTransactionStrategyType(1);
        } else if (LastResourceOptimizeStrategy.class.isInstance(currentStrategy)) {
            transactionArchive.setTransactionStrategyType(3);
        } else {
            transactionArchive.setTransactionStrategyType(0);
        }
        return transactionArchive;
    }

    public int hashCode() {
        TransactionXid transactionXid = this.transactionContext == null ? null : this.transactionContext.getXid();
        int hash = transactionXid == null ? 0 : transactionXid.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!TransactionImpl.class.equals(obj.getClass())) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)obj;
        TransactionContext thisContext = this.transactionContext;
        TransactionContext thatContext = that.transactionContext;
        TransactionXid thisXid = thisContext == null ? null : thisContext.getXid();
        TransactionXid thatXid = thatContext == null ? null : thatContext.getXid();
        return CommonUtils.equals(thisXid, thatXid);
    }

    @Override
    public void registerTransactionListener(TransactionListener listener) {
        this.transactionListenerList.registerTransactionListener(listener);
    }

    @Override
    public void registerTransactionResourceListener(TransactionResourceListener listener) {
        this.resourceListenerList.registerTransactionResourceListener(listener);
    }

    public synchronized void stopTiming() {
        this.setTiming(false);
    }

    public synchronized void changeTransactionTimeout(int timeout) {
        long created = this.transactionContext.getCreatedTime();
        this.transactionContext.setExpiredTime(created + (long)timeout);
    }

    public TransactionStrategy getTransactionStrategy() {
        if (this.transactionStrategy == null) {
            this.transactionStrategy = this.initGetTransactionStrategy();
        }
        return this.transactionStrategy;
    }

    private TransactionStrategy initGetTransactionStrategy() {
        int nativeResNum = this.nativeParticipantList.size();
        int remoteResNum = this.remoteParticipantList.size();
        TransactionStrategy transactionStrategy = null;
        if (this.participantList.isEmpty()) {
            transactionStrategy = new VacantTransactionStrategy();
        } else if (this.participant == null) {
            XATerminatorImpl nativeTerminator = new XATerminatorImpl();
            nativeTerminator.setBeanFactory(this.beanFactory);
            nativeTerminator.getResourceArchives().addAll(this.nativeParticipantList);
            XATerminatorImpl remoteTerminator = new XATerminatorImpl();
            remoteTerminator.setBeanFactory(this.beanFactory);
            remoteTerminator.getResourceArchives().addAll(this.remoteParticipantList);
            transactionStrategy = nativeResNum == 0 ? new SimpleTransactionStrategy(remoteTerminator) : (remoteResNum == 0 ? new SimpleTransactionStrategy(nativeTerminator) : new CommonTransactionStrategy(nativeTerminator, remoteTerminator));
        } else {
            XATerminatorOptd terminatorOne = new XATerminatorOptd();
            terminatorOne.setBeanFactory(this.beanFactory);
            terminatorOne.getResourceArchives().add(this.participant);
            XATerminatorImpl terminatorTwo = new XATerminatorImpl();
            terminatorTwo.setBeanFactory(this.beanFactory);
            terminatorTwo.getResourceArchives().addAll(this.nativeParticipantList);
            terminatorTwo.getResourceArchives().addAll(this.remoteParticipantList);
            int resNumber = nativeResNum + remoteResNum;
            transactionStrategy = resNumber == 0 ? new SimpleTransactionStrategy(terminatorOne) : new LastResourceOptimizeStrategy(terminatorOne, terminatorTwo);
        }
        return transactionStrategy;
    }

    public void recoverTransactionStrategy(int transactionStrategyType) {
        int nativeResNum = this.nativeParticipantList.size();
        int remoteResNum = this.remoteParticipantList.size();
        XATerminatorImpl nativeTerminator = new XATerminatorImpl();
        nativeTerminator.setBeanFactory(this.beanFactory);
        nativeTerminator.getResourceArchives().addAll(this.nativeParticipantList);
        XATerminatorImpl remoteTerminator = new XATerminatorImpl();
        remoteTerminator.setBeanFactory(this.beanFactory);
        remoteTerminator.getResourceArchives().addAll(this.remoteParticipantList);
        if (2 == transactionStrategyType) {
            if (this.participant != null) {
                throw new IllegalStateException();
            }
            if (nativeResNum == 0 || remoteResNum == 0) {
                throw new IllegalStateException();
            }
            this.transactionStrategy = new CommonTransactionStrategy(nativeTerminator, remoteTerminator);
        } else if (1 == transactionStrategyType) {
            if (this.participant == null) {
                if (nativeResNum > 0 && remoteResNum > 0) {
                    throw new IllegalStateException();
                }
                if (nativeResNum == 0 && remoteResNum == 0) {
                    throw new IllegalStateException();
                }
                this.transactionStrategy = nativeResNum == 0 ? new SimpleTransactionStrategy(remoteTerminator) : new SimpleTransactionStrategy(nativeTerminator);
            } else {
                int resNumber = nativeResNum + remoteResNum;
                if (resNumber > 0) {
                    throw new IllegalStateException();
                }
                XATerminatorOptd terminatorOne = new XATerminatorOptd();
                terminatorOne.setBeanFactory(this.beanFactory);
                terminatorOne.getResourceArchives().add(this.participant);
                this.transactionStrategy = new SimpleTransactionStrategy(terminatorOne);
            }
        } else if (3 == transactionStrategyType) {
            if (this.participant == null) {
                throw new IllegalStateException();
            }
            XATerminatorOptd terminatorOne = new XATerminatorOptd();
            terminatorOne.setBeanFactory(this.beanFactory);
            terminatorOne.getResourceArchives().add(this.participant);
            XATerminatorImpl terminatorTwo = new XATerminatorImpl();
            terminatorTwo.setBeanFactory(this.beanFactory);
            terminatorTwo.getResourceArchives().addAll(this.nativeParticipantList);
            terminatorTwo.getResourceArchives().addAll(this.remoteParticipantList);
            this.transactionStrategy = new LastResourceOptimizeStrategy(terminatorOne, terminatorTwo);
        } else {
            if (this.participant != null || nativeResNum > 0 || remoteResNum > 0) {
                throw new IllegalStateException();
            }
            this.transactionStrategy = new VacantTransactionStrategy();
        }
    }

    public void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        this.transactionStrategy = transactionStrategy;
    }

    @Override
    public Object getTransactionalExtra() {
        return this.transactionalExtra;
    }

    @Override
    public void setTransactionalExtra(Object transactionalExtra) {
        this.transactionalExtra = transactionalExtra;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    @Override
    public int getTransactionStatus() {
        return this.transactionStatus;
    }

    @Override
    public void setTransactionStatus(int transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public XAResourceArchive getParticipant() {
        return this.participant;
    }

    public Map<String, XAResourceArchive> getApplicationMap() {
        return this.applicationMap;
    }

    public Map<String, XAResourceArchive> getParticipantMap() {
        return this.participantMap;
    }

    public List<XAResourceArchive> getParticipantList() {
        return this.participantList;
    }

    public void setParticipant(XAResourceArchive participant) {
        this.participant = participant;
    }

    public List<XAResourceArchive> getNativeParticipantList() {
        return this.nativeParticipantList;
    }

    public List<XAResourceArchive> getRemoteParticipantList() {
        return this.remoteParticipantList;
    }
}

