/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.bytesoft.bytejta.TransactionImpl;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionContext;
import org.bytesoft.transaction.TransactionManager;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.supports.TransactionTimer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManagerImpl
implements TransactionManager,
TransactionTimer,
TransactionBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionManagerImpl.class);
    @Inject
    private TransactionBeanFactory beanFactory;
    private int timeoutSeconds = 300;
    private final Map<Thread, org.bytesoft.transaction.Transaction> associatedTxMap = new ConcurrentHashMap<Thread, org.bytesoft.transaction.Transaction>();

    public void begin() throws NotSupportedException, SystemException {
        if (this.getTransaction() != null) {
            throw new NotSupportedException();
        }
        XidFactory xidFactory = this.beanFactory.getXidFactory();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        int timeoutSeconds = this.timeoutSeconds;
        TransactionContext transactionContext = new TransactionContext();
        transactionContext.setPropagatedBy(transactionCoordinator.getIdentifier());
        transactionContext.setCoordinator(true);
        long createdTime = System.currentTimeMillis();
        long expiredTime = createdTime + (long)timeoutSeconds * 1000L;
        transactionContext.setCreatedTime(createdTime);
        transactionContext.setExpiredTime(expiredTime);
        TransactionXid globalXid = xidFactory.createGlobalXid();
        transactionContext.setXid(globalXid);
        TransactionImpl transaction = new TransactionImpl(transactionContext);
        transaction.setBeanFactory(this.beanFactory);
        transaction.setTransactionTimeout(this.timeoutSeconds);
        this.associateThread(transaction);
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        transactionRepository.putTransaction(globalXid, transaction);
        logger.info("[{}] begin-transaction", (Object)ByteUtils.byteArrayToString(globalXid.getGlobalTransactionId()));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        org.bytesoft.transaction.Transaction transaction = this.desociateThread();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        if (transaction.getTransactionStatus() == 4) {
            throw new RollbackException();
        }
        if (transaction.getTransactionStatus() == 3) {
            return;
        }
        if (transaction.getTransactionStatus() == 1) {
            this.rollback(transaction);
            throw new HeuristicRollbackException();
        }
        if (transaction.getTransactionStatus() != 0) {
            throw new IllegalStateException();
        }
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transaction.commit();
            transaction.forgetQuietly();
        }
        catch (IllegalStateException ex) {
            logger.error("Error occurred while committing transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
        catch (SecurityException ex) {
            logger.error("Error occurred while committing transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
        catch (RollbackException rex) {
            logger.error("Error occurred while committing transaction.", (Throwable)rex);
            transaction.forgetQuietly();
            throw rex;
        }
        catch (HeuristicMixedException hmex) {
            logger.error("Error occurred while committing transaction.", (Throwable)hmex);
            transaction.forgetQuietly();
            throw hmex;
        }
        catch (HeuristicRollbackException hrex) {
            logger.error("Error occurred while committing transaction.", (Throwable)hrex);
            transaction.forgetQuietly();
            throw hrex;
        }
        catch (SystemException ex) {
            logger.error("Error occurred while committing transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while committing transaction.", (Throwable)rex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw rex;
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        org.bytesoft.transaction.Transaction transaction = this.desociateThread();
        this.rollback(transaction);
    }

    protected void rollback(org.bytesoft.transaction.Transaction transaction) throws IllegalStateException, SecurityException, SystemException {
        if (transaction == null) {
            throw new IllegalStateException();
        }
        if (transaction.getTransactionStatus() == 4) {
            return;
        }
        if (transaction.getTransactionStatus() == 3) {
            throw new SystemException();
        }
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transaction.rollback();
            transaction.forgetQuietly();
        }
        catch (IllegalStateException ex) {
            logger.error("Error occurred while rolling back transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
        catch (SecurityException ex) {
            logger.error("Error occurred while rolling back transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
        catch (SystemException ex) {
            logger.error("Error occurred while rolling back transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while rolling back transaction.", (Throwable)ex);
            transactionRepository.putErrorTransaction(transactionXid, transaction);
            throw ex;
        }
    }

    public void associateThread(org.bytesoft.transaction.Transaction transaction) {
        this.associatedTxMap.put(Thread.currentThread(), transaction);
    }

    public org.bytesoft.transaction.Transaction desociateThread() {
        return this.associatedTxMap.remove(Thread.currentThread());
    }

    public org.bytesoft.transaction.Transaction suspend() throws RollbackRequiredException, SystemException {
        org.bytesoft.transaction.Transaction transaction = this.desociateThread();
        transaction.suspend();
        return transaction;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, RollbackRequiredException, SystemException {
        if (!TransactionImpl.class.isInstance(tobj)) {
            throw new InvalidTransactionException();
        }
        if (this.getTransaction() != null) {
            throw new IllegalStateException();
        }
        TransactionImpl transaction = (TransactionImpl)tobj;
        transaction.resume();
        this.associateThread(transaction);
    }

    public int getStatus() throws SystemException {
        org.bytesoft.transaction.Transaction transaction = this.getTransaction();
        return transaction == null ? 6 : transaction.getTransactionStatus();
    }

    public org.bytesoft.transaction.Transaction getTransactionQuietly() {
        try {
            return this.getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public org.bytesoft.transaction.Transaction getTransaction() throws SystemException {
        return this.associatedTxMap.get(Thread.currentThread());
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        org.bytesoft.transaction.Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new SystemException();
        }
        transaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        org.bytesoft.transaction.Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new SystemException();
        }
        if (seconds < 0) {
            throw new SystemException();
        }
        if (seconds != 0) {
            ((TransactionImpl)transaction).changeTransactionTimeout(seconds * 1000);
        }
    }

    public void timingExecution() {
        ArrayList<org.bytesoft.transaction.Transaction> expiredTransactions = new ArrayList<org.bytesoft.transaction.Transaction>();
        ArrayList<org.bytesoft.transaction.Transaction> activeTransactions = new ArrayList<org.bytesoft.transaction.Transaction>(this.associatedTxMap.values());
        long current = System.currentTimeMillis();
        Iterator activeItr = activeTransactions.iterator();
        while (activeItr.hasNext()) {
            TransactionContext transactionContext;
            org.bytesoft.transaction.Transaction transaction = (org.bytesoft.transaction.Transaction)activeItr.next();
            if (!transaction.isTiming() || (transactionContext = transaction.getTransactionContext()).getExpiredTime() > current) continue;
            expiredTransactions.add(transaction);
        }
        Iterator expiredItr = expiredTransactions.iterator();
        while (activeItr.hasNext()) {
            org.bytesoft.transaction.Transaction transaction = (org.bytesoft.transaction.Transaction)expiredItr.next();
            if (transaction.getTransactionStatus() != 0 && transaction.getTransactionStatus() != 1) continue;
            this.timingRollback(transaction);
        }
    }

    private void timingRollback(org.bytesoft.transaction.Transaction transaction) {
        TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid globalXid = transactionContext.getXid();
        TransactionRepository transactionRepository = this.beanFactory.getTransactionRepository();
        try {
            transaction.rollback();
            transaction.forgetQuietly();
        }
        catch (Exception ex) {
            transactionRepository.putErrorTransaction(globalXid, transaction);
        }
    }

    public void stopTiming(org.bytesoft.transaction.Transaction transaction) {
        if (TransactionImpl.class.isInstance(transaction)) {
            ((TransactionImpl)transaction).stopTiming();
        }
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

