/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.logging;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.logging.store.VirtualLoggingSystemImpl;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.aware.TransactionEndpointAware;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.logging.LoggingFlushable;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.logging.store.VirtualLoggingListener;
import org.bytesoft.transaction.logging.store.VirtualLoggingRecord;
import org.bytesoft.transaction.recovery.TransactionRecoveryCallback;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleTransactionLogger
extends VirtualLoggingSystemImpl
implements TransactionLogger,
LoggingFlushable,
TransactionBeanFactoryAware,
TransactionEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(SampleTransactionLogger.class);
    @Inject
    private TransactionBeanFactory beanFactory;
    private String endpoint;

    public void createTransaction(TransactionArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), archive);
            this.create(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while creating transaction-archive.", (Throwable)rex);
        }
    }

    public void updateTransaction(TransactionArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), archive);
            this.modify(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying transaction-archive.", (Throwable)rex);
        }
    }

    public void deleteTransaction(TransactionArchive archive) {
        try {
            this.delete(archive.getXid());
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while deleting transaction-archive.", (Throwable)rex);
        }
    }

    public void updateResource(XAResourceArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), archive);
            this.modify(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying resource-archive.", (Throwable)rex);
        }
    }

    public void recover(TransactionRecoveryCallback callback) {
        final HashMap xidMap = new HashMap();
        final ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        final XidFactory xidFactory = this.beanFactory.getXidFactory();
        this.traversal(new VirtualLoggingListener(){

            public void recvOperation(VirtualLoggingRecord action) {
                Xid xid = action.getIdentifier();
                int operator = action.getOperator();
                if (3 == operator) {
                    xidMap.remove(xid);
                } else if (!xidMap.containsKey(xid)) {
                    xidMap.put(xid, null);
                }
            }
        });
        this.traversal(new VirtualLoggingListener(){

            public void recvOperation(VirtualLoggingRecord action) {
                Xid xid = action.getIdentifier();
                if (xidMap.containsKey(xid)) {
                    this.execOperation(action);
                }
            }

            public void execOperation(VirtualLoggingRecord action) {
                Xid identifier = action.getIdentifier();
                TransactionXid xid = xidFactory.createGlobalXid(identifier.getGlobalTransactionId());
                Object obj = deserializer.deserialize(xid, action.getValue());
                if (TransactionArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)obj;
                    xidMap.put(identifier, archive);
                } else if (XAResourceArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)xidMap.get(identifier);
                    if (archive == null) {
                        logger.error("Error occurred while recovering resource archive: {}", obj);
                        return;
                    }
                    XAResourceArchive resourceArchive = (XAResourceArchive)obj;
                    boolean matched = false;
                    List<XAResourceArchive> nativeResources = archive.getNativeResources();
                    for (int i = 0; !matched && nativeResources != null && i < nativeResources.size(); ++i) {
                        XAResourceArchive element = nativeResources.get(i);
                        if (!resourceArchive.getXid().equals(element.getXid())) continue;
                        matched = true;
                        nativeResources.set(i, resourceArchive);
                    }
                    XAResourceArchive optimizedResource = archive.getOptimizedResource();
                    if (!matched && optimizedResource != null && resourceArchive.getXid().equals(optimizedResource.getXid())) {
                        matched = true;
                        archive.setOptimizedResource(resourceArchive);
                    }
                    List<XAResourceArchive> remoteResources = archive.getRemoteResources();
                    for (int i = 0; !matched && remoteResources != null && i < remoteResources.size(); ++i) {
                        XAResourceArchive element = remoteResources.get(i);
                        if (!resourceArchive.getXid().equals(element.getXid())) continue;
                        matched = true;
                        remoteResources.set(i, resourceArchive);
                    }
                    if (!matched) {
                        logger.error("Error occurred while recovering resource archive: {}, invalid resoure!", obj);
                    }
                }
            }
        });
        for (Map.Entry entry : xidMap.entrySet()) {
            TransactionArchive archive = (TransactionArchive)entry.getValue();
            if (archive == null) continue;
            try {
                callback.recover(archive);
            }
            catch (RuntimeException rex) {
                logger.error("Error occurred while recovering transaction(xid= {}).", (Object)archive.getXid(), (Object)rex);
            }
        }
    }

    public File getDefaultDirectory() {
        String address = StringUtils.trimToEmpty((String)this.endpoint);
        File directory = new File(String.format("bytejta/%s", address.replaceAll("[^a-zA-Z_0-9]", "_")));
        if (!directory.exists()) {
            try {
                directory.mkdirs();
            }
            catch (SecurityException ex) {
                logger.error("Error occurred while creating directory {}!", (Object)directory.getAbsolutePath(), (Object)ex);
            }
        }
        return directory;
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getLoggingFilePrefix() {
        return "bytejta-";
    }

    public String getLoggingIdentifier() {
        return "org.bytesoft.bytejta.logging.sample";
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

