/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.logging.store;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.spi.work.Work;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.logging.store.VirtualLoggingFile;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.logging.store.VirtualLoggingKey;
import org.bytesoft.transaction.logging.store.VirtualLoggingListener;
import org.bytesoft.transaction.logging.store.VirtualLoggingRecord;
import org.bytesoft.transaction.logging.store.VirtualLoggingSystem;
import org.bytesoft.transaction.logging.store.VirtualLoggingTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualLoggingSystemImpl
implements VirtualLoggingSystem,
VirtualLoggingTrigger,
Work {
    static final Logger logger = LoggerFactory.getLogger(VirtualLoggingSystemImpl.class);
    private final Lock lock = new ReentrantLock();
    private final Lock timingLock = new ReentrantLock();
    private final Condition timingCondition = this.timingLock.newCondition();
    private boolean released;
    private File directory;
    private VirtualLoggingFile master;
    private VirtualLoggingFile slaver;
    private boolean optimized = true;

    public void construct() throws IOException {
        if (this.directory == null) {
            this.directory = this.getDefaultDirectory();
        }
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new RuntimeException();
        }
        File fmaster = new File(this.directory, String.format("%s1.log", this.getLoggingFilePrefix()));
        File fslaver = new File(this.directory, String.format("%s2.log", this.getLoggingFilePrefix()));
        VirtualLoggingFile masterMgr = this.createTransactionLogging(fmaster);
        VirtualLoggingFile slaverMgr = this.createTransactionLogging(fslaver);
        masterMgr.initialize(true);
        slaverMgr.initialize(false);
        this.initialize(masterMgr, slaverMgr);
        this.flushAllIfNecessary();
    }

    private void initialize(VirtualLoggingFile prev, VirtualLoggingFile next) {
        boolean prevMaster = prev.isMaster();
        boolean nextMaster = next.isMaster();
        if (prevMaster && nextMaster) {
            throw new IllegalStateException();
        }
        if (!prevMaster && !nextMaster) {
            this.fixSwitchError(prev, next);
        } else if (prevMaster) {
            this.master = prev;
            this.slaver = next;
            this.master.clearMarkedFlag();
            this.slaver.clearMarkedFlag();
        } else {
            this.master = next;
            this.slaver = prev;
            this.master.clearMarkedFlag();
            this.slaver.clearMarkedFlag();
        }
    }

    private void fixSwitchError(VirtualLoggingFile prev, VirtualLoggingFile next) {
        boolean prevMarked = prev.isMarked();
        boolean nextMarked = next.isMarked();
        if (prevMarked && nextMarked) {
            throw new IllegalStateException();
        }
        if (!prevMarked && !nextMarked) {
            throw new IllegalStateException();
        }
        if (prevMarked) {
            prev.fixSwitchError();
            this.master = prev;
            this.slaver = next;
        } else {
            next.fixSwitchError();
            this.master = next;
            this.slaver = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.released) {
            Object var3_2;
            try {
                try {
                    this.timingLock.lock();
                    this.timingCondition.await(30L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    logger.debug(ex.getMessage(), (Throwable)ex);
                    var3_2 = null;
                    this.timingLock.unlock();
                }
                var3_2 = null;
                this.timingLock.unlock();
            }
            catch (Throwable throwable) {
                var3_2 = null;
                this.timingLock.unlock();
                throw throwable;
            }
            this.syncMasterAndSlaver();
            this.swapMasterAndSlaver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireSwapImmediately() {
        try {
            this.timingLock.lock();
            this.timingCondition.signalAll();
            Object var2_1 = null;
            this.timingLock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.timingLock.unlock();
            throw throwable;
        }
    }

    @Override
    public void traversal(VirtualLoggingListener listener) {
        this.master.prepareForReading();
        while (true) {
            byte[] byteArray = null;
            try {
                byteArray = this.master.read();
            }
            catch (RuntimeException rex) {
                byteArray = new byte[]{};
            }
            if (byteArray.length == 0) break;
            byte[] keyByteArray = new byte[20];
            System.arraycopy(byteArray, 0, keyByteArray, 0, keyByteArray.length);
            byte operator = byteArray[keyByteArray.length];
            byte[] valueByteArray = new byte[byteArray.length - 20 - 1 - 4];
            System.arraycopy(byteArray, 25, valueByteArray, 0, valueByteArray.length);
            VirtualLoggingKey xid = new VirtualLoggingKey();
            xid.setGlobalTransactionId(keyByteArray);
            VirtualLoggingRecord record = new VirtualLoggingRecord();
            record.setIdentifier(xid);
            record.setOperator(operator);
            record.setContent(byteArray);
            record.setValue(valueByteArray);
            listener.recvOperation(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Xid xid, byte[] textByteArray) {
        byte[] keyByteArray = xid.getGlobalTransactionId();
        byte[] sizeByteArray = ByteUtils.intToByteArray(textByteArray.length);
        byte[] byteArray = new byte[keyByteArray.length + 1 + sizeByteArray.length + textByteArray.length];
        System.arraycopy(keyByteArray, 0, byteArray, 0, keyByteArray.length);
        byteArray[keyByteArray.length] = 1;
        System.arraycopy(sizeByteArray, 0, byteArray, keyByteArray.length + 1, sizeByteArray.length);
        System.arraycopy(textByteArray, 0, byteArray, keyByteArray.length + 1 + sizeByteArray.length, textByteArray.length);
        try {
            this.lock.lock();
            this.master.write(byteArray);
            this.flushMasterIfNecessary();
            Object var7_6 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Xid xid) {
        byte[] keyByteArray = xid.getGlobalTransactionId();
        byte[] sizeByteArray = ByteUtils.intToByteArray(0);
        byte[] byteArray = new byte[keyByteArray.length + 1 + sizeByteArray.length];
        System.arraycopy(keyByteArray, 0, byteArray, 0, keyByteArray.length);
        byteArray[keyByteArray.length] = 3;
        System.arraycopy(sizeByteArray, 0, byteArray, keyByteArray.length + 1, sizeByteArray.length);
        try {
            this.lock.lock();
            this.master.write(byteArray);
            this.flushMasterIfNecessary();
            Object var6_5 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(Xid xid, byte[] textByteArray) {
        byte[] keyByteArray = xid.getGlobalTransactionId();
        byte[] sizeByteArray = ByteUtils.intToByteArray(textByteArray.length);
        byte[] byteArray = new byte[keyByteArray.length + 1 + sizeByteArray.length + textByteArray.length];
        System.arraycopy(keyByteArray, 0, byteArray, 0, keyByteArray.length);
        byteArray[keyByteArray.length] = 2;
        System.arraycopy(sizeByteArray, 0, byteArray, keyByteArray.length + 1, sizeByteArray.length);
        System.arraycopy(textByteArray, 0, byteArray, keyByteArray.length + 1 + sizeByteArray.length, textByteArray.length);
        try {
            this.lock.lock();
            this.master.write(byteArray);
            this.flushMasterIfNecessary();
            Object var7_6 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void syncMasterAndSlaver() {
        this.master.prepareForReading();
        Map<Xid, Boolean> recordMap = this.syncStepOne();
        this.master.prepareForReading();
        this.syncStepTwo(recordMap);
        this.flushSlaverIfNecessary();
    }

    public Map<Xid, Boolean> syncStepOne() {
        HashMap<Xid, Boolean> recordMap = new HashMap<Xid, Boolean>();
        while (true) {
            byte[] byteArray = null;
            try {
                byteArray = this.master.read();
            }
            catch (RuntimeException rex) {
                byteArray = new byte[]{};
            }
            if (byteArray.length == 0) break;
            byte[] keyByteArray = new byte[20];
            System.arraycopy(byteArray, 0, keyByteArray, 0, keyByteArray.length);
            byte operator = byteArray[keyByteArray.length];
            VirtualLoggingKey xid = new VirtualLoggingKey();
            xid.setGlobalTransactionId(keyByteArray);
            VirtualLoggingRecord record = new VirtualLoggingRecord();
            record.setIdentifier(xid);
            record.setOperator(operator);
            record.setContent(byteArray);
            if (operator != 3) continue;
            recordMap.put(xid, true);
        }
        return recordMap;
    }

    public void syncStepTwo(Map<Xid, Boolean> recordMap) {
        ArrayList<VirtualLoggingRecord> recordList = new ArrayList<VirtualLoggingRecord>();
        while (true) {
            byte[] byteArray = null;
            try {
                byteArray = this.master.read();
            }
            catch (RuntimeException rex) {
                byteArray = new byte[]{};
            }
            if (byteArray.length == 0) break;
            byte[] keyByteArray = new byte[20];
            System.arraycopy(byteArray, 0, keyByteArray, 0, keyByteArray.length);
            byte operator = byteArray[keyByteArray.length];
            VirtualLoggingKey xid = new VirtualLoggingKey();
            xid.setGlobalTransactionId(keyByteArray);
            VirtualLoggingRecord record = new VirtualLoggingRecord();
            record.setIdentifier(xid);
            record.setOperator(operator);
            record.setContent(byteArray);
            if (recordMap.containsKey(xid)) continue;
            recordList.add(record);
        }
        for (int i = 0; i < recordList.size(); ++i) {
            VirtualLoggingRecord record = (VirtualLoggingRecord)recordList.get(i);
            Xid xid = record.getIdentifier();
            if (recordMap.containsKey(xid)) continue;
            byte[] byteArray = record.getContent();
            this.slaver.write(byteArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapMasterAndSlaver() {
        try {
            this.lock.lock();
            this.syncStepTwo(new HashMap<Xid, Boolean>());
            this.slaver.markAsMaster();
            this.master.switchToSlaver();
            this.slaver.switchToMaster();
            this.flushAllIfNecessary();
            VirtualLoggingFile theNextMaster = this.slaver;
            this.slaver = this.master;
            this.master = theNextMaster;
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void flushAllIfNecessary() {
        this.flushMasterIfNecessary();
        this.flushSlaverIfNecessary();
    }

    private void flushMasterIfNecessary() {
        if (!this.optimized) {
            this.master.flushImmediately();
        }
    }

    private void flushSlaverIfNecessary() {
        if (!this.optimized) {
            this.slaver.flushImmediately();
        }
    }

    public void flushImmediately() {
        this.master.flushImmediately();
    }

    public void shutdown() {
        this.master.flushImmediately();
        this.slaver.flushImmediately();
        this.master.closeQuietly();
        this.slaver.closeQuietly();
    }

    public void release() {
        this.released = true;
    }

    public abstract File getDefaultDirectory();

    public abstract int getMajorVersion();

    public abstract int getMinorVersion();

    public abstract String getLoggingIdentifier();

    public abstract String getLoggingFilePrefix();

    public VirtualLoggingFile createTransactionLogging(File file) throws IOException {
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        VirtualLoggingFile logging = new VirtualLoggingFile(file, major, minor);
        logging.setTrigger(this);
        logging.setIdentifier(this.getLoggingIdentifier().getBytes());
        return logging;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }
}

