/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.resource;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.TransactionLogger;
import org.bytesoft.transaction.resource.XATerminator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XATerminatorImpl
implements XATerminator {
    static final Logger logger = LoggerFactory.getLogger(XATerminatorImpl.class);
    private TransactionBeanFactory beanFactory;
    private final List<XAResourceArchive> resources = new ArrayList<XAResourceArchive>();

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        int globalVote = 3;
        for (int i = 0; i < this.resources.size(); ++i) {
            boolean prepared;
            XAResourceArchive archive = this.resources.get(i);
            boolean bl = prepared = archive.getVote() != -1;
            if (prepared) {
                globalVote = archive.getVote() == 3 ? globalVote : 0;
            } else {
                int branchVote = archive.prepare(archive.getXid());
                archive.setVote(branchVote);
                if (branchVote == 3) {
                    archive.setReadonly(true);
                    archive.setCompleted(true);
                } else {
                    globalVote = 0;
                }
                transactionLogger.updateResource(archive);
            }
            logger.info("[{}] prepare: xares= {}, branch= {}, vote= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), archive.getVote()});
        }
        return globalVote;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        if (onePhase) {
            this.fireOnePhaseCommit(xid);
        } else {
            this.fireTwoPhaseCommit(xid);
        }
    }

    private void fireOnePhaseCommit(Xid xid) throws XAException {
        block21: {
            if (this.resources.size() == 0) {
                throw new XAException(3);
            }
            if (this.resources.size() > 1) {
                this.rollback(xid);
                throw new XAException(6);
            }
            TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
            XAResourceArchive archive = this.resources.get(0);
            if (archive.isCommitted() && archive.isRolledback()) {
                throw new XAException(5);
            }
            if (archive.isCommitted()) {
                return;
            }
            if (archive.isReadonly()) {
                throw new XAException(3);
            }
            if (archive.isRolledback()) {
                throw new XAException(6);
            }
            boolean updateRequired = true;
            try {
                try {
                    this.invokeOnePhaseCommit(archive);
                    archive.setCommitted(true);
                    archive.setCompleted(true);
                    logger.info("[{}] commit: xares= {}, branch= {}, opc= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), true});
                }
                catch (XAException xaex) {
                    logger.error("[{}] Error occurred while committing xa-resource: xares= {}, branch= {}, code= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), xaex.errorCode, xaex});
                    switch (xaex.errorCode) {
                        case 7: {
                            archive.setHeuristic(true);
                            archive.setCommitted(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case 8: {
                            archive.setHeuristic(true);
                            throw xaex;
                        }
                        case 5: {
                            archive.setHeuristic(true);
                            archive.setCommitted(true);
                            archive.setRolledback(true);
                            archive.setCompleted(true);
                            throw xaex;
                        }
                        case 6: {
                            archive.setHeuristic(true);
                            archive.setRolledback(true);
                            archive.setCompleted(true);
                            throw xaex;
                        }
                        case -7: {
                            updateRequired = false;
                            throw new XAException(8);
                        }
                        default: {
                            updateRequired = false;
                            throw new XAException(-3);
                        }
                    }
                    Object var7_6 = null;
                    if (updateRequired) {
                        transactionLogger.updateResource(archive);
                    }
                    break block21;
                }
                catch (RuntimeException rex) {
                    logger.error("[{}] Error occurred while committing xa-resource: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), rex});
                    updateRequired = false;
                    throw new XAException(8);
                }
                Object var7_5 = null;
                if (updateRequired) {
                    transactionLogger.updateResource(archive);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (updateRequired) {
                    transactionLogger.updateResource(archive);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTwoPhaseCommit(Xid xid) throws XAException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean committedExists = false;
        boolean rolledbackExists = false;
        boolean unFinishExists = false;
        boolean errorExists = false;
        for (int i = this.resources.size() - 1; i >= 0; --i) {
            Object var13_14;
            XAResourceArchive archive = this.resources.get(i);
            if (archive.isCommitted() && archive.isRolledback()) {
                committedExists = true;
                rolledbackExists = true;
                continue;
            }
            if (archive.isCommitted()) {
                committedExists = true;
                continue;
            }
            if (archive.isReadonly()) continue;
            if (archive.isRolledback()) {
                rolledbackExists = true;
                continue;
            }
            Xid branchXid = archive.getXid();
            boolean updateRequired = true;
            try {
                try {
                    this.invokeTwoPhaseCommit(archive);
                    committedExists = true;
                    archive.setCommitted(true);
                    archive.setCompleted(true);
                    logger.info("[{}] commit: xares= {}, branch= {}, onePhaseCommit= {}", new Object[]{ByteUtils.byteArrayToString(branchXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(branchXid.getBranchQualifier()), false});
                }
                catch (XAException xaex) {
                    logger.error("[{}] Error occurred while committing xa-resource: xares= {}, branch= {}, code= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), xaex.errorCode, xaex});
                    switch (xaex.errorCode) {
                        case 8: {
                            archive.setHeuristic(true);
                            unFinishExists = true;
                            break;
                        }
                        case 5: {
                            committedExists = true;
                            rolledbackExists = true;
                            archive.setCommitted(true);
                            archive.setRolledback(true);
                            archive.setHeuristic(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case 7: {
                            committedExists = true;
                            archive.setCommitted(true);
                            archive.setHeuristic(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case 6: {
                            rolledbackExists = true;
                            archive.setRolledback(true);
                            archive.setHeuristic(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case -7: {
                            unFinishExists = true;
                            updateRequired = false;
                            break;
                        }
                        case 3: {
                            archive.setReadonly(true);
                            break;
                        }
                        default: {
                            errorExists = true;
                            updateRequired = false;
                        }
                    }
                    var13_14 = null;
                    if (!updateRequired) continue;
                    transactionLogger.updateResource(archive);
                    continue;
                }
                catch (RuntimeException rex) {
                    logger.error("[{}] Error occurred while committing xa-resource: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), rex});
                    unFinishExists = true;
                    updateRequired = false;
                    var13_14 = null;
                    if (!updateRequired) continue;
                    transactionLogger.updateResource(archive);
                    continue;
                }
                var13_14 = null;
                if (!updateRequired) continue;
                transactionLogger.updateResource(archive);
                continue;
            }
            catch (Throwable throwable) {
                var13_14 = null;
                if (updateRequired) {
                    transactionLogger.updateResource(archive);
                }
                throw throwable;
            }
        }
        if (committedExists && rolledbackExists) {
            throw new XAException(5);
        }
        if (unFinishExists) {
            throw new XAException(8);
        }
        if (errorExists) {
            throw new XAException(-3);
        }
        if (rolledbackExists) {
            throw new XAException(6);
        }
        if (!committedExists) {
            throw new XAException(3);
        }
    }

    private void invokeOnePhaseCommit(XAResourceArchive archive) throws XAException {
        try {
            archive.commit(archive.getXid(), true);
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    logger.warn("An error occurred in one phase commit: {}, transaction has been completed!", (Object)ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()));
                    throw xaex;
                }
                case -7: {
                    logger.warn("An error occurred in one phase commit: {}", (Object)ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()));
                    throw xaex;
                }
                case -6: 
                case -5: 
                case -4: {
                    logger.warn("An error occurred in one phase commit: {}", (Object)ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()));
                    throw new XAException(-3);
                }
            }
            logger.warn("An error occurred in one phase commit: {}, transaction has been rolled back!", (Object)ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()));
            throw new XAException(6);
        }
    }

    private void invokeTwoPhaseCommit(XAResourceArchive archive) throws XAException {
        try {
            archive.commit(archive.getXid(), false);
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    throw xaex;
                }
                case -4: {
                    throw new XAException(3);
                }
                case -7: {
                    throw xaex;
                }
                case -6: 
                case -5: {
                    XAException error = new XAException(-3);
                    error.initCause(xaex);
                    throw error;
                }
            }
            XAException xarb = new XAException(6);
            xarb.initCause(xaex);
            throw xarb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        TransactionLogger transactionLogger = this.beanFactory.getTransactionLogger();
        boolean committedExists = false;
        boolean rolledbackExists = false;
        boolean unFinishExists = false;
        boolean errorExists = false;
        for (int i = 0; i < this.resources.size(); ++i) {
            Object var12_13;
            XAResourceArchive archive = this.resources.get(i);
            if (archive.isCommitted() && archive.isRolledback()) {
                committedExists = true;
                rolledbackExists = true;
                continue;
            }
            if (archive.isRolledback()) {
                rolledbackExists = true;
                continue;
            }
            if (archive.isReadonly()) continue;
            if (archive.isCommitted()) {
                committedExists = true;
                continue;
            }
            boolean updateRequired = true;
            try {
                try {
                    this.invokeRollback(archive);
                    rolledbackExists = true;
                    archive.setRolledback(true);
                    archive.setCompleted(true);
                    logger.info("[{}] rollback: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier())});
                }
                catch (XAException xaex) {
                    logger.error("[{}] Error occurred while rolling back xa-resource: xares= {}, branch= {}, code= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), xaex.errorCode, xaex});
                    switch (xaex.errorCode) {
                        case 8: {
                            unFinishExists = true;
                            archive.setHeuristic(true);
                            break;
                        }
                        case 5: {
                            committedExists = true;
                            rolledbackExists = true;
                            archive.setCommitted(true);
                            archive.setRolledback(true);
                            archive.setHeuristic(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case 7: {
                            committedExists = true;
                            archive.setCommitted(true);
                            archive.setHeuristic(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case 6: {
                            rolledbackExists = true;
                            archive.setRolledback(true);
                            archive.setHeuristic(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case 3: {
                            archive.setReadonly(true);
                            archive.setCompleted(true);
                            break;
                        }
                        case -7: {
                            unFinishExists = true;
                            updateRequired = false;
                            break;
                        }
                        default: {
                            errorExists = true;
                            updateRequired = false;
                        }
                    }
                    var12_13 = null;
                    if (!updateRequired) continue;
                    transactionLogger.updateResource(archive);
                    continue;
                }
                catch (RuntimeException rex) {
                    unFinishExists = true;
                    updateRequired = false;
                    logger.error("[{}] Error occurred while rolling back xa-resource: xares= {}, branch= {}", new Object[]{ByteUtils.byteArrayToString(archive.getXid().getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(archive.getXid().getBranchQualifier()), rex});
                    var12_13 = null;
                    if (!updateRequired) continue;
                    transactionLogger.updateResource(archive);
                    continue;
                }
                var12_13 = null;
                if (!updateRequired) continue;
                transactionLogger.updateResource(archive);
                continue;
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (updateRequired) {
                    transactionLogger.updateResource(archive);
                }
                throw throwable;
            }
        }
        if (committedExists && rolledbackExists) {
            throw new XAException(5);
        }
        if (unFinishExists) {
            throw new XAException(8);
        }
        if (errorExists) {
            throw new XAException(-3);
        }
        if (committedExists) {
            throw new XAException(7);
        }
        if (!rolledbackExists) {
            throw new XAException(3);
        }
    }

    private void invokeRollback(XAResourceArchive archive) throws XAException {
        try {
            archive.rollback(archive.getXid());
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    throw xaex;
                }
                case -7: {
                    XAException xrhaz = new XAException(8);
                    xrhaz.initCause(xaex);
                    throw xrhaz;
                }
                case -4: {
                    if (archive.isReadonly()) {
                        throw new XAException(3);
                    }
                    if (archive.getVote() == -1) break;
                    if (archive.getVote() == 3) {
                        throw new XAException(3);
                    }
                    if (archive.getVote() == 0) {
                        throw new XAException(-3);
                    }
                    throw new XAException(-3);
                }
                case -6: 
                case -5: {
                    throw new XAException(-3);
                }
                default: {
                    XAException xarb = new XAException(6);
                    xarb.initCause(xaex);
                    throw xarb;
                }
            }
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        throw new XAException(-7);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        throw new XAException(-7);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        block7: for (int i = 0; i < this.resources.size(); ++i) {
            XAResourceArchive archive = this.resources.get(i);
            Xid currentXid = archive.getXid();
            if (!archive.isHeuristic()) continue;
            try {
                Xid branchXid = archive.getXid();
                archive.forget(branchXid);
                continue;
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case -3: {
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                        continue block7;
                    }
                    case -7: {
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                        continue block7;
                    }
                    case -6: 
                    case -5: 
                    case -4: {
                        continue block7;
                    }
                    default: {
                        logger.error("[{}] forget: xares= {}, branch={}, error= {}", new Object[]{ByteUtils.byteArrayToString(currentXid.getGlobalTransactionId()), archive, ByteUtils.byteArrayToString(currentXid.getBranchQualifier()), xae.errorCode});
                    }
                }
            }
        }
    }

    @Override
    public List<XAResourceArchive> getResourceArchives() {
        return this.resources;
    }

    public TransactionBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(TransactionBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

