/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.strategy;

import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.TransactionStrategy;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.resource.XATerminator;

public class LastResourceOptimizeStrategy
implements TransactionStrategy {
    private final XATerminator terminatorOne;
    private final XATerminator terminatorTwo;

    public LastResourceOptimizeStrategy(XATerminator terminatorOne, XATerminator terminatorTwo) {
        if (terminatorOne == null || terminatorOne.getResourceArchives().size() != 1) {
            throw new IllegalStateException();
        }
        if (terminatorTwo == null || terminatorTwo.getResourceArchives().isEmpty()) {
            throw new IllegalStateException();
        }
        this.terminatorOne = terminatorOne;
        this.terminatorTwo = terminatorTwo;
    }

    public int prepare(Xid xid) throws RollbackRequiredException, CommitRequiredException {
        int vote = 3;
        try {
            vote = this.terminatorTwo.prepare(xid);
        }
        catch (Exception ex) {
            throw new RollbackRequiredException();
        }
        try {
            this.terminatorOne.commit(xid, true);
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    throw new CommitRequiredException();
                }
                case 6: {
                    throw new RollbackRequiredException();
                }
                case 5: {
                    throw new CommitRequiredException();
                }
                case 8: {
                    throw new CommitRequiredException();
                }
                case 3: {
                    return vote;
                }
            }
            throw new RollbackRequiredException();
        }
        catch (RuntimeException rex) {
            throw new RollbackRequiredException();
        }
        throw new CommitRequiredException();
    }

    public void commit(Xid xid) throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        try {
            this.terminatorTwo.commit(xid, false);
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    break;
                }
                case 6: {
                    throw new HeuristicRollbackException();
                }
                case 5: {
                    throw new HeuristicMixedException();
                }
                case 8: {
                    throw new SystemException();
                }
                case 3: {
                    break;
                }
                case -3: {
                    throw new SystemException();
                }
                default: {
                    throw new SystemException();
                }
            }
        }
        catch (RuntimeException ex) {
            throw new SystemException();
        }
    }

    public void rollback(Xid xid) throws HeuristicMixedException, HeuristicCommitException, IllegalStateException, SystemException {
        boolean committedExists = false;
        boolean rolledbackExists = false;
        boolean unFinishExists = false;
        boolean errorExists = false;
        try {
            this.terminatorOne.rollback(xid);
            rolledbackExists = true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    committedExists = true;
                    break;
                }
                case 6: {
                    rolledbackExists = true;
                    break;
                }
                case 5: {
                    committedExists = true;
                    rolledbackExists = true;
                    break;
                }
                case 8: {
                    unFinishExists = true;
                    break;
                }
                case 3: {
                    break;
                }
                case -3: {
                    errorExists = true;
                    break;
                }
                default: {
                    errorExists = true;
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            unFinishExists = true;
        }
        try {
            this.terminatorTwo.rollback(xid);
            rolledbackExists = true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case 7: {
                    committedExists = true;
                    break;
                }
                case 6: {
                    rolledbackExists = true;
                    break;
                }
                case 5: {
                    committedExists = true;
                    rolledbackExists = true;
                    break;
                }
                case 8: {
                    unFinishExists = true;
                    break;
                }
                case 3: {
                    break;
                }
                case -3: {
                    errorExists = true;
                    break;
                }
                default: {
                    errorExists = true;
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            unFinishExists = true;
        }
        if (committedExists && rolledbackExists) {
            throw new HeuristicMixedException();
        }
        if (unFinishExists) {
            throw new SystemException();
        }
        if (errorExists) {
            throw new SystemException();
        }
        if (committedExists) {
            throw new HeuristicCommitException();
        }
    }
}

