/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.strategy;

import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.TransactionStrategy;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.resource.XATerminator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTransactionStrategy
implements TransactionStrategy {
    static final Logger logger = LoggerFactory.getLogger(SimpleTransactionStrategy.class);
    private final XATerminator terminator;

    public SimpleTransactionStrategy(XATerminator terminator) {
        if (terminator == null || terminator.getResourceArchives().isEmpty()) {
            throw new IllegalStateException();
        }
        this.terminator = terminator;
    }

    public int prepare(Xid xid) throws RollbackRequiredException, CommitRequiredException {
        try {
            return this.terminator.prepare(xid);
        }
        catch (XAException xaex) {
            throw new RollbackRequiredException();
        }
        catch (RuntimeException xaex) {
            throw new RollbackRequiredException();
        }
    }

    public void commit(Xid xid) throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, SystemException {
        try {
            this.terminator.commit(xid, false);
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 7: {
                    break;
                }
                case 5: {
                    throw new HeuristicMixedException();
                }
                case 6: {
                    throw new HeuristicRollbackException();
                }
                default: {
                    logger.error("Unknown state in committing transaction phase.", (Throwable)xaex);
                    throw new SystemException();
                }
            }
        }
        catch (RuntimeException rex) {
            logger.error("Unknown state in committing transaction phase.", (Throwable)rex);
            throw new SystemException();
        }
    }

    public void rollback(Xid xid) throws HeuristicMixedException, HeuristicCommitException, IllegalStateException, SystemException {
        try {
            this.terminator.rollback(xid);
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 6: {
                    break;
                }
                case 5: {
                    throw new HeuristicMixedException();
                }
                case 7: {
                    throw new HeuristicCommitException();
                }
                default: {
                    logger.error("Unknown state in rollingback transaction phase.", (Throwable)xaex);
                    throw new SystemException();
                }
            }
        }
        catch (RuntimeException rex) {
            logger.error("Unknown state in rollingback transaction phase.", (Throwable)rex);
            throw new SystemException();
        }
    }
}

