/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import org.bytesoft.bytejta.supports.jdbc.LocalXAResource;
import org.bytesoft.bytejta.supports.jdbc.LogicalConnection;
import org.bytesoft.bytejta.supports.resource.LocalXAResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalXAConnection
implements XAConnection {
    static final Logger logger = LoggerFactory.getLogger(LocalXAConnection.class);
    private String resourceId;
    private final Connection connection;
    private final LocalXAResource xaResource = new LocalXAResource(this);
    private boolean underlyingConCloseRequired = false;
    private boolean physicalConnectionReleased = false;
    private int physicalConnectionSharingCount = 0;
    private transient LocalXAResourceDescriptor descriptor;
    private final Set<ConnectionEventListener> listeners = new HashSet<ConnectionEventListener>();

    public LocalXAConnection(Connection connection) {
        this.connection = connection;
    }

    protected Connection getPhysicalConnection() {
        return this.connection;
    }

    public LogicalConnection getConnection() throws SQLException {
        if (this.physicalConnectionReleased) {
            throw new SQLException("LocalXAConnection has already been closed!");
        }
        LogicalConnection logicalConnection = new LogicalConnection(this, this.connection);
        ++this.physicalConnectionSharingCount;
        this.underlyingConCloseRequired = false;
        return logicalConnection;
    }

    public void closeLogicalConnection() throws SQLException {
        --this.physicalConnectionSharingCount;
        if (this.physicalConnectionSharingCount == 0) {
            this.underlyingConCloseRequired = true;
        }
    }

    private void releaseConnection() {
        if (!this.physicalConnectionReleased) {
            try {
                this.connection.close();
                this.fireConnectionClosed();
            }
            catch (SQLException ex) {
                logger.debug("Error occurred while closing connection!", (Throwable)ex);
                this.fireConnectionErrorOccurred();
            }
            catch (RuntimeException ex) {
                logger.debug("Error occurred while closing connection!", (Throwable)ex);
                this.fireConnectionErrorOccurred();
            }
            finally {
                this.physicalConnectionReleased = true;
            }
        }
    }

    public void commitLocalTransaction() throws SQLException {
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SQLException(ex);
        }
    }

    public void rollbackLocalTransaction() throws SQLException {
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SQLException(ex);
        }
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception ex) {
            logger.warn("Error occurred while closing physical connection.", (Throwable)ex);
        }
    }

    public void close() throws SQLException {
        if (!this.underlyingConCloseRequired) {
            logger.warn("Illegal state: there is at least one connection that is not closed!");
        }
        this.releaseConnection();
    }

    private void fireConnectionClosed() {
        for (ConnectionEventListener listener : this.listeners) {
            try {
                listener.connectionClosed(new ConnectionEvent(this));
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void fireConnectionErrorOccurred() {
        for (ConnectionEventListener listener : this.listeners) {
            try {
                listener.connectionErrorOccurred(new ConnectionEvent(this));
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener paramConnectionEventListener) {
        this.listeners.add(paramConnectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener paramConnectionEventListener) {
        this.listeners.remove(paramConnectionEventListener);
    }

    public void addStatementEventListener(StatementEventListener paramStatementEventListener) {
    }

    public void removeStatementEventListener(StatementEventListener paramStatementEventListener) {
    }

    public LocalXAResourceDescriptor getXAResource() throws SQLException {
        if (this.descriptor == null) {
            LocalXAResourceDescriptor xares = new LocalXAResourceDescriptor();
            xares.setIdentifier(this.resourceId);
            xares.setDelegate(this.xaResource);
            this.descriptor = xares;
        }
        return this.descriptor;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }
}

