/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.supports.jdbc.LocalXAConnection;
import org.bytesoft.common.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalXAResource
implements XAResource {
    static final Logger logger = LoggerFactory.getLogger(LocalXAResource.class);
    private LocalXAConnection managedConnection;
    private Xid currentXid;
    private Xid suspendXid;
    private boolean suspendAutoCommit;
    private boolean originalAutoCommit;
    private boolean loggingRequired;

    public LocalXAResource() {
    }

    public LocalXAResource(LocalXAConnection managedConnection) {
        this.managedConnection = managedConnection;
    }

    public void recoverable(Xid xid) throws XAException {
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        String gxid = ByteUtils.byteArrayToString(globalTransactionId);
        String bxid = null;
        bxid = branchQualifier == null || branchQualifier.length == 0 ? gxid : ByteUtils.byteArrayToString(branchQualifier);
        String identifier = this.getIdentifier(globalTransactionId, branchQualifier);
        Connection connection = this.managedConnection.getPhysicalConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select xid, gxid, bxid from bytejta where xid = ? gxid = ? and bxid = ? ");
            stmt = connection.prepareStatement(sql.toString());
            stmt.setString(1, identifier);
            stmt.setString(2, gxid);
            stmt.setString(3, bxid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new XAException(-4);
            }
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
        }
        catch (Exception ex) {
            try {
                logger.warn("Error occurred while recovering local-xa-resource.", (Throwable)ex);
                throw new XAException(-3);
            }
            catch (Throwable throwable) {
                this.closeQuietly(rs);
                this.closeQuietly(stmt);
                throw throwable;
            }
        }
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException();
        }
        if (flags == 0x8000000 && this.suspendXid != null) {
            if (this.suspendXid.equals(xid)) {
                this.suspendXid = null;
                this.currentXid = xid;
                this.originalAutoCommit = this.suspendAutoCommit;
                this.suspendAutoCommit = true;
                return;
            }
            throw new XAException();
        }
        if (flags == 0x200000) {
            if (this.currentXid == null) {
                throw new XAException();
            }
        } else {
            if (flags != 0) {
                throw new XAException();
            }
            if (this.currentXid != null) {
                throw new XAException();
            }
            Connection connection = this.managedConnection.getPhysicalConnection();
            try {
                this.originalAutoCommit = connection.getAutoCommit();
            }
            catch (Exception ignored) {
                this.originalAutoCommit = true;
            }
            try {
                connection.setAutoCommit(false);
            }
            catch (Exception ex) {
                XAException xae = new XAException();
                xae.initCause(ex);
                throw xae;
            }
            this.currentXid = xid;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void end(Xid xid, int flags) throws XAException {
        if (xid == null) {
            throw new XAException();
        }
        if (this.currentXid == null) {
            throw new XAException();
        }
        if (!this.currentXid.equals(xid)) {
            throw new XAException();
        }
        if (flags == 0x2000000) {
            this.suspendXid = xid;
            this.suspendAutoCommit = this.originalAutoCommit;
            this.currentXid = null;
            this.originalAutoCommit = true;
            return;
        }
        if (flags == 0x4000000) {
            if (!this.loggingRequired) return;
            byte[] globalTransactionId = xid.getGlobalTransactionId();
            byte[] branchQualifier = xid.getBranchQualifier();
            String gxid = ByteUtils.byteArrayToString(globalTransactionId);
            String bxid = null;
            bxid = branchQualifier == null || branchQualifier.length == 0 ? gxid : ByteUtils.byteArrayToString(branchQualifier);
            String identifier = this.getIdentifier(globalTransactionId, branchQualifier);
            Connection connection = this.managedConnection.getPhysicalConnection();
            PreparedStatement stmt = null;
            try {
                stmt = connection.prepareStatement("insert into bytejta(xid, gxid, bxid, ctime) values(?, ?, ?, ?)");
                stmt.setString(1, identifier);
                stmt.setString(2, gxid);
                stmt.setString(3, bxid);
                stmt.setLong(4, System.currentTimeMillis());
                int value = stmt.executeUpdate();
                if (value != 0) return;
                throw new IllegalStateException("The operation failed and the data was not written to the database!");
            }
            catch (SQLException ex) {
                boolean tableExists = false;
                try {
                    tableExists = this.isTableExists(connection);
                }
                catch (Exception sqlEx) {
                    logger.error("Error occurred while ending local-xa-resource: {}", (Object)ex.getMessage());
                    throw new XAException(-7);
                }
                if (tableExists) {
                    logger.error("Error occurred while ending local-xa-resource: {}", (Object)ex.getMessage());
                    throw new XAException(-3);
                }
                logger.debug("Error occurred while ending local-xa-resource: {}", (Object)ex.getMessage());
                return;
            }
            catch (RuntimeException rex) {
                logger.error("Error occurred while ending local-xa-resource: {}", (Object)rex.getMessage());
                throw new XAException(-3);
            }
            finally {
                this.closeQuietly(stmt);
            }
        }
        if (flags != 0x20000000) throw new XAException();
        logger.debug("Error occurred while ending local-xa-resource.");
    }

    public synchronized int prepare(Xid xid) {
        Connection connection = this.managedConnection.getPhysicalConnection();
        try {
            if (connection.isReadOnly()) {
                connection.setAutoCommit(this.originalAutoCommit);
                return 3;
            }
        }
        catch (Exception ex) {
            logger.debug("Error occurred while preparing local-xa-resource: {}", (Object)ex.getMessage());
        }
        return 0;
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            if (xid == null) {
                throw new XAException();
            }
            if (this.currentXid == null) {
                throw new XAException();
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException();
            }
            this.managedConnection.commitLocalTransaction();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Exception ex) {
            XAException xae = new XAException();
            xae.initCause(ex);
            throw xae;
        }
        finally {
            this.releasePhysicalConnection();
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        try {
            if (xid == null) {
                throw new XAException();
            }
            if (this.currentXid == null) {
                throw new XAException();
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException();
            }
            this.managedConnection.rollbackLocalTransaction();
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Exception ex) {
            XAException xae = new XAException();
            xae.initCause(ex);
            throw xae;
        }
        finally {
            this.releasePhysicalConnection();
        }
    }

    private void releasePhysicalConnection() {
        Connection connection = this.managedConnection.getPhysicalConnection();
        try {
            connection.setAutoCommit(this.originalAutoCommit);
        }
        catch (Exception ex) {
            logger.warn("Error occurred while configuring attr 'autoCommit' of physical connection.", (Throwable)ex);
        }
        finally {
            this.managedConnection.closeQuietly();
            this.forgetQuietly(this.currentXid);
        }
    }

    public boolean isSameRM(XAResource xares) {
        return this == xares;
    }

    public void forgetQuietly(Xid xid) {
        try {
            this.forget(xid);
        }
        catch (Exception ex) {
            logger.warn("Error occurred while forgeting local-xa-resource.", (Object)xid);
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        if (xid == null || this.currentXid == null) {
            logger.warn("Error occurred while forgeting local-xa-resource: invalid xid.");
        } else {
            this.currentXid = null;
            this.originalAutoCommit = true;
            this.managedConnection = null;
        }
    }

    public Xid[] recover(int flags) throws XAException {
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTableExists(Connection conn) throws SQLException {
        String catalog = null;
        try {
            catalog = conn.getCatalog();
        }
        catch (Throwable throwable) {
            logger.debug("Error occurred while getting catalog of java.sql.Connection!");
        }
        String schema = null;
        try {
            schema = conn.getSchema();
        }
        catch (Throwable throwable) {
            logger.debug("Error occurred while getting schema of java.sql.Connection!");
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            rs = metadata.getTables(catalog, schema, "bytejta", null);
            boolean bl = rs.next();
            this.closeQuietly(rs);
            return bl;
        }
        catch (Throwable throwable) {
            this.closeQuietly(rs);
            throw throwable;
        }
    }

    protected void closeQuietly(ResultSet closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug("Error occurred while closing resource {}.", (Object)closeable);
            }
        }
    }

    protected void closeQuietly(Statement closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug("Error occurred while closing resource {}.", (Object)closeable);
            }
        }
    }

    protected void closeQuietly(Connection closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug("Error occurred while closing resource {}.", (Object)closeable);
            }
        }
    }

    protected String getIdentifier(byte[] globalTransactionId, byte[] branchQualifier) {
        byte[] resultByteArray = new byte[16];
        byte[] globalByteArray = globalTransactionId;
        byte[] branchByteArray = branchQualifier == null || branchQualifier.length == 0 ? globalTransactionId : branchQualifier;
        byte[] millisByteArray = new byte[8];
        System.arraycopy(branchByteArray, 6, millisByteArray, 0, 8);
        long millis = ByteUtils.byteArrayToLong(millisByteArray);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int intTimeValue = hour << 12 | minute << 6 | second;
        short shortTimeValue = (short)intTimeValue;
        byte[] timeByteArray = ByteUtils.shortToByteArray(shortTimeValue);
        int globalStartIndex = 16;
        int branchStartIndex = 16;
        System.arraycopy(branchByteArray, 0, resultByteArray, 0, 6);
        System.arraycopy(timeByteArray, 0, resultByteArray, 6, 2);
        System.arraycopy(globalByteArray, globalStartIndex, resultByteArray, 8, 4);
        System.arraycopy(branchByteArray, branchStartIndex, resultByteArray, 12, 4);
        return ByteUtils.byteArrayToString(resultByteArray);
    }

    public boolean isLoggingRequired() {
        return this.loggingRequired;
    }

    public void setLoggingRequired(boolean loggingRequired) {
        this.loggingRequired = loggingRequired;
    }

    public int getTransactionTimeout() {
        return 0;
    }

    public boolean setTransactionTimeout(int transactionTimeout) {
        return false;
    }

    public LocalXAConnection getManagedConnection() {
        return this.managedConnection;
    }
}

