/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.bytesoft.bytejta.supports.jdbc.LocalXAConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalConnection
implements Connection {
    static final Logger logger = LoggerFactory.getLogger(LogicalConnection.class);
    private boolean connectionClosed;
    private final LocalXAConnection managedConnection;
    private final Connection delegateConnection;

    public LogicalConnection(LocalXAConnection managedConnection, Connection connection) {
        this.managedConnection = managedConnection;
        this.delegateConnection = connection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.isWrapperFor(iface);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new SQLException("Illegal operation!");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.validateConnectionStatus();
        throw new SQLException("Illegal operation!");
    }

    @Override
    public void rollback() throws SQLException {
        this.validateConnectionStatus();
        throw new SQLException("Illegal operation!");
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.connectionClosed) {
            logger.debug("Current connection has already been closed.");
        } else {
            this.connectionClosed = true;
            this.managedConnection.closeLogicalConnection();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connectionClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegateConnection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.validateConnectionStatus();
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(null, (Throwable)ex);
        }
        this.delegateConnection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.validateConnectionStatus();
        }
        catch (SQLException ex) {
            throw new SQLClientInfoException(null, (Throwable)ex);
        }
        this.delegateConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.validateConnectionStatus();
        this.delegateConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.validateConnectionStatus();
        return this.delegateConnection.getNetworkTimeout();
    }

    private void validateConnectionStatus() throws SQLException {
        if (this.connectionClosed) {
            throw new SQLException("Connection is closed");
        }
    }
}

