/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource;

import javax.resource.spi.ManagedConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonResourceDescriptor
implements XAResourceDescriptor {
    static Logger logger = LoggerFactory.getLogger(CommonResourceDescriptor.class);
    private XAResource delegate;
    private String identifier;
    private transient Xid recoverXid;
    private transient Object managed;

    public boolean isTransactionCommitted(Xid xid) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public String toString() {
        return String.format("common-resource[id= %s]", this.identifier);
    }

    public void setTransactionTimeoutQuietly(int timeout) {
        try {
            this.delegate.setTransactionTimeout(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
        this.delegate.commit(arg0, arg1);
    }

    public void end(Xid arg0, int arg1) throws XAException {
        this.delegate.end(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid arg0) throws XAException {
        try {
            this.delegate.forget(arg0);
            Object var3_2 = null;
            this.closeIfNecessary();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closeIfNecessary();
            throw throwable;
        }
    }

    private void closeIfNecessary() {
        if (this.recoverXid != null && this.managed != null) {
            if (XAConnection.class.isInstance(this.managed)) {
                this.closeQuietly((XAConnection)this.managed);
            } else if (javax.jms.XAConnection.class.isInstance(this.managed)) {
                this.closeQuietly((javax.jms.XAConnection)this.managed);
            } else if (ManagedConnection.class.isInstance(this.managed)) {
                this.closeQuietly((ManagedConnection)this.managed);
            }
        }
    }

    private void closeQuietly(javax.jms.XAConnection closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
        }
    }

    private void closeQuietly(XAConnection closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
        }
    }

    private void closeQuietly(ManagedConnection closeable) {
        if (closeable != null) {
            try {
                closeable.cleanup();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
            try {
                closeable.destroy();
            }
            catch (Exception ex) {
                logger.debug(ex.getMessage());
            }
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.delegate.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource arg0) throws XAException {
        return this.delegate.isSameRM(arg0);
    }

    public int prepare(Xid arg0) throws XAException {
        return this.delegate.prepare(arg0);
    }

    public Xid[] recover(int arg0) throws XAException {
        Xid[] xidArray = this.delegate.recover(arg0);
        return xidArray;
    }

    public void rollback(Xid arg0) throws XAException {
        this.delegate.rollback(arg0);
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return this.delegate.setTransactionTimeout(arg0);
    }

    public void start(Xid arg0, int arg1) throws XAException {
        this.delegate.start(arg0, arg1);
    }

    public XAResource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(XAResource delegate) {
        this.delegate = delegate;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Xid getRecoverXid() {
        return this.recoverXid;
    }

    public void setRecoverXid(Xid recoverXid) {
        this.recoverXid = recoverXid;
    }

    public Object getManaged() {
        return this.managed;
    }

    public void setManaged(Object managed) {
        this.managed = managed;
    }
}

