/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.supports.resource;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.jdbc.LocalXAResource;
import org.bytesoft.bytejta.supports.jdbc.RecoveredResource;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;

public class LocalXAResourceDescriptor
implements XAResourceDescriptor {
    private String identifier;
    private XAResource delegate;

    public boolean isTransactionCommitted(Xid xid) throws IllegalStateException {
        try {
            if (RecoveredResource.class.isInstance(this.delegate)) {
                ((RecoveredResource)this.delegate).recoverable(xid);
            } else {
                ((LocalXAResource)this.delegate).recoverable(xid);
            }
            return true;
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case -4: {
                    return false;
                }
            }
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return String.format("local-xa-resource[%s]", this.identifier);
    }

    public void setTransactionTimeoutQuietly(int timeout) {
        try {
            this.delegate.setTransactionTimeout(timeout);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.commit(arg0, arg1);
    }

    public void end(Xid arg0, int arg1) throws XAException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.end(arg0, arg1);
    }

    public void forget(Xid arg0) throws XAException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.forget(arg0);
    }

    public int getTransactionTimeout() throws XAException {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (this.delegate == null) {
            return false;
        }
        if (LocalXAResourceDescriptor.class.isInstance(xares)) {
            LocalXAResourceDescriptor that = (LocalXAResourceDescriptor)xares;
            return StringUtils.equals((CharSequence)this.identifier, (CharSequence)that.identifier);
        }
        return this.delegate.isSameRM(xares);
    }

    public int prepare(Xid arg0) throws XAException {
        if (this.delegate == null) {
            return 3;
        }
        return this.delegate.prepare(arg0);
    }

    public Xid[] recover(int arg0) throws XAException {
        if (this.delegate == null) {
            return new Xid[0];
        }
        return this.delegate.recover(arg0);
    }

    public void rollback(Xid arg0) throws XAException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.rollback(arg0);
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.setTransactionTimeout(arg0);
    }

    public void start(Xid arg0, int arg1) throws XAException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.start(arg0, arg1);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public XAResource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(XAResource delegate) {
        this.delegate = delegate;
    }
}

