/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.work;

import javax.inject.Inject;
import javax.resource.spi.work.Work;
import org.bytesoft.transaction.TransactionBeanFactory;
import org.bytesoft.transaction.TransactionRecovery;
import org.bytesoft.transaction.aware.TransactionBeanFactoryAware;
import org.bytesoft.transaction.supports.TransactionTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionWork
implements Work,
TransactionBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionWork.class);
    @Inject
    private TransactionBeanFactory beanFactory;
    static final long SECOND_MILLIS = 1000L;
    private long stopTimeMillis = -1L;
    private long delayOfStoping = 15000L;
    private long recoveryInterval = 60000L;

    public void run() {
        TransactionTimer transactionTimer = this.beanFactory.getTransactionTimer();
        TransactionRecovery transactionRecovery = this.beanFactory.getTransactionRecovery();
        try {
            transactionRecovery.startRecovery();
            transactionRecovery.timingRecover();
        }
        catch (RuntimeException rex) {
            logger.error("TransactionRecovery init failed!", (Throwable)rex);
        }
        long nextExecutionTime = 0L;
        long nextRecoveryTime = System.currentTimeMillis() + this.recoveryInterval;
        while (this.currentActive()) {
            long current = System.currentTimeMillis();
            if (current >= nextExecutionTime) {
                nextExecutionTime = current + 1000L;
                try {
                    transactionTimer.timingExecution();
                }
                catch (RuntimeException rex) {
                    logger.error(rex.getMessage(), (Throwable)rex);
                }
            }
            if (current >= nextRecoveryTime) {
                nextRecoveryTime = current + this.recoveryInterval;
                try {
                    transactionRecovery.timingRecover();
                }
                catch (RuntimeException rex) {
                    logger.error(rex.getMessage(), (Throwable)rex);
                }
            }
            this.waitForMillis(100L);
        }
    }

    private void waitForMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        this.stopTimeMillis = System.currentTimeMillis() + this.delayOfStoping;
    }

    protected boolean currentActive() {
        return this.stopTimeMillis <= 0L || System.currentTimeMillis() < this.stopTimeMillis;
    }

    public long getDelayOfStoping() {
        return this.delayOfStoping;
    }

    public void setDelayOfStoping(long delayOfStoping) {
        this.delayOfStoping = delayOfStoping;
    }

    public void setBeanFactory(TransactionBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

