/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytejta.xa;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XidFactoryImpl
implements XidFactory {
    static final Logger logger = LoggerFactory.getLogger(XidFactoryImpl.class);
    static final int SIZE_OF_MAC = 6;
    static final Random random = new Random();
    static final byte[] hardwareAddress = new byte[6];
    static final AtomicInteger atomic = new AtomicInteger();

    private static byte[] getHardwareAddress() {
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
        }
        byte[] byteArray = null;
        while (byteArray == null && enumeration != null && enumeration.hasMoreElements()) {
            NetworkInterface element = enumeration.nextElement();
            try {
                byte[] hardwareAddr;
                if (!element.isUp() || element.isPointToPoint() || element.isVirtual() || element.isLoopback() || (hardwareAddr = element.getHardwareAddress()) == null || hardwareAddr.length != 6) continue;
                byteArray = new byte[6];
                System.arraycopy(hardwareAddr, 0, byteArray, 0, 6);
            }
            catch (Exception rex) {
                logger.debug(rex.getMessage(), (Throwable)rex);
            }
        }
        return byteArray != null ? byteArray : new byte[6];
    }

    public TransactionXid createGlobalXid() {
        byte[] global = new byte[20];
        long millis = System.currentTimeMillis();
        byte[] millisByteArray = ByteUtils.longToByteArray(millis);
        short value = (short)(atomic.incrementAndGet() % Short.MAX_VALUE);
        byte[] valueByteArray = ByteUtils.shortToByteArray(value);
        byte[] randomByteArray = new byte[4];
        random.nextBytes(randomByteArray);
        System.arraycopy(hardwareAddress, 0, global, 0, 6);
        System.arraycopy(millisByteArray, 0, global, 6, 8);
        System.arraycopy(valueByteArray, 0, global, 14, 2);
        System.arraycopy(randomByteArray, 0, global, 16, randomByteArray.length);
        return new TransactionXid(1207, global);
    }

    public TransactionXid createGlobalXid(byte[] globalTransactionId) {
        if (globalTransactionId == null) {
            throw new IllegalArgumentException("The globalTransactionId cannot be null.");
        }
        if (globalTransactionId.length > 64) {
            throw new IllegalArgumentException("The length of globalTransactionId cannot exceed 64 bytes.");
        }
        byte[] global = new byte[globalTransactionId.length];
        System.arraycopy(globalTransactionId, 0, global, 0, global.length);
        return new TransactionXid(1207, global);
    }

    public TransactionXid createBranchXid(TransactionXid globalXid) {
        if (globalXid == null) {
            throw new IllegalArgumentException("Xid cannot be null.");
        }
        if (globalXid.getGlobalTransactionId() == null) {
            throw new IllegalArgumentException("The globalTransactionId cannot be null.");
        }
        if (globalXid.getGlobalTransactionId().length > 64) {
            throw new IllegalArgumentException("The length of globalTransactionId cannot exceed 64 bytes.");
        }
        byte[] global = new byte[globalXid.getGlobalTransactionId().length];
        System.arraycopy(globalXid.getGlobalTransactionId(), 0, global, 0, global.length);
        byte[] branch = new byte[20];
        long millis = System.currentTimeMillis();
        byte[] millisByteArray = ByteUtils.longToByteArray(millis);
        short value = (short)(atomic.incrementAndGet() % Short.MAX_VALUE);
        byte[] valueByteArray = ByteUtils.shortToByteArray(value);
        byte[] randomByteArray = new byte[4];
        random.nextBytes(randomByteArray);
        System.arraycopy(hardwareAddress, 0, branch, 0, 6);
        System.arraycopy(millisByteArray, 0, branch, 6, 8);
        System.arraycopy(valueByteArray, 0, branch, 14, 2);
        System.arraycopy(randomByteArray, 0, branch, 16, randomByteArray.length);
        return new TransactionXid(1207, global, branch);
    }

    public TransactionXid createBranchXid(TransactionXid globalXid, byte[] branchQualifier) {
        if (globalXid == null) {
            throw new IllegalArgumentException("Xid cannot be null.");
        }
        if (globalXid.getGlobalTransactionId() == null) {
            throw new IllegalArgumentException("The globalTransactionId cannot be null.");
        }
        if (globalXid.getGlobalTransactionId().length > 64) {
            throw new IllegalArgumentException("The length of globalTransactionId cannot exceed 64 bytes.");
        }
        if (branchQualifier == null) {
            throw new IllegalArgumentException("The branchQulifier cannot be null.");
        }
        if (branchQualifier.length > 64) {
            throw new IllegalArgumentException("The length of branchQulifier cannot exceed 64 bytes.");
        }
        byte[] global = new byte[globalXid.getGlobalTransactionId().length];
        System.arraycopy(globalXid.getGlobalTransactionId(), 0, global, 0, global.length);
        return new TransactionXid(1207, global, branchQualifier);
    }

    public byte[] generateUniqueKey() {
        byte[] currentByteArray = ByteUtils.longToByteArray(System.currentTimeMillis());
        byte[] randomByteArray = new byte[4];
        random.nextBytes(randomByteArray);
        byte[] uniqueKey = new byte[16];
        int timeLen = 6;
        System.arraycopy(currentByteArray, currentByteArray.length - timeLen, uniqueKey, 0, timeLen);
        System.arraycopy(randomByteArray, 0, uniqueKey, timeLen, randomByteArray.length);
        System.arraycopy(hardwareAddress, 0, uniqueKey, randomByteArray.length + timeLen, hardwareAddress.length);
        return uniqueKey;
    }

    static {
        byte[] sourceByteArray = XidFactoryImpl.getHardwareAddress();
        System.arraycopy(sourceByteArray, 0, hardwareAddress, 0, 6);
    }
}

