/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.common.utils;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);

    public static boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        if (o2 != null) {
            return o2.equals(o1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObject(Serializable obj) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HessianOutput ho = new HessianOutput((OutputStream)baos);
        try {
            ho.writeObject((Object)obj);
            byArray = baos.toByteArray();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            CommonUtils.closeQuietly(baos);
            throw throwable;
        }
        CommonUtils.closeQuietly(baos);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable deserializeObject(byte[] bytes) throws IOException {
        Serializable serializable;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        HessianInput hi = new HessianInput((InputStream)bais);
        try {
            Object result = hi.readObject();
            serializable = (Serializable)result;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CommonUtils.closeQuietly(bais);
            throw throwable;
        }
        CommonUtils.closeQuietly(bais);
        return serializable;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                logger.debug("Error occurred while closing resource {}.", (Object)closeable);
            }
        }
    }

    public static String getInetAddress() {
        try {
            InetAddress inetAddr = InetAddress.getLocalHost();
            return inetAddr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            logger.error("Error occurred while getting ip address.", (Throwable)ex);
            return "127.0.0.1";
        }
    }
}

