/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.transaction.internal;

import java.util.ArrayList;
import java.util.List;
import org.bytesoft.transaction.supports.TransactionListener;
import org.bytesoft.transaction.supports.TransactionListenerAdapter;
import org.bytesoft.transaction.xa.TransactionXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionListenerList
extends TransactionListenerAdapter {
    static final Logger logger = LoggerFactory.getLogger(TransactionListenerList.class);
    private final List<TransactionListener> listeners = new ArrayList<TransactionListener>();

    public void registerTransactionListener(TransactionListener listener) {
        this.listeners.add(listener);
    }

    public void onPrepareStart(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onPrepareStart(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onPrepareSuccess(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onPrepareSuccess(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onPrepareFailure(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onPrepareFailure(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onCommitStart(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onCommitStart(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onCommitSuccess(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onCommitSuccess(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onCommitFailure(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onCommitFailure(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onCommitHeuristicMixed(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onCommitHeuristicMixed(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onCommitHeuristicRolledback(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onCommitHeuristicRolledback(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onRollbackStart(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onRollbackStart(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onRollbackSuccess(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onRollbackSuccess(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    public void onRollbackFailure(TransactionXid xid) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                TransactionListener listener = this.listeners.get(i);
                listener.onRollbackFailure(xid);
                continue;
            }
            catch (RuntimeException rex) {
                logger.error(rex.getMessage(), (Throwable)rex);
            }
        }
    }
}

