/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.transaction.work;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.bytesoft.transaction.work.SimpleWork;
import org.bytesoft.transaction.work.SimpleWorkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWorkManager
implements WorkManager {
    static final Logger logger = LoggerFactory.getLogger(SimpleWorkManager.class);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public void doWork(Work work) throws WorkException {
        this.doWork(work, 1800000L, null, null);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        SimpleWorkListener wrappedListener = new SimpleWorkListener(workListener);
        wrappedListener.workAccepted(new WorkEvent((Object)this, 1, work, null));
        SimpleWork task = new SimpleWork();
        task.setWork(work);
        task.setWorkListener(wrappedListener);
        Future<?> future = this.executor.submit(task);
        try {
            future.get();
        }
        catch (CancellationException ex) {
            wrappedListener.workCompleted(new WorkEvent((Object)this, 2, work, new WorkException((Throwable)ex)));
        }
        catch (InterruptedException ex) {
            wrappedListener.workCompleted(new WorkEvent((Object)this, 4, work, new WorkException((Throwable)ex)));
        }
        catch (ExecutionException ex) {
            wrappedListener.workCompleted(new WorkEvent((Object)this, 4, work, new WorkException((Throwable)ex)));
        }
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, 1800000L, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        SimpleWorkListener wrappedListener = new SimpleWorkListener(workListener);
        wrappedListener.workAccepted(new WorkEvent((Object)this, 1, work, null));
        SimpleWork task = new SimpleWork();
        task.setSource(this);
        task.setWork(work);
        task.setWorkListener(wrappedListener);
        this.executor.submit(task);
        return wrappedListener.waitForStart();
    }

    public void scheduleWork(Work work) throws WorkException {
        throw new WorkException("not supported yet!");
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        throw new WorkException("not supported yet!");
    }
}

