/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsBuilder;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsTenantBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.StatisticsResultDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionQueryDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionStatisticsResultDto;
import org.camunda.bpm.engine.rest.dto.repository.ProcessDefinitionSuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.repository.ProcessDefinitionResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;

public class ProcessDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements ProcessDefinitionRestService {
    public ProcessDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public ProcessDefinitionResource getProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.getProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (processDefinition == null) {
            String errorMessage = String.format("No matching process definition with key: %s and no tenant-id", processDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getProcessDefinitionById(processDefinition.getId());
    }

    @Override
    public ProcessDefinitionResource getProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.getProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (processDefinition == null) {
            String errorMessage = String.format("No matching process definition with key: %s and tenant-id: %s", processDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getProcessDefinitionById(processDefinition.getId());
    }

    @Override
    public ProcessDefinitionResource getProcessDefinitionById(String processDefinitionId) {
        return new ProcessDefinitionResourceImpl(this.getProcessEngine(), processDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<ProcessDefinitionDto> getProcessDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        ProcessDefinitionQueryDto queryDto = new ProcessDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<ProcessDefinitionDto> definitions = new ArrayList<ProcessDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)queryDto.toQuery(engine);
        List<ProcessDefinition> matchingDefinitions = null;
        matchingDefinitions = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        for (ProcessDefinition definition : matchingDefinitions) {
            ProcessDefinitionDto def = ProcessDefinitionDto.fromProcessDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    private List<ProcessDefinition> executePaginatedQuery(ProcessDefinitionQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getProcessDefinitionsCount(UriInfo uriInfo) {
        ProcessDefinitionQueryDto queryDto = new ProcessDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public List<StatisticsResultDto> getStatistics(Boolean includeFailedJobs, Boolean includeRootIncidents, Boolean includeIncidents, String includeIncidentsForType) {
        if (includeIncidents != null && includeIncidentsForType != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only one of the query parameter includeIncidents or includeIncidentsForType can be set.");
        }
        if (includeIncidents != null && includeRootIncidents != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only one of the query parameter includeIncidents or includeRootIncidents can be set.");
        }
        if (includeRootIncidents != null && includeIncidentsForType != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only one of the query parameter includeRootIncidents or includeIncidentsForType can be set.");
        }
        ManagementService mgmtService = this.getProcessEngine().getManagementService();
        ProcessDefinitionStatisticsQuery query = mgmtService.createProcessDefinitionStatisticsQuery();
        if (includeFailedJobs != null && includeFailedJobs.booleanValue()) {
            query.includeFailedJobs();
        }
        if (includeIncidents != null && includeIncidents.booleanValue()) {
            query.includeIncidents();
        } else if (includeIncidentsForType != null) {
            query.includeIncidentsForType(includeIncidentsForType);
        } else if (includeRootIncidents != null && includeRootIncidents.booleanValue()) {
            query.includeRootIncidents();
        }
        List queryResults = query.unlimitedList();
        ArrayList<StatisticsResultDto> results = new ArrayList<StatisticsResultDto>();
        for (ProcessDefinitionStatistics queryResult : queryResults) {
            ProcessDefinitionStatisticsResultDto dto = ProcessDefinitionStatisticsResultDto.fromProcessDefinitionStatistics(queryResult);
            results.add(dto);
        }
        return results;
    }

    @Override
    public void updateSuspensionState(ProcessDefinitionSuspensionStateDto dto) {
        if (dto.getProcessDefinitionId() != null) {
            String message = "Only processDefinitionKey can be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        try {
            dto.updateSuspensionState(this.getProcessEngine());
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Could not update the suspension state of Process Definitions due to: %s", e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, message);
        }
    }

    @Override
    public void deleteProcessDefinitionsByKey(String processDefinitionKey, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeleteProcessDefinitionsTenantBuilder builder = repositoryService.deleteProcessDefinitions().byKey(processDefinitionKey);
        this.deleteProcessDefinitions((DeleteProcessDefinitionsBuilder)builder, cascade, skipCustomListeners, skipIoMappings);
    }

    @Override
    public void deleteProcessDefinitionsByKeyAndTenantId(String processDefinitionKey, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings, String tenantId) {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        DeleteProcessDefinitionsBuilder builder = repositoryService.deleteProcessDefinitions().byKey(processDefinitionKey).withTenantId(tenantId);
        this.deleteProcessDefinitions(builder, cascade, skipCustomListeners, skipIoMappings);
    }

    protected void deleteProcessDefinitions(DeleteProcessDefinitionsBuilder builder, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        if (skipCustomListeners) {
            builder = builder.skipCustomListeners();
        }
        if (cascade) {
            builder = builder.cascade();
        }
        if (skipIoMappings) {
            builder = builder.skipIoMappings();
        }
        try {
            builder.delete();
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }
}

