/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.rest.dto.AnnotationDto;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.UserOperationLogEntryDto;
import org.camunda.bpm.engine.rest.dto.history.UserOperationLogQueryDto;
import org.camunda.bpm.engine.rest.history.UserOperationLogRestService;

public class UserOperationLogRestServiceImpl
implements UserOperationLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public UserOperationLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public CountResultDto queryUserOperationCount(UriInfo uriInfo) {
        UserOperationLogQueryDto queryDto = new UserOperationLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        UserOperationLogQuery query = (UserOperationLogQuery)queryDto.toQuery(this.processEngine);
        return new CountResultDto(query.count());
    }

    @Override
    public List<UserOperationLogEntryDto> queryUserOperationEntries(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        UserOperationLogQueryDto queryDto = new UserOperationLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        UserOperationLogQuery query = (UserOperationLogQuery)queryDto.toQuery(this.processEngine);
        if (firstResult == null && maxResults == null) {
            return UserOperationLogEntryDto.map(query.list());
        }
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return UserOperationLogEntryDto.map(query.listPage(firstResult.intValue(), maxResults.intValue()));
    }

    @Override
    public Response setAnnotation(String operationId, AnnotationDto annotationDto) {
        String annotation = annotationDto.getAnnotation();
        this.processEngine.getHistoryService().setAnnotationForOperationLogById(operationId, annotation);
        return Response.noContent().build();
    }

    @Override
    public Response clearAnnotation(String operationId) {
        this.processEngine.getHistoryService().clearAnnotationForOperationLogById(operationId);
        return Response.noContent().build();
    }
}

