/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.io.File;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.modello.maven.AbstractModelloGeneratorMojo;

public abstract class AbstractModelloSourceGeneratorMojo
extends AbstractModelloGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/modello", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter
    private String javaSource;
    @Parameter(defaultValue="true")
    private boolean domAsXpp3;

    @Override
    protected boolean producesCompilableResult() {
        return true;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    protected void customizeParameters(Properties parameters) {
        super.customizeParameters(parameters);
        if (this.encoding != null) {
            parameters.setProperty("modello.output.encoding", this.encoding);
        }
        if (this.javaSource == null) {
            this.javaSource = this.discoverJavaSource();
        }
        if (this.javaSource.startsWith("1.")) {
            this.javaSource = this.javaSource.substring("1.".length());
        }
        this.getLog().debug((CharSequence)("javaSource=" + this.javaSource));
        parameters.setProperty("modello.output.java.source", this.javaSource);
        parameters.setProperty("modello.dom.xpp3", Boolean.toString(this.domAsXpp3));
    }

    private String discoverJavaSource() {
        Properties projectProperties = this.getProject().getProperties();
        Supplier<String> release = () -> projectProperties.getProperty("maven.compiler.release");
        Supplier<String> source = () -> projectProperties.getProperty("maven.compiler.source");
        Supplier<String> target = () -> projectProperties.getProperty("maven.compiler.target");
        Optional<String> jSource = Stream.of(release, source, target).map(Supplier::get).filter(s -> s != null && !s.isEmpty()).findFirst();
        if (jSource.isPresent()) {
            return jSource.get();
        }
        this.getLog().warn((CharSequence)"javaSource was not discovered - use default value 8");
        return "8";
    }
}

