/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.categorical;

import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnNumber"})
public class StringToCategoricalTransform
extends BaseColumnTransform {
    private final List<String> stateNames;

    public StringToCategoricalTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="stateNames") List<String> stateNames) {
        super(columnName);
        if (stateNames == null || stateNames.isEmpty()) {
            throw new IllegalArgumentException("State names must not be null or empty");
        }
        this.stateNames = stateNames;
    }

    public StringToCategoricalTransform(String columnName, String ... stateNames) {
        this(columnName, Arrays.asList(stateNames));
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnType) {
        return new CategoricalMetaData(newColumnName, this.stateNames);
    }

    @Override
    public Writable map(Writable columnWritable) {
        return columnWritable;
    }

    @Override
    public String toString() {
        return "StringToCategoricalTransform(stateNames=" + this.stateNames + ")";
    }

    @Override
    public Object map(Object input) {
        return input;
    }

    @Override
    public Object mapSequence(Object sequence) {
        return sequence;
    }

    public List<String> getStateNames() {
        return this.stateNames;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringToCategoricalTransform)) {
            return false;
        }
        StringToCategoricalTransform other = (StringToCategoricalTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$stateNames = this.getStateNames();
        List<String> other$stateNames = other.getStateNames();
        return !(this$stateNames == null ? other$stateNames != null : !((Object)this$stateNames).equals(other$stateNames));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringToCategoricalTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $stateNames = this.getStateNames();
        result = result * 59 + ($stateNames == null ? 43 : ((Object)$stateNames).hashCode());
        return result;
    }
}

