/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ColorConversionTransform
extends BaseImageTransform {
    private int conversionCode;

    public ColorConversionTransform() {
        this(new Random(1234L), 50);
    }

    public ColorConversionTransform(int conversionCode) {
        this(null, conversionCode);
    }

    public ColorConversionTransform(Random random, int conversionCode) {
        super(random);
        this.conversionCode = conversionCode;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat result = new opencv_core.Mat();
        try {
            opencv_imgproc.cvtColor((opencv_core.Mat)mat, (opencv_core.Mat)result, (int)this.conversionCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        return coordinates;
    }

    public int getConversionCode() {
        return this.conversionCode;
    }

    public void setConversionCode(int conversionCode) {
        this.conversionCode = conversionCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColorConversionTransform)) {
            return false;
        }
        ColorConversionTransform other = (ColorConversionTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getConversionCode() == other.getConversionCode();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ColorConversionTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConversionCode();
        return result;
    }

    @Override
    public String toString() {
        return "ColorConversionTransform(conversionCode=" + this.getConversionCode() + ")";
    }
}

