/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.hadoop.records.writer.mapfile;

import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.PartitionMetaData;
import org.datavec.api.split.partition.Partitioner;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.datavec.hadoop.records.reader.mapfile.record.RecordWritable;
import org.datavec.hadoop.records.writer.mapfile.AbstractMapFileWriter;

public class MapFileRecordWriter
extends AbstractMapFileWriter<List<Writable>>
implements RecordWriter {
    public MapFileRecordWriter(File outputDir) {
        super(outputDir);
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize) {
        this(outputDir, mapFileSplitSize, null);
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, WritableType convertTextTo) {
        this(outputDir, -1, convertTextTo);
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo) {
        super(outputDir, mapFileSplitSize, convertTextTo);
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        super(outputDir, mapFileSplitSize, convertTextTo, 1, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, int indexInterval, org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        super(outputDir, mapFileSplitSize, convertTextTo, indexInterval, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
    }

    public MapFileRecordWriter(@NonNull File outputDir, int mapFileSplitSize, WritableType convertTextTo, int indexInterval, String filenamePattern, org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        super(outputDir, mapFileSplitSize, convertTextTo, indexInterval, filenamePattern, hadoopConfiguration);
        if (outputDir == null) {
            throw new NullPointerException("outputDir is marked @NonNull but is null");
        }
    }

    @Override
    protected Class<? extends org.apache.hadoop.io.Writable> getValueClass() {
        return RecordWritable.class;
    }

    @Override
    protected org.apache.hadoop.io.Writable getHadoopWritable(List<Writable> input) {
        if (this.convertTextTo != null) {
            input = this.convertTextWritables(input);
        }
        return new RecordWritable(input);
    }

    public boolean supportsBatch() {
        return false;
    }

    public void initialize(InputSplit inputSplit, Partitioner partitioner) throws Exception {
    }

    public void initialize(Configuration configuration, InputSplit split, Partitioner partitioner) throws Exception {
    }

    public PartitionMetaData writeBatch(List<List<Writable>> batch) throws IOException {
        return null;
    }
}

