/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.misc.RepeatVector;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.config.KerasLayerConfiguration;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasRepeatVector
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasRepeatVector.class);

    public KerasRepeatVector(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasRepeatVector(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.layer = new RepeatVector.Builder().repetitionFactor(KerasRepeatVector.getRepeatMultiplier(layerConfig, this.conf)).name(this.layerName).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras RepeatVector layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getRepeatVectorLayer().getOutputType(-1, inputType[0]);
    }

    public RepeatVector getRepeatVectorLayer() {
        return (RepeatVector)this.layer;
    }

    static int getRepeatMultiplier(Map<String, Object> layerConfig, KerasLayerConfiguration conf) throws InvalidKerasConfigurationException {
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, conf);
        return (Integer)innerConfig.get(conf.getLAYER_FIELD_REPEAT_MULTIPLIER());
    }
}

