/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.advanced.activations;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationLReLU;

public class KerasLeakyReLU
extends KerasLayer {
    public KerasLeakyReLU(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasLeakyReLU(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        double alpha = 0.01;
        String layerFieldLeakyReluAlpha = "alpha";
        if (innerConfig.containsKey(layerFieldLeakyReluAlpha)) {
            alpha = (Double)innerConfig.get(layerFieldLeakyReluAlpha);
        }
        ActivationLReLU leakyReLU = new ActivationLReLU(alpha);
        this.layer = ((ActivationLayer.Builder)new ActivationLayer.Builder().name(this.layerName)).activation((IActivation)leakyReLU).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Activation layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getActivationLayer().getOutputType(-1, inputType[0]);
    }

    public ActivationLayer getActivationLayer() {
        return (ActivationLayer)this.layer;
    }
}

