/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.util.MaskZeroLayer;
import org.deeplearning4j.nn.layers.util.IdentityLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasMasking
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasMasking.class);
    private double maskingValue;

    public KerasMasking(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasMasking(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        this.maskingValue = KerasLayerUtils.getMaskingValueFromConfig(layerConfig, this.conf);
        this.layer = ((MaskZeroLayer.Builder)new MaskZeroLayer.Builder().setMaskValue(this.maskingValue).setUnderlying((Layer)new IdentityLayer(this.layerName)).name(this.layerName)).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Masking layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getMaskingLayer().getOutputType(-1, inputType[0]);
    }

    public MaskZeroLayer getMaskingLayer() {
        return (MaskZeroLayer)this.layer;
    }

    public double getMaskingValue() {
        return this.maskingValue;
    }

    public void setMaskingValue(double maskingValue) {
        this.maskingValue = maskingValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KerasMasking)) {
            return false;
        }
        KerasMasking other = (KerasMasking)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getMaskingValue(), other.getMaskingValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof KerasMasking;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maskingValue = Double.doubleToLongBits(this.getMaskingValue());
        result = result * 59 + (int)($maskingValue >>> 32 ^ $maskingValue);
        return result;
    }

    public String toString() {
        return "KerasMasking(maskingValue=" + this.getMaskingValue() + ")";
    }
}

