/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.in.xhtml;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBElement;
import org.docx4j.TraversalUtil;
import org.docx4j.finders.RangeFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTSdtContentCell;
import org.docx4j.wml.CTSdtContentRow;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class BookmarkHelper {
    public static Logger log = LoggerFactory.getLogger(BookmarkHelper.class);
    private WordprocessingMLPackage wordMLPackage;
    private AtomicInteger bookmarkId = null;

    private BookmarkHelper() {
    }

    BookmarkHelper(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    protected void setBookmarkId(AtomicInteger bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    protected AtomicInteger getBookmarkId() {
        if (this.bookmarkId == null) {
            this.bookmarkId = new AtomicInteger(this.initBookmarkIdStart());
        }
        return this.bookmarkId;
    }

    private int initBookmarkIdStart() {
        int highestId = 0;
        RangeFinder rt = new RangeFinder();
        new TraversalUtil((Object)this.wordMLPackage.getMainDocumentPart().getContent(), (TraversalUtil.Callback)rt);
        for (CTBookmark bm : rt.getStarts()) {
            BigInteger id = bm.getId();
            if (id == null || id.intValue() <= highestId) continue;
            highestId = id.intValue();
        }
        return highestId;
    }

    protected CTMarkupRange anchorToBookmark(Element e, String bookmarkNamePrefix, P currentP, ContentAccessor contentContext) {
        if (e == null) {
            return null;
        }
        String name = null;
        name = e.getNodeName().equals("a") ? e.getAttribute("name") : e.getAttribute("id");
        if (name == null || name.trim().equals("")) {
            return null;
        }
        log.debug("[NAMED ANCHOR] " + name);
        CTBookmark bookmark = Context.getWmlObjectFactory().createCTBookmark();
        JAXBElement bookmarkWrapped = null;
        if (currentP != null) {
            bookmarkWrapped = Context.getWmlObjectFactory().createPBookmarkStart(bookmark);
            currentP.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof Body) {
            bookmarkWrapped = Context.getWmlObjectFactory().createBodyBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof SdtContentBlock) {
            bookmarkWrapped = Context.getWmlObjectFactory().createSdtContentBlockBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof CTSdtContentRow) {
            bookmarkWrapped = Context.getWmlObjectFactory().createCTSdtContentRowBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof CTSdtContentCell) {
            bookmarkWrapped = Context.getWmlObjectFactory().createCTSdtContentCellBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof Tbl) {
            bookmarkWrapped = Context.getWmlObjectFactory().createTblBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof Tr) {
            bookmarkWrapped = Context.getWmlObjectFactory().createTrBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else if (contentContext instanceof Tc) {
            bookmarkWrapped = Context.getWmlObjectFactory().createTcBookmarkStart(bookmark);
            contentContext.getContent().add(bookmarkWrapped);
        } else {
            log.error("COuldn't attach bookmark " + name + " to " + contentContext.getClass().getName());
        }
        bookmark.setName(this.idToBookmarkName(bookmarkNamePrefix, name));
        bookmark.setId(BigInteger.valueOf(this.getBookmarkId().get()));
        return this.generateBookmarkEnd();
    }

    private CTMarkupRange generateBookmarkEnd() {
        CTMarkupRange markuprange = Context.getWmlObjectFactory().createCTMarkupRange();
        markuprange.setId(BigInteger.valueOf(this.getBookmarkId().getAndIncrement()));
        return markuprange;
    }

    protected void attachBookmarkEnd(CTMarkupRange markuprange, P currentP, ContentAccessor contentContext) {
        if (currentP != null) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createPBookmarkEnd(markuprange);
            currentP.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof Body) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createBodyBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof SdtContentBlock) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createSdtContentBlockBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof CTSdtContentRow) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createCTSdtContentRowBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof CTSdtContentCell) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createCTSdtContentCellBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof Tbl) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createTblBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof Tr) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createTrBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else if (contentContext instanceof Tc) {
            JAXBElement markuprangeWrapped = Context.getWmlObjectFactory().createTcBookmarkEnd(markuprange);
            contentContext.getContent().add(markuprangeWrapped);
        } else {
            log.error("COuldn't attach bookmark  to " + contentContext.getClass().getName());
        }
    }

    protected String idToBookmarkName(String bookmarkNamePrefix, String id) {
        return bookmarkNamePrefix + id;
    }

    protected String anchorToBookmarkName(String bookmarkNamePrefix, String href) {
        if (!href.startsWith("#")) {
            log.error(href + " is not a relative link", new Throwable());
            return href;
        }
        return bookmarkNamePrefix + href.substring(1);
    }
}

