/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.model.structure.jaxb.ObjectFactory;
import org.docx4j.model.structure.jaxb.Sections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConversionSectionWrappers {
    protected List<ConversionSectionWrapper> conversionSections = null;
    protected int currentSectionIndex = -1;
    protected ConversionSectionWrapper currentSection = null;

    public ConversionSectionWrappers(List<ConversionSectionWrapper> conversionSections) {
        this.conversionSections = conversionSections;
    }

    public Sections createSections() {
        ObjectFactory factory = new ObjectFactory();
        Sections ret = factory.createSections();
        for (int i = 0; i < this.conversionSections.size(); ++i) {
            ret.getSection().add(this.createSection(factory, this.conversionSections.get(i)));
        }
        return ret;
    }

    private Sections.Section createSection(ObjectFactory factory, ConversionSectionWrapper conversionSectionWrapper) {
        Sections.Section ret = factory.createSectionsSection();
        ret.setName(conversionSectionWrapper.getId());
        for (int i = 0; i < conversionSectionWrapper.getContent().size(); ++i) {
            ret.getAny().add(ConversionSectionWrappers.marshall(conversionSectionWrapper.getContent().get(i)));
        }
        return ret;
    }

    private static Element marshall(Object o) {
        try {
            Document w3cDoc = XmlUtils.marshaltoW3CDomDocument(o);
            return w3cDoc.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ConversionSectionWrapper> getList() {
        return this.conversionSections;
    }

    public void start() {
        this.currentSectionIndex = -1;
    }

    public void next() {
        ++this.currentSectionIndex;
        this.currentSection = null;
        if (this.currentSectionIndex >= 0 && this.currentSectionIndex < this.conversionSections.size()) {
            this.currentSection = this.conversionSections.get(this.currentSectionIndex);
        }
    }

    public ConversionSectionWrapper getCurrentSection() {
        if (this.currentSection != null) {
            return this.currentSection;
        }
        if (this.currentSectionIndex < 0) {
            throw new IllegalArgumentException("Trying to access a section, but moveNext wasn't called");
        }
        if (this.currentSectionIndex >= this.conversionSections.size()) {
            throw new IllegalArgumentException("Trying to access more sections than avaiable");
        }
        throw new IllegalArgumentException("There is no current section");
    }

    public ConversionSectionWrapper peekNextSection() {
        int nextSectionIndex = this.currentSectionIndex + 1;
        if (nextSectionIndex >= 0 && nextSectionIndex < this.conversionSections.size()) {
            return this.conversionSections.get(nextSectionIndex);
        }
        return null;
    }
}

