/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.management.ManagementFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.threads.ContextClassLoaderSavingRunnable;
import org.jboss.threads.ContextHandler;
import org.jboss.threads.EnhancedQueueExecutorBase6;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.JDKSpecific;
import org.jboss.threads.Messages;
import org.jboss.threads.NullRunnable;
import org.jboss.threads.TimeUtil;
import org.jboss.threads.Version;
import org.jboss.threads.Waiter;
import org.jboss.threads.management.ManageableThreadPoolExecutorService;
import org.jboss.threads.management.StandardThreadPoolMXBean;
import org.wildfly.common.Assert;
import org.wildfly.common.cpu.ProcessorInfo;

public class EnhancedQueueExecutor
extends EnhancedQueueExecutorBase6
implements ManageableThreadPoolExecutorService,
ScheduledExecutorService {
    private static final Thread[] NO_THREADS = new Thread[0];
    public static final boolean DISABLE_HINT;
    static final boolean UPDATE_STATISTICS;
    static final boolean UPDATE_ACTIVE_COUNT;
    static final boolean NO_QUEUE_LIMIT;
    static final boolean REGISTER_MBEAN;
    static final boolean DISABLE_MBEAN;
    static final int PARK_SPINS;
    static final int YIELD_FACTOR;
    static final Executor DEFAULT_HANDLER;
    private final ThreadFactory threadFactory;
    private final Set<Thread> runningThreads = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MXBeanImpl mxBean;
    private final Object handle;
    private volatile AccessControlContext acc;
    private final ContextHandler<?> contextHandler;
    private final SchedulerTask schedulerTask = new SchedulerTask();
    private final Thread schedulerThread;
    volatile Waiter terminationWaiters;
    volatile long queueSize;
    volatile long timeoutNanos;
    volatile float growthResistance;
    volatile Executor handoffExecutor;
    volatile Thread.UncaughtExceptionHandler exceptionHandler;
    volatile Runnable terminationTask;
    volatile int peakThreadCount;
    volatile int peakQueueSize;
    private final LongAdder submittedTaskCounter = new LongAdder();
    private final LongAdder completedTaskCounter = new LongAdder();
    private final LongAdder rejectedTaskCounter = new LongAdder();
    private final LongAdder spinMisses = new LongAdder();
    volatile int activeCount;
    private static final long terminationWaitersOffset;
    private static final long queueSizeOffset;
    private static final long peakThreadCountOffset;
    private static final long activeCountOffset;
    private static final long peakQueueSizeOffset;
    private static final long TS_THREAD_CNT_MASK = 1048575L;
    private static final long TS_CURRENT_SHIFT = 0L;
    private static final long TS_CORE_SHIFT = 20L;
    private static final long TS_MAX_SHIFT = 40L;
    private static final long TS_ALLOW_CORE_TIMEOUT = 0x1000000000000000L;
    private static final long TS_SHUTDOWN_REQUESTED = 0x2000000000000000L;
    private static final long TS_SHUTDOWN_INTERRUPT = 0x4000000000000000L;
    private static final long TS_SHUTDOWN_COMPLETE = Long.MIN_VALUE;
    private static final int EXE_OK = 0;
    private static final int EXE_REJECT_QUEUE_FULL = 1;
    private static final int EXE_REJECT_SHUTDOWN = 2;
    private static final int EXE_CREATE_THREAD = 3;
    private static final int AT_YES = 0;
    private static final int AT_NO = 1;
    private static final int AT_SHUTDOWN = 2;
    static final QNode TERMINATE_REQUESTED;
    static final QNode TERMINATE_COMPLETE;
    static final Waiter TERMINATE_COMPLETE_WAITER;
    static final Runnable WAITING;
    static final Runnable GAVE_UP;
    static final Runnable ACCEPTED;
    static final Runnable EXIT;
    static final AtomicInteger sequence;
    private final String mBeanName;
    static final int ASF_ST_WAITING = 0;
    static final int ASF_ST_CANCELLED = 1;
    static final int ASF_ST_SUBMITTED = 2;
    static final int ASF_ST_RUNNING = 3;
    static final int ASF_ST_FINISHED = 4;
    static final int ASF_ST_FAILED = 5;
    static final int ASF_ST_REJECTED = 6;
    static final AbstractScheduledFuture<?>[] NO_FUTURES;
    static final AtomicLong SCHEDULED_TASK_SEQ;

    public EnhancedQueueExecutor(Builder builder) {
        int maxSize = builder.getMaximumPoolSize();
        int coreSize = Math.min(builder.getCorePoolSize(), maxSize);
        this.handoffExecutor = builder.getHandoffExecutor();
        this.exceptionHandler = builder.getExceptionHandler();
        this.threadFactory = builder.getThreadFactory();
        this.schedulerThread = this.threadFactory.newThread(this.schedulerTask);
        String schedulerName = this.schedulerThread.getName();
        this.schedulerThread.setName(schedulerName + " (scheduler)");
        this.terminationTask = builder.getTerminationTask();
        this.growthResistance = builder.getGrowthResistance();
        this.contextHandler = builder.getContextHandler();
        Duration keepAliveTime = builder.getKeepAliveTime();
        this.threadStatus = EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(EnhancedQueueExecutor.withAllowCoreTimeout(0L, builder.allowsCoreThreadTimeOut()), maxSize), coreSize);
        this.timeoutNanos = TimeUtil.clampedPositiveNanos((Duration)keepAliveTime);
        this.queueSize = EnhancedQueueExecutor.withMaxQueueSize(EnhancedQueueExecutor.withCurrentQueueSize(0L, 0), builder.getMaximumQueueSize());
        this.mxBean = new MXBeanImpl();
        this.mBeanName = builder.getMBeanName();
        if (!DISABLE_MBEAN && builder.isRegisterMBean()) {
            this.acc = AccessController.getContext();
            String configuredName = builder.getMBeanName();
            String finalName = configuredName != null ? configuredName : "threadpool-" + sequence.getAndIncrement();
            this.handle = AccessController.doPrivileged(new MBeanRegisterAction(finalName, this.mxBean), this.acc);
        } else {
            this.handle = null;
            this.acc = null;
        }
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public MXBeanImpl getMxBean() {
        return this.mxBean;
    }

    public Runnable getTerminationTask() {
        return this.terminationTask;
    }

    public String getMBeanName() {
        return this.mBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable runnable) {
        Assert.checkNotNullParam((String)"runnable", (Object)runnable);
        Task realRunnable = new Task(runnable, this.contextHandler.captureContext());
        int result = this.tryExecute(realRunnable);
        boolean ok = false;
        if (result == 0) {
            if (EnhancedQueueExecutor.currentSizeOf(this.threadStatus) == 0 && this.tryAllocateThread(0.0f) == 0 && !this.doStartThread(null)) {
                this.deallocateThread();
            }
            if (UPDATE_STATISTICS) {
                this.submittedTaskCounter.increment();
            }
            return;
        }
        if (result == 3) {
            try {
                ok = this.doStartThread(realRunnable);
            }
            finally {
                if (!ok) {
                    this.deallocateThread();
                }
            }
        } else {
            if (UPDATE_STATISTICS) {
                this.rejectedTaskCounter.increment();
            }
            if (result == 2) {
                this.rejectShutdown(realRunnable);
            } else {
                assert (result == 1);
                this.rejectQueueFull(realRunnable);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown(true);
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        TaskNode head = this.head;
        while (true) {
            QNode headNext;
            if ((headNext = head.getNext()) == head) {
                head = this.head;
                continue;
            }
            if (!(headNext instanceof TaskNode)) break;
            TaskNode taskNode = (TaskNode)headNext;
            if (!this.compareAndSetHead(head, taskNode)) continue;
            head.setNextOrdered(head);
            if (!NO_QUEUE_LIMIT) {
                this.decreaseQueueSize();
            }
            head = taskNode;
            list.add(taskNode.task.handoff());
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return EnhancedQueueExecutor.isShutdownRequested(this.threadStatus);
    }

    @Override
    public boolean isTerminated() {
        return EnhancedQueueExecutor.isShutdownComplete(this.threadStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Assert.checkMinimumParameter((String)"timeout", (long)0L, (long)timeout);
        Assert.checkNotNullParam((String)"unit", (Object)((Object)unit));
        if (timeout > 0L) {
            Thread thread = Thread.currentThread();
            if (this.runningThreads.contains(thread) || thread == this.schedulerThread) {
                throw Messages.msg.cannotAwaitWithin();
            }
            Waiter waiters = this.terminationWaiters;
            if (waiters == TERMINATE_COMPLETE_WAITER) {
                return true;
            }
            Waiter waiter = new Waiter(waiters);
            waiter.setThread(Thread.currentThread());
            while (!this.compareAndSetTerminationWaiters(waiters, waiter)) {
                waiters = this.terminationWaiters;
                if (waiters == TERMINATE_COMPLETE_WAITER) {
                    return true;
                }
                waiter.setNext(waiters);
            }
            try {
                LockSupport.parkNanos(this, unit.toNanos(timeout));
            }
            finally {
                waiter.setThread(null);
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.isTerminated();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new RunnableScheduledFuture(command, delay, unit));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new CallableScheduledFuture<V>(callable, delay, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new FixedRateRunnableScheduledFuture(command, initialDelay, period, unit));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.startScheduleThread();
        return this.schedulerTask.schedule(new FixedDelayRunnableScheduledFuture(command, initialDelay, delay, unit));
    }

    private void startScheduleThread() {
        if (this.schedulerThread.getState() == Thread.State.NEW) {
            try {
                this.schedulerThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public StandardThreadPoolMXBean getThreadPoolMXBean() {
        return this.mxBean;
    }

    public void shutdown(boolean interrupt) {
        long newStatus;
        long oldStatus;
        block16: {
            do {
                oldStatus = this.threadStatus;
                newStatus = EnhancedQueueExecutor.withShutdownRequested(oldStatus);
                if (interrupt) {
                    newStatus = EnhancedQueueExecutor.withShutdownInterrupt(newStatus);
                }
                if (EnhancedQueueExecutor.currentSizeOf(oldStatus) == 0) {
                    newStatus = EnhancedQueueExecutor.withShutdownComplete(newStatus);
                }
                if (newStatus != oldStatus) continue;
                return;
            } while (!this.compareAndSetThreadStatus(oldStatus, newStatus));
            assert (oldStatus != newStatus);
            if (EnhancedQueueExecutor.isShutdownRequested(newStatus) != EnhancedQueueExecutor.isShutdownRequested(oldStatus)) {
                QNode tailNext;
                block15: {
                    PoolThreadNode node;
                    assert (!EnhancedQueueExecutor.isShutdownRequested(oldStatus));
                    this.schedulerTask.shutdown();
                    TaskNode tail = this.tail;
                    while (true) {
                        if ((tailNext = tail.getNext()) instanceof TaskNode) {
                            tail = (TaskNode)tailNext;
                            continue;
                        }
                        if (!(tailNext instanceof PoolThreadNode) && tailNext != null) break block15;
                        node = (PoolThreadNode)tailNext;
                        if (tail.compareAndSetNext(node, TERMINATE_REQUESTED)) break;
                    }
                    while (node != null) {
                        node.compareAndSetTask(WAITING, EXIT);
                        node.unpark();
                        node = node.getNext();
                    }
                    break block16;
                }
                if (!(tailNext instanceof TerminateWaiterNode)) {
                    throw Assert.unreachableCode();
                }
            }
        }
        if (EnhancedQueueExecutor.isShutdownInterrupt(newStatus) != EnhancedQueueExecutor.isShutdownInterrupt(oldStatus)) {
            assert (!EnhancedQueueExecutor.isShutdownInterrupt(oldStatus));
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
            }
        }
        if (EnhancedQueueExecutor.isShutdownComplete(newStatus) != EnhancedQueueExecutor.isShutdownComplete(oldStatus)) {
            assert (!EnhancedQueueExecutor.isShutdownComplete(oldStatus));
            this.completeTermination();
        }
    }

    public boolean isTerminating() {
        long threadStatus = this.threadStatus;
        return EnhancedQueueExecutor.isShutdownRequested(threadStatus) && !EnhancedQueueExecutor.isShutdownComplete(threadStatus);
    }

    public boolean prestartCoreThread() {
        if (this.tryAllocateThread(1.0f) != 0) {
            return false;
        }
        if (this.doStartThread(null)) {
            return true;
        }
        this.deallocateThread();
        return false;
    }

    public int prestartAllCoreThreads() {
        int cnt = 0;
        while (this.prestartCoreThread()) {
            ++cnt;
        }
        return cnt;
    }

    public float getGrowthResistance() {
        return this.growthResistance;
    }

    public void setGrowthResistance(float growthResistance) {
        Assert.checkMinimumParameter((String)"growthResistance", (float)0.0f, (float)growthResistance);
        Assert.checkMaximumParameter((String)"growthResistance", (float)1.0f, (float)growthResistance);
        this.growthResistance = growthResistance;
    }

    public int getCorePoolSize() {
        return EnhancedQueueExecutor.coreSizeOf(this.threadStatus);
    }

    public void setCorePoolSize(int corePoolSize) {
        long newVal;
        long oldVal;
        Assert.checkMinimumParameter((String)"corePoolSize", (int)0, (int)corePoolSize);
        Assert.checkMaximumParameter((String)"corePoolSize", (long)1048575L, (long)corePoolSize);
        while (!this.compareAndSetThreadStatus(oldVal, newVal = corePoolSize > EnhancedQueueExecutor.maxSizeOf(oldVal = this.threadStatus) ? EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(oldVal, corePoolSize), corePoolSize) : EnhancedQueueExecutor.withCoreSize(oldVal, corePoolSize))) {
        }
        if (EnhancedQueueExecutor.maxSizeOf(newVal) < EnhancedQueueExecutor.maxSizeOf(oldVal) || EnhancedQueueExecutor.coreSizeOf(newVal) < EnhancedQueueExecutor.coreSizeOf(oldVal)) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public int getMaximumPoolSize() {
        return EnhancedQueueExecutor.maxSizeOf(this.threadStatus);
    }

    public void setMaximumPoolSize(int maxPoolSize) {
        long newVal;
        long oldVal;
        Assert.checkMinimumParameter((String)"maxPoolSize", (int)0, (int)maxPoolSize);
        Assert.checkMaximumParameter((String)"maxPoolSize", (long)1048575L, (long)maxPoolSize);
        while (!this.compareAndSetThreadStatus(oldVal, newVal = maxPoolSize < EnhancedQueueExecutor.coreSizeOf(oldVal = this.threadStatus) ? EnhancedQueueExecutor.withCoreSize(EnhancedQueueExecutor.withMaxSize(oldVal, maxPoolSize), maxPoolSize) : EnhancedQueueExecutor.withMaxSize(oldVal, maxPoolSize))) {
        }
        if (EnhancedQueueExecutor.maxSizeOf(newVal) < EnhancedQueueExecutor.maxSizeOf(oldVal) || EnhancedQueueExecutor.coreSizeOf(newVal) < EnhancedQueueExecutor.coreSizeOf(oldVal)) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    public boolean allowsCoreThreadTimeOut() {
        return EnhancedQueueExecutor.isAllowCoreTimeout(this.threadStatus);
    }

    public void allowCoreThreadTimeOut(boolean value) {
        long newVal;
        long oldVal;
        do {
            if ((oldVal = this.threadStatus) != (newVal = EnhancedQueueExecutor.withAllowCoreTimeout(oldVal, value))) continue;
            return;
        } while (!this.compareAndSetThreadStatus(oldVal, newVal));
        if (value) {
            for (Thread activeThread : this.runningThreads) {
                LockSupport.unpark(activeThread);
            }
        }
    }

    @Deprecated
    public long getKeepAliveTime(TimeUnit keepAliveUnits) {
        Assert.checkNotNullParam((String)"keepAliveUnits", (Object)((Object)keepAliveUnits));
        return keepAliveUnits.convert(this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    public Duration getKeepAliveTime() {
        return Duration.of(this.timeoutNanos, ChronoUnit.NANOS);
    }

    @Deprecated
    public void setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveUnits) {
        Assert.checkMinimumParameter((String)"keepAliveTime", (long)1L, (long)keepAliveTime);
        Assert.checkNotNullParam((String)"keepAliveUnits", (Object)((Object)keepAliveUnits));
        this.timeoutNanos = Math.max(1L, keepAliveUnits.toNanos(keepAliveTime));
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        Assert.checkNotNullParam((String)"keepAliveTime", (Object)keepAliveTime);
        this.timeoutNanos = TimeUtil.clampedPositiveNanos((Duration)keepAliveTime);
    }

    public int getMaximumQueueSize() {
        return EnhancedQueueExecutor.maxQueueSizeOf(this.queueSize);
    }

    public void setMaximumQueueSize(int maxQueueSize) {
        long oldVal;
        Assert.checkMinimumParameter((String)"maxQueueSize", (int)0, (int)maxQueueSize);
        Assert.checkMaximumParameter((String)"maxQueueSize", (int)Integer.MAX_VALUE, (int)maxQueueSize);
        if (NO_QUEUE_LIMIT) {
            return;
        }
        while (!this.compareAndSetQueueSize(oldVal = this.queueSize, EnhancedQueueExecutor.withMaxQueueSize(oldVal, maxQueueSize))) {
        }
    }

    public Executor getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public void setHandoffExecutor(Executor handoffExecutor) {
        Assert.checkNotNullParam((String)"handoffExecutor", (Object)handoffExecutor);
        this.handoffExecutor = handoffExecutor;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        Assert.checkNotNullParam((String)"exceptionHandler", (Object)exceptionHandler);
        this.exceptionHandler = exceptionHandler;
    }

    public void setTerminationTask(Runnable terminationTask) {
        this.terminationTask = terminationTask;
    }

    public int getQueueSize() {
        return NO_QUEUE_LIMIT ? -1 : EnhancedQueueExecutor.currentQueueSizeOf(this.queueSize);
    }

    public int getLargestPoolSize() {
        return UPDATE_STATISTICS ? this.peakThreadCount : -1;
    }

    public int getActiveCount() {
        return UPDATE_ACTIVE_COUNT ? this.activeCount : -1;
    }

    public int getLargestQueueSize() {
        return UPDATE_STATISTICS && !NO_QUEUE_LIMIT ? this.peakQueueSize : -1;
    }

    public long getSubmittedTaskCount() {
        return UPDATE_STATISTICS ? this.submittedTaskCounter.longValue() : -1L;
    }

    public long getRejectedTaskCount() {
        return UPDATE_STATISTICS ? this.rejectedTaskCounter.longValue() : -1L;
    }

    public long getCompletedTaskCount() {
        return UPDATE_STATISTICS ? this.completedTaskCounter.longValue() : -1L;
    }

    public int getPoolSize() {
        return EnhancedQueueExecutor.currentSizeOf(this.threadStatus);
    }

    public Thread[] getRunningThreads() {
        return this.runningThreads.toArray(NO_THREADS);
    }

    int tryAllocateThread(float growthResistance) {
        long oldStat;
        while (!EnhancedQueueExecutor.isShutdownRequested(oldStat = this.threadStatus)) {
            int oldSize = EnhancedQueueExecutor.currentSizeOf(oldStat);
            if (oldSize >= EnhancedQueueExecutor.maxSizeOf(oldStat)) {
                return 1;
            }
            if (oldSize >= EnhancedQueueExecutor.coreSizeOf(oldStat) && oldSize > 0 && growthResistance != 0.0f && (growthResistance == 1.0f || ThreadLocalRandom.current().nextFloat() < growthResistance)) {
                return 1;
            }
            int newSize = oldSize + 1;
            if (this.compareAndSetThreadStatus(oldStat, EnhancedQueueExecutor.withCurrentSize(oldStat, newSize))) {
                if (UPDATE_STATISTICS) {
                    int oldVal;
                    while ((oldVal = this.peakThreadCount) < newSize && !this.compareAndSetPeakThreadCount(oldVal, newSize)) {
                    }
                }
                return 0;
            }
            if (!UPDATE_STATISTICS) continue;
            this.spinMisses.increment();
        }
        return 2;
    }

    void deallocateThread() {
        long oldStat;
        while (!this.tryDeallocateThread(oldStat = this.threadStatus)) {
        }
    }

    boolean tryDeallocateThread(long oldStat) {
        long newStat = EnhancedQueueExecutor.withCurrentSize(oldStat, EnhancedQueueExecutor.currentSizeOf(oldStat) - 1);
        if (EnhancedQueueExecutor.currentSizeOf(newStat) == 0 && EnhancedQueueExecutor.isShutdownRequested(oldStat)) {
            newStat = EnhancedQueueExecutor.withShutdownComplete(newStat);
        }
        if (!this.compareAndSetThreadStatus(oldStat, newStat)) {
            return false;
        }
        if (EnhancedQueueExecutor.isShutdownComplete(newStat)) {
            this.completeTermination();
        }
        return true;
    }

    boolean doStartThread(Task runnable) throws RejectedExecutionException {
        Thread thread;
        try {
            thread = this.threadFactory.newThread(new ThreadBody(runnable));
        }
        catch (Throwable t) {
            if (runnable != null) {
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectException(runnable, t);
            }
            return false;
        }
        if (thread == null) {
            if (runnable != null) {
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectNoThread(runnable);
            }
            return false;
        }
        try {
            thread.start();
        }
        catch (Throwable t) {
            if (runnable != null) {
                if (UPDATE_STATISTICS) {
                    this.rejectedTaskCounter.increment();
                }
                this.rejectException(runnable, t);
            }
            return false;
        }
        return true;
    }

    private int tryExecute(Task runnable) {
        TaskNode tail = this.tail;
        TaskNode node = null;
        while (true) {
            QNode tailNext;
            if ((tailNext = tail.getNext()) != tail) {
                if (tailNext == null) {
                    int tr = this.tryAllocateThread(this.growthResistance);
                    if (tr == 0) {
                        return 3;
                    }
                    if (tr == 2) {
                        return 2;
                    }
                    assert (tr == 1);
                    if (!NO_QUEUE_LIMIT && !this.increaseQueueSize()) {
                        tr = this.tryAllocateThread(0.0f);
                        if (tr == 0) {
                            return 3;
                        }
                        if (tr == 2) {
                            return 2;
                        }
                        assert (tr == 1);
                        return 1;
                    }
                    if (node == null) {
                        node = new TaskNode(runnable);
                    }
                    if (tail.compareAndSetNext(null, node)) {
                        this.compareAndSetTail(tail, node);
                        return 0;
                    }
                    if (!NO_QUEUE_LIMIT) {
                        this.decreaseQueueSize();
                    }
                } else if (tailNext instanceof PoolThreadNode) {
                    QNode tailNextNext = tailNext.getNext();
                    if (tail.compareAndSetNext(tailNext, tailNextNext)) {
                        assert (tail instanceof TaskNode);
                        PoolThreadNode consumerNode = (PoolThreadNode)tailNext;
                        if (consumerNode.compareAndSetTask(WAITING, runnable)) {
                            consumerNode.compareAndSetNext(tailNextNext, null);
                            consumerNode.unpark();
                            return 0;
                        }
                    }
                } else if (tailNext instanceof TaskNode) {
                    TaskNode tailNextTaskNode = (TaskNode)tailNext;
                    if (this.compareAndSetTail(tail, tailNextTaskNode)) {
                        tail = tailNextTaskNode;
                        continue;
                    }
                } else {
                    assert (tailNext instanceof TerminateWaiterNode);
                    return 2;
                }
            }
            if (UPDATE_STATISTICS) {
                this.spinMisses.increment();
            }
            tail = this.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeTermination() {
        boolean intr = Thread.interrupted();
        try {
            Runnable terminationTask = JBossExecutors.classLoaderPreservingTask((Runnable)this.terminationTask);
            this.terminationTask = null;
            try {
                terminationTask.run();
            }
            catch (Throwable t) {
                try {
                    this.exceptionHandler.uncaughtException(Thread.currentThread(), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (Waiter waiters = this.getAndSetTerminationWaiters(TERMINATE_COMPLETE_WAITER); waiters != null; waiters = waiters.getNext()) {
                LockSupport.unpark(waiters.getThread());
            }
            this.tail.setNext(TERMINATE_COMPLETE);
            if (!DISABLE_MBEAN && this.acc != null) {
                Object handle = this.handle;
                if (handle != null) {
                    intr = intr || Thread.interrupted();
                    AccessController.doPrivileged(new MBeanUnregisterAction(handle), this.acc);
                }
                this.acc = null;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void incrementActiveCount() {
        JBossExecutors.unsafe.getAndAddInt(this, activeCountOffset, 1);
    }

    void decrementActiveCount() {
        JBossExecutors.unsafe.getAndAddInt(this, activeCountOffset, -1);
    }

    boolean compareAndSetPeakThreadCount(int expect, int update) {
        return JBossExecutors.unsafe.compareAndSwapInt(this, peakThreadCountOffset, expect, update);
    }

    boolean compareAndSetPeakQueueSize(int expect, int update) {
        return JBossExecutors.unsafe.compareAndSwapInt(this, peakQueueSizeOffset, expect, update);
    }

    boolean compareAndSetQueueSize(long expect, long update) {
        return JBossExecutors.unsafe.compareAndSwapLong(this, queueSizeOffset, expect, update);
    }

    boolean compareAndSetTerminationWaiters(Waiter expect, Waiter update) {
        return JBossExecutors.unsafe.compareAndSwapObject(this, terminationWaitersOffset, expect, update);
    }

    Waiter getAndSetTerminationWaiters(Waiter update) {
        return (Waiter)JBossExecutors.unsafe.getAndSetObject(this, terminationWaitersOffset, update);
    }

    boolean increaseQueueSize() {
        long oldVal = this.queueSize;
        int oldSize = EnhancedQueueExecutor.currentQueueSizeOf(oldVal);
        if (oldSize >= EnhancedQueueExecutor.maxQueueSizeOf(oldVal)) {
            return false;
        }
        int newSize = oldSize + 1;
        while (!this.compareAndSetQueueSize(oldVal, EnhancedQueueExecutor.withCurrentQueueSize(oldVal, newSize))) {
            if (UPDATE_STATISTICS) {
                this.spinMisses.increment();
            }
            if ((oldSize = EnhancedQueueExecutor.currentQueueSizeOf(oldVal = this.queueSize)) >= EnhancedQueueExecutor.maxQueueSizeOf(oldVal)) {
                return false;
            }
            newSize = oldSize + 1;
        }
        if (UPDATE_STATISTICS) {
            while (newSize > (oldSize = this.peakQueueSize) && !this.compareAndSetPeakQueueSize(oldSize, newSize)) {
            }
        }
        return true;
    }

    void decreaseQueueSize() {
        long oldVal = this.queueSize;
        assert (EnhancedQueueExecutor.currentQueueSizeOf(oldVal) > 0);
        while (!this.compareAndSetQueueSize(oldVal, EnhancedQueueExecutor.withCurrentQueueSize(oldVal, EnhancedQueueExecutor.currentQueueSizeOf(oldVal) - 1))) {
            if (UPDATE_STATISTICS) {
                this.spinMisses.increment();
            }
            oldVal = this.queueSize;
            assert (EnhancedQueueExecutor.currentQueueSizeOf(oldVal) > 0);
        }
    }

    static int currentQueueSizeOf(long queueSize) {
        return (int)(queueSize & Integer.MAX_VALUE);
    }

    static long withCurrentQueueSize(long queueSize, int current) {
        assert (current >= 0);
        return queueSize & 0xFFFFFFFF00000000L | (long)current;
    }

    static int maxQueueSizeOf(long queueSize) {
        return (int)(queueSize >>> 32 & Integer.MAX_VALUE);
    }

    static long withMaxQueueSize(long queueSize, int max) {
        assert (max >= 0);
        return queueSize & 0xFFFFFFFFL | (long)max << 32;
    }

    static int coreSizeOf(long status) {
        return (int)(status >>> 20 & 0xFFFFFL);
    }

    static int maxSizeOf(long status) {
        return (int)(status >>> 40 & 0xFFFFFL);
    }

    static int currentSizeOf(long status) {
        return (int)(status >>> 0 & 0xFFFFFL);
    }

    static long withCoreSize(long status, int newCoreSize) {
        assert (0 <= newCoreSize && (long)newCoreSize <= 1048575L);
        return status & 0xFFFFFF00000FFFFFL | (long)newCoreSize << 20;
    }

    static long withCurrentSize(long status, int newCurrentSize) {
        assert (0 <= newCurrentSize && (long)newCurrentSize <= 1048575L);
        return status & 0xFFFFFFFFFFF00000L | (long)newCurrentSize << 0;
    }

    static long withMaxSize(long status, int newMaxSize) {
        assert (0 <= newMaxSize && (long)newMaxSize <= 1048575L);
        return status & 0xF00000FFFFFFFFFFL | (long)newMaxSize << 40;
    }

    static long withShutdownRequested(long status) {
        return status | 0x2000000000000000L;
    }

    static long withShutdownComplete(long status) {
        return status | Long.MIN_VALUE;
    }

    static long withShutdownInterrupt(long status) {
        return status | 0x4000000000000000L;
    }

    static long withAllowCoreTimeout(long status, boolean allowed) {
        return allowed ? status | 0x1000000000000000L : status & 0xEFFFFFFFFFFFFFFFL;
    }

    static boolean isShutdownRequested(long status) {
        return (status & 0x2000000000000000L) != 0L;
    }

    static boolean isShutdownComplete(long status) {
        return (status & Long.MIN_VALUE) != 0L;
    }

    static boolean isShutdownInterrupt(long threadStatus) {
        return (threadStatus & 0x4000000000000000L) != 0L;
    }

    static boolean isAllowCoreTimeout(long oldVal) {
        return (oldVal & 0x1000000000000000L) != 0L;
    }

    void rejectException(Task task, Throwable cause) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(cause);
            throw t;
        }
    }

    void rejectNoThread(Task task) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("No threads available"));
            throw t;
        }
    }

    void rejectQueueFull(Task task) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("Queue is full"));
            throw t;
        }
    }

    void rejectShutdown(Task task) {
        try {
            this.handoffExecutor.execute(task.handoff());
        }
        catch (Throwable t) {
            t.addSuppressed(new RejectedExecutionException("Executor is being shut down"));
            throw t;
        }
    }

    static Runnable nullToNop(Runnable task) {
        return task == null ? NullRunnable.getInstance() : task;
    }

    static int wrongType() throws ClassCastException {
        throw new ClassCastException("Wrong task type for comparison");
    }

    static {
        Version.getVersionString();
        MBeanUnregisterAction.forceInit();
        DISABLE_HINT = EnhancedQueueExecutor.readBooleanPropertyPrefixed((String)"disable", (boolean)false);
        UPDATE_STATISTICS = EnhancedQueueExecutor.readBooleanPropertyPrefixed((String)"statistics", (boolean)false);
        UPDATE_ACTIVE_COUNT = UPDATE_STATISTICS || EnhancedQueueExecutor.readBooleanPropertyPrefixed((String)"statistics.active-count", (boolean)false);
        NO_QUEUE_LIMIT = EnhancedQueueExecutor.readBooleanPropertyPrefixed((String)"unlimited-queue", (boolean)false);
        REGISTER_MBEAN = EnhancedQueueExecutor.readBooleanPropertyPrefixed((String)"register-mbean", (boolean)true);
        DISABLE_MBEAN = EnhancedQueueExecutor.readBooleanPropertyPrefixed((String)"disable-mbean", (EnhancedQueueExecutor.readProperty((String)"org.graalvm.nativeimage.imagecode", null) != null ? 1 : 0) != 0);
        PARK_SPINS = EnhancedQueueExecutor.readIntPropertyPrefixed((String)"park-spins", (int)(ProcessorInfo.availableProcessors() == 1 ? 0 : 128));
        YIELD_FACTOR = Math.max(Math.min(EnhancedQueueExecutor.readIntPropertyPrefixed((String)"park-yields", (int)1), PARK_SPINS), 0);
        DEFAULT_HANDLER = JBossExecutors.rejectingExecutor();
        try {
            terminationWaitersOffset = JBossExecutors.unsafe.objectFieldOffset(EnhancedQueueExecutor.class.getDeclaredField("terminationWaiters"));
            queueSizeOffset = JBossExecutors.unsafe.objectFieldOffset(EnhancedQueueExecutor.class.getDeclaredField("queueSize"));
            peakThreadCountOffset = JBossExecutors.unsafe.objectFieldOffset(EnhancedQueueExecutor.class.getDeclaredField("peakThreadCount"));
            activeCountOffset = JBossExecutors.unsafe.objectFieldOffset(EnhancedQueueExecutor.class.getDeclaredField("activeCount"));
            peakQueueSizeOffset = JBossExecutors.unsafe.objectFieldOffset(EnhancedQueueExecutor.class.getDeclaredField("peakQueueSize"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        TERMINATE_REQUESTED = new TerminateWaiterNode();
        TERMINATE_COMPLETE = new TerminateWaiterNode();
        TERMINATE_COMPLETE_WAITER = new Waiter(null);
        WAITING = new NullRunnable();
        GAVE_UP = new NullRunnable();
        ACCEPTED = new NullRunnable();
        EXIT = new NullRunnable();
        sequence = new AtomicInteger(1);
        NO_FUTURES = new AbstractScheduledFuture[0];
        SCHEDULED_TASK_SEQ = new AtomicLong();
    }

    final class SchedulerTask
    implements Runnable {
        final long startMark = System.nanoTime();
        final ReentrantLock ql = new ReentrantLock();
        final Condition qc = this.ql.newCondition();
        ScheduledFutureQueue q = new TreeSetQueue();
        boolean shutdownDetected;

        SchedulerTask() {
        }

        void shutdown() {
            this.ql.lock();
            try {
                this.shutdownDetected = true;
                this.qc.signal();
            }
            finally {
                this.ql.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractScheduledFuture<?>[] remainingFutures;
            ScheduledFutureQueue q = this.q;
            long startMark = this.startMark;
            block8: while (true) {
                AbstractScheduledFuture<?> first;
                this.ql.lock();
                try {
                    while (true) {
                        long now = System.nanoTime();
                        if (this.shutdownDetected) {
                            remainingFutures = q.toArray();
                            q.clear();
                            break block8;
                        }
                        if (q.isEmpty()) {
                            try {
                                this.qc.await();
                            }
                            catch (InterruptedException ignored) {}
                            continue;
                        }
                        first = q.first();
                        long firstWhen = first.when;
                        long currentWhen = Math.max(0L, now - startMark);
                        if (firstWhen <= currentWhen) {
                            q.pollFirst();
                            break;
                        }
                        long waitTime = firstWhen - currentWhen;
                        try {
                            this.qc.awaitNanos(waitTime);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                finally {
                    this.ql.unlock();
                }
                first.submit();
            }
            if (remainingFutures.length > 0) {
                for (AbstractScheduledFuture<?> future : remainingFutures) {
                    future.cancel(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T, F extends AbstractScheduledFuture<T>> F schedule(F item) {
            Task wrappingTask = item.wrappingTask;
            if (item.when <= this.age()) {
                item.submit();
                return item;
            }
            this.ql.lock();
            try {
                boolean first;
                if (this.shutdownDetected) {
                    EnhancedQueueExecutor.this.rejectShutdown(wrappingTask);
                    F f = item;
                    return f;
                }
                while (true) {
                    try {
                        first = this.q.insertAndCheckForFirst(item);
                    }
                    catch (QueueFullException ignored) {
                        this.q = this.q.grow();
                        continue;
                    }
                    break;
                }
                if (first) {
                    this.qc.signal();
                }
                F f = item;
                return f;
            }
            finally {
                this.ql.unlock();
            }
        }

        long age() {
            return System.nanoTime() - this.startMark;
        }
    }

    public static final class Builder {
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private Runnable terminationTask = NullRunnable.getInstance();
        private Executor handoffExecutor = DEFAULT_HANDLER;
        private Thread.UncaughtExceptionHandler exceptionHandler = JBossExecutors.loggingExceptionHandler();
        private int coreSize = 16;
        private int maxSize = 64;
        private Duration keepAliveTime = Duration.ofSeconds(30L);
        private float growthResistance;
        private boolean allowCoreTimeOut;
        private int maxQueueSize = Integer.MAX_VALUE;
        private boolean registerMBean = REGISTER_MBEAN;
        private String mBeanName;
        private ContextHandler<?> contextHandler = ContextHandler.NONE;

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            Assert.checkNotNullParam((String)"threadFactory", (Object)threadFactory);
            this.threadFactory = threadFactory;
            return this;
        }

        public Runnable getTerminationTask() {
            return this.terminationTask;
        }

        public Builder setTerminationTask(Runnable terminationTask) {
            Assert.checkNotNullParam((String)"terminationTask", (Object)terminationTask);
            this.terminationTask = terminationTask;
            return this;
        }

        public int getCorePoolSize() {
            return this.coreSize;
        }

        public Builder setCorePoolSize(int coreSize) {
            Assert.checkMinimumParameter((String)"coreSize", (int)0, (int)coreSize);
            Assert.checkMaximumParameter((String)"coreSize", (long)1048575L, (long)coreSize);
            this.coreSize = coreSize;
            return this;
        }

        public int getMaximumPoolSize() {
            return this.maxSize;
        }

        public Builder setMaximumPoolSize(int maxSize) {
            Assert.checkMinimumParameter((String)"maxSize", (int)0, (int)maxSize);
            Assert.checkMaximumParameter((String)"maxSize", (long)1048575L, (long)maxSize);
            this.maxSize = maxSize;
            return this;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        @Deprecated
        public long getKeepAliveTime(TimeUnit keepAliveUnits) {
            Assert.checkNotNullParam((String)"keepAliveUnits", (Object)((Object)keepAliveUnits));
            long secondsPart = keepAliveUnits.convert(this.keepAliveTime.getSeconds(), TimeUnit.SECONDS);
            long nanoPart = keepAliveUnits.convert(this.keepAliveTime.getNano(), TimeUnit.NANOSECONDS);
            long sum = secondsPart + nanoPart;
            return sum < 0L ? Long.MAX_VALUE : sum;
        }

        public Builder setKeepAliveTime(Duration keepAliveTime) {
            Assert.checkNotNullParam((String)"keepAliveTime", (Object)keepAliveTime);
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        @Deprecated
        public Builder setKeepAliveTime(long keepAliveTime, TimeUnit keepAliveUnits) {
            Assert.checkMinimumParameter((String)"keepAliveTime", (long)1L, (long)keepAliveTime);
            Assert.checkNotNullParam((String)"keepAliveUnits", (Object)((Object)keepAliveUnits));
            this.keepAliveTime = Duration.of(keepAliveTime, JDKSpecific.timeToTemporal((TimeUnit)keepAliveUnits));
            return this;
        }

        public float getGrowthResistance() {
            return this.growthResistance;
        }

        public Builder setGrowthResistance(float growthResistance) {
            Assert.checkMinimumParameter((String)"growthResistance", (float)0.0f, (float)growthResistance);
            Assert.checkMaximumParameter((String)"growthResistance", (float)1.0f, (float)growthResistance);
            this.growthResistance = growthResistance;
            return this;
        }

        public boolean allowsCoreThreadTimeOut() {
            return this.allowCoreTimeOut;
        }

        public Builder allowCoreThreadTimeOut(boolean allowCoreTimeOut) {
            this.allowCoreTimeOut = allowCoreTimeOut;
            return this;
        }

        public int getMaximumQueueSize() {
            return this.maxQueueSize;
        }

        public Builder setMaximumQueueSize(int maxQueueSize) {
            Assert.checkMinimumParameter((String)"maxQueueSize", (int)0, (int)maxQueueSize);
            Assert.checkMaximumParameter((String)"maxQueueSize", (int)Integer.MAX_VALUE, (int)maxQueueSize);
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Executor getHandoffExecutor() {
            return this.handoffExecutor;
        }

        public Builder setHandoffExecutor(Executor handoffExecutor) {
            Assert.checkNotNullParam((String)"handoffExecutor", (Object)handoffExecutor);
            this.handoffExecutor = handoffExecutor;
            return this;
        }

        public Thread.UncaughtExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public Builder setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public EnhancedQueueExecutor build() {
            return new EnhancedQueueExecutor(this);
        }

        public boolean isRegisterMBean() {
            return this.registerMBean;
        }

        public Builder setRegisterMBean(boolean registerMBean) {
            this.registerMBean = registerMBean;
            return this;
        }

        public String getMBeanName() {
            return this.mBeanName;
        }

        public Builder setMBeanName(String mBeanName) {
            this.mBeanName = mBeanName;
            return this;
        }

        public ContextHandler<?> getContextHandler() {
            return this.contextHandler;
        }

        public Builder setContextHandler(ContextHandler<?> contextHandler) {
            Assert.checkNotNullParam((String)"contextHandler", contextHandler);
            this.contextHandler = contextHandler;
            return this;
        }
    }

    final class MXBeanImpl
    implements StandardThreadPoolMXBean {
        MXBeanImpl() {
        }

        public float getGrowthResistance() {
            return EnhancedQueueExecutor.this.getGrowthResistance();
        }

        public void setGrowthResistance(float value) {
            EnhancedQueueExecutor.this.setGrowthResistance(value);
        }

        public boolean isGrowthResistanceSupported() {
            return true;
        }

        public int getCorePoolSize() {
            return EnhancedQueueExecutor.this.getCorePoolSize();
        }

        public void setCorePoolSize(int corePoolSize) {
            EnhancedQueueExecutor.this.setCorePoolSize(corePoolSize);
        }

        public boolean isCorePoolSizeSupported() {
            return true;
        }

        public boolean prestartCoreThread() {
            return EnhancedQueueExecutor.this.prestartCoreThread();
        }

        public int prestartAllCoreThreads() {
            return EnhancedQueueExecutor.this.prestartAllCoreThreads();
        }

        public boolean isCoreThreadPrestartSupported() {
            return true;
        }

        public int getMaximumPoolSize() {
            return EnhancedQueueExecutor.this.getMaximumPoolSize();
        }

        public void setMaximumPoolSize(int maxPoolSize) {
            EnhancedQueueExecutor.this.setMaximumPoolSize(maxPoolSize);
        }

        public int getPoolSize() {
            return EnhancedQueueExecutor.this.getPoolSize();
        }

        public int getLargestPoolSize() {
            return EnhancedQueueExecutor.this.getLargestPoolSize();
        }

        public int getActiveCount() {
            return EnhancedQueueExecutor.this.getActiveCount();
        }

        public boolean isAllowCoreThreadTimeOut() {
            return EnhancedQueueExecutor.this.allowsCoreThreadTimeOut();
        }

        public void setAllowCoreThreadTimeOut(boolean value) {
            EnhancedQueueExecutor.this.allowCoreThreadTimeOut(value);
        }

        public long getKeepAliveTimeSeconds() {
            return EnhancedQueueExecutor.this.getKeepAliveTime().getSeconds();
        }

        public void setKeepAliveTimeSeconds(long seconds) {
            EnhancedQueueExecutor.this.setKeepAliveTime(Duration.of(seconds, ChronoUnit.SECONDS));
        }

        public int getMaximumQueueSize() {
            return EnhancedQueueExecutor.this.getMaximumQueueSize();
        }

        public void setMaximumQueueSize(int size) {
            EnhancedQueueExecutor.this.setMaximumQueueSize(size);
        }

        public int getQueueSize() {
            return EnhancedQueueExecutor.this.getQueueSize();
        }

        public int getLargestQueueSize() {
            return EnhancedQueueExecutor.this.getLargestQueueSize();
        }

        public boolean isQueueBounded() {
            return !NO_QUEUE_LIMIT;
        }

        public boolean isQueueSizeModifiable() {
            return !NO_QUEUE_LIMIT;
        }

        public boolean isShutdown() {
            return EnhancedQueueExecutor.this.isShutdown();
        }

        public boolean isTerminating() {
            return EnhancedQueueExecutor.this.isTerminating();
        }

        public boolean isTerminated() {
            return EnhancedQueueExecutor.this.isTerminated();
        }

        public long getSubmittedTaskCount() {
            return EnhancedQueueExecutor.this.getSubmittedTaskCount();
        }

        public long getRejectedTaskCount() {
            return EnhancedQueueExecutor.this.getRejectedTaskCount();
        }

        public long getCompletedTaskCount() {
            return EnhancedQueueExecutor.this.getCompletedTaskCount();
        }

        public long getSpinMissCount() {
            return EnhancedQueueExecutor.this.spinMisses.longValue();
        }
    }

    static final class MBeanRegisterAction
    implements PrivilegedAction<ObjectInstance> {
        private final String finalName;
        private final MXBeanImpl mxBean;

        MBeanRegisterAction(String finalName, MXBeanImpl mxBean) {
            this.finalName = finalName;
            this.mxBean = mxBean;
        }

        @Override
        public ObjectInstance run() {
            try {
                Hashtable<String, String> table = new Hashtable<String, String>();
                table.put("name", ObjectName.quote(this.finalName));
                table.put("type", "thread-pool");
                return ManagementFactory.getPlatformMBeanServer().registerMBean(this.mxBean, new ObjectName("jboss.threads", table));
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    final class Task
    implements Runnable {
        private final Runnable delegate;
        private final ClassLoader contextClassLoader;
        private final Object context;

        Task(Runnable delegate, Object context) {
            Assert.checkNotNullParam((String)"delegate", (Object)delegate);
            this.delegate = delegate;
            this.context = context;
            this.contextClassLoader = JBossExecutors.getContextClassLoader((Thread)Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (EnhancedQueueExecutor.isShutdownInterrupt(EnhancedQueueExecutor.this.threadStatus)) {
                Thread.currentThread().interrupt();
            } else {
                Thread.interrupted();
            }
            if (UPDATE_ACTIVE_COUNT) {
                EnhancedQueueExecutor.this.incrementActiveCount();
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader old = JBossExecutors.getAndSetContextClassLoader((Thread)currentThread, (ClassLoader)this.contextClassLoader);
            try {
                EnhancedQueueExecutor.this.contextHandler.runWith(this.delegate, this.context);
            }
            catch (Throwable t) {
                try {
                    EnhancedQueueExecutor.this.exceptionHandler.uncaughtException(Thread.currentThread(), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                JBossExecutors.setContextClassLoader((Thread)currentThread, (ClassLoader)old);
            }
            Thread.interrupted();
            if (UPDATE_ACTIVE_COUNT) {
                EnhancedQueueExecutor.this.decrementActiveCount();
                if (UPDATE_STATISTICS) {
                    EnhancedQueueExecutor.this.completedTaskCounter.increment();
                }
            }
        }

        Runnable handoff() {
            return new ContextClassLoaderSavingRunnable(this.contextClassLoader, this.delegate);
        }

        public String toString() {
            return "Task{delegate=" + this.delegate + ", contextClassLoader=" + this.contextClassLoader + "}";
        }
    }

    static final class TaskNode
    extends QNode {
        Task task;

        TaskNode(Task task) {
            this.task = task;
        }

        Runnable getAndClearTask() {
            Task result = this.task;
            this.task = null;
            return result;
        }
    }

    static abstract class QNode {
        private static final long nextOffset;
        private volatile QNode next;

        QNode() {
        }

        boolean compareAndSetNext(QNode expect, QNode update) {
            return JBossExecutors.unsafe.compareAndSwapObject(this, nextOffset, expect, update);
        }

        QNode getNext() {
            return this.next;
        }

        void setNext(QNode node) {
            this.next = node;
        }

        void setNextRelaxed(QNode node) {
            JBossExecutors.unsafe.putObject(this, nextOffset, node);
        }

        void setNextOrdered(QNode node) {
            JBossExecutors.unsafe.putOrderedObject(this, nextOffset, node);
        }

        static {
            try {
                nextOffset = JBossExecutors.unsafe.objectFieldOffset(QNode.class.getDeclaredField("next"));
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    }

    final class RunnableScheduledFuture
    extends AbstractScheduledFuture<Void> {
        final Runnable runnable;

        RunnableScheduledFuture(Runnable runnable, long delay, TimeUnit unit) {
            super(delay, unit);
            this.runnable = runnable;
        }

        @Override
        Void performTask() {
            this.runnable.run();
            return null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.runnable);
        }
    }

    abstract class AbstractScheduledFuture<V>
    implements ScheduledFuture<V>,
    Runnable {
        final long seq = SCHEDULED_TASK_SEQ.getAndIncrement();
        final Task wrappingTask;
        volatile long when;
        volatile int state = 0;
        volatile Object result;
        Thread liveThread;

        AbstractScheduledFuture(long delay, TimeUnit unit) {
            this.when = Math.addExact(EnhancedQueueExecutor.this.schedulerTask.age(), unit.toNanos(delay));
            this.wrappingTask = new Task(this, EnhancedQueueExecutor.this.contextHandler.captureContext());
        }

        @Override
        public int compareTo(Delayed o) {
            return o instanceof AbstractScheduledFuture ? this.compareTo((AbstractScheduledFuture)o) : EnhancedQueueExecutor.wrongType();
        }

        @Override
        public int compareTo(AbstractScheduledFuture<?> other) {
            int cmp = Long.compare(this.when, other.when);
            if (cmp == 0) {
                cmp = Long.compare(this.seq, other.seq);
            }
            return cmp;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(Math.max(0L, this.when - EnhancedQueueExecutor.this.schedulerTask.age()), TimeUnit.NANOSECONDS);
        }

        @Override
        public boolean isCancelled() {
            return this.state == 1;
        }

        @Override
        public boolean isDone() {
            int state = this.state;
            return state == 4 || state == 5 || state == 1 || state == 6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                int state = this.state;
                switch (state) {
                    case 0: 
                    case 2: {
                        this.state = 1;
                        return true;
                    }
                    case 3: {
                        if (mayInterruptIfRunning) {
                            this.liveThread.interrupt();
                        }
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                while (true) {
                    int state = this.state;
                    switch (state) {
                        case 0: 
                        case 2: 
                        case 3: {
                            this.wait();
                            break;
                        }
                        case 1: {
                            throw new CancellationException("Task was cancelled");
                        }
                        case 6: {
                            throw new ExecutionException("Task failed due to rejection", (RejectedExecutionException)this.result);
                        }
                        case 5: {
                            throw new ExecutionException((Throwable)this.result);
                        }
                        case 4: {
                            return (V)this.result;
                        }
                    }
                }
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long remaining = unit.toNanos(timeout);
            long start = System.nanoTime();
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                while (true) {
                    int state = this.state;
                    switch (state) {
                        case 0: 
                        case 2: 
                        case 3: {
                            if (remaining <= 0L) {
                                throw new TimeoutException();
                            }
                            this.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                            break;
                        }
                        case 1: {
                            throw new CancellationException("Task was cancelled");
                        }
                        case 6: {
                            throw new ExecutionException("Task failed due to rejection", (RejectedExecutionException)this.result);
                        }
                        case 5: {
                            throw new ExecutionException((Throwable)this.result);
                        }
                        case 4: {
                            return (V)this.result;
                        }
                    }
                    long newStart = System.nanoTime();
                    long elapsed = newStart - start;
                    remaining -= elapsed;
                    start = newStart;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 2: {
                        this.state = 3;
                        this.liveThread = Thread.currentThread();
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 5: 
                    case 6: {
                        return;
                    }
                    default: {
                        this.fail(this.badState());
                        return;
                    }
                }
            }
            try {
                this.finish(this.performTask());
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submit() {
            block23: {
                AbstractScheduledFuture abstractScheduledFuture = this;
                synchronized (abstractScheduledFuture) {
                    switch (this.state) {
                        case 0: {
                            this.state = 2;
                            break;
                        }
                        case 1: {
                            return;
                        }
                        case 5: 
                        case 6: {
                            return;
                        }
                        default: {
                            this.fail(this.badState());
                            return;
                        }
                    }
                }
                try {
                    int result = EnhancedQueueExecutor.this.tryExecute(this.wrappingTask);
                    boolean ok = false;
                    if (result == 0) {
                        if (EnhancedQueueExecutor.currentSizeOf(EnhancedQueueExecutor.this.threadStatus) == 0 && EnhancedQueueExecutor.this.tryAllocateThread(0.0f) == 0 && !EnhancedQueueExecutor.this.doStartThread(null)) {
                            EnhancedQueueExecutor.this.deallocateThread();
                        }
                        if (UPDATE_STATISTICS) {
                            EnhancedQueueExecutor.this.submittedTaskCounter.increment();
                        }
                        return;
                    }
                    if (result == 3) {
                        try {
                            ok = EnhancedQueueExecutor.this.doStartThread(this.wrappingTask);
                            break block23;
                        }
                        finally {
                            if (!ok) {
                                EnhancedQueueExecutor.this.deallocateThread();
                            }
                        }
                    }
                    if (UPDATE_STATISTICS) {
                        EnhancedQueueExecutor.this.rejectedTaskCounter.increment();
                    }
                    if (result == 2) {
                        EnhancedQueueExecutor.this.rejectShutdown(this.wrappingTask);
                    } else {
                        assert (result == 1);
                        EnhancedQueueExecutor.this.rejectQueueFull(this.wrappingTask);
                    }
                }
                catch (RejectedExecutionException e) {
                    this.reject(e);
                }
                catch (Throwable t) {
                    this.reject(new RejectedExecutionException("Task submission failed", t));
                }
            }
        }

        IllegalStateException badState() {
            return new IllegalStateException("Task was not in expected state");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reject(RejectedExecutionException e) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 2: {
                        this.result = e;
                        this.state = 6;
                        this.liveThread = null;
                        this.notifyAll();
                        return;
                    }
                }
                this.fail(this.badState());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fail(Throwable t) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 0: 
                    case 2: 
                    case 3: {
                        this.result = t;
                        this.state = 5;
                        this.liveThread = null;
                        this.notifyAll();
                        return;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish(V result) {
            AbstractScheduledFuture abstractScheduledFuture = this;
            synchronized (abstractScheduledFuture) {
                switch (this.state) {
                    case 3: {
                        this.result = result;
                        this.state = 4;
                        this.liveThread = null;
                        this.notifyAll();
                        return;
                    }
                }
                this.fail(this.badState());
                return;
            }
        }

        abstract V performTask() throws Exception;

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        StringBuilder toString(StringBuilder b) {
            return b.append("future result of ");
        }
    }

    final class CallableScheduledFuture<V>
    extends AbstractScheduledFuture<V> {
        final Callable<V> callable;

        CallableScheduledFuture(Callable<V> callable, long delay, TimeUnit unit) {
            super(delay, unit);
            this.callable = callable;
        }

        @Override
        V performTask() throws Exception {
            return this.callable.call();
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.callable);
        }
    }

    final class FixedRateRunnableScheduledFuture
    extends RepeatingScheduledFuture<Void> {
        final Runnable runnable;

        FixedRateRunnableScheduledFuture(Runnable runnable, long delay, long period, TimeUnit unit) {
            super(delay, period, unit);
            this.runnable = runnable;
        }

        @Override
        void adjustTime() {
            this.when += this.period;
        }

        @Override
        Void performTask() {
            this.runnable.run();
            return null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.runnable);
        }
    }

    final class FixedDelayRunnableScheduledFuture
    extends RepeatingScheduledFuture<Void> {
        final Runnable runnable;

        FixedDelayRunnableScheduledFuture(Runnable runnable, long delay, long period, TimeUnit unit) {
            super(delay, period, unit);
            this.runnable = runnable;
        }

        @Override
        void adjustTime() {
            this.when = EnhancedQueueExecutor.this.schedulerTask.age() + this.period;
        }

        @Override
        Void performTask() {
            this.runnable.run();
            return null;
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b).append(this.runnable);
        }
    }

    static final class PoolThreadNode
    extends PoolThreadNodeBase {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_PARKED = 1;
        private static final int STATE_UNPARKED = 2;
        private static final long taskOffset;
        private static final long parkedOffset;
        private final Thread thread;
        private volatile Runnable task;
        private volatile int parked;

        PoolThreadNode(Thread thread) {
            this.thread = thread;
            this.task = WAITING;
        }

        boolean compareAndSetTask(Runnable expect, Runnable update) {
            return this.task == expect && JBossExecutors.unsafe.compareAndSwapObject(this, taskOffset, expect, update);
        }

        Runnable getTask() {
            return this.task;
        }

        @Override
        PoolThreadNode getNext() {
            return (PoolThreadNode)super.getNext();
        }

        void park(EnhancedQueueExecutor enhancedQueueExecutor) {
            if (this.parked == 2 && JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 2, 0)) {
                return;
            }
            for (int spins = PARK_SPINS; spins > 0; --spins) {
                if (spins < YIELD_FACTOR) {
                    Thread.yield();
                    continue;
                }
                JDKSpecific.onSpinWait();
                if (this.parked != 2 || !JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 2, 0)) continue;
                return;
            }
            if (this.parked == 0 && JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 0, 1)) {
                try {
                    LockSupport.park(enhancedQueueExecutor);
                }
                finally {
                    this.parked = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void park(EnhancedQueueExecutor enhancedQueueExecutor, long nanos) {
            long remaining;
            int spins = PARK_SPINS;
            if (spins > 0) {
                long start = System.nanoTime();
                if (this.parked == 2 && JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 2, 0)) {
                    return;
                }
                while (spins > 0) {
                    if (spins < YIELD_FACTOR) {
                        Thread.yield();
                    } else {
                        JDKSpecific.onSpinWait();
                    }
                    if (this.parked == 2 && JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 2, 0)) {
                        return;
                    }
                    --spins;
                }
                remaining = nanos - (System.nanoTime() - start);
                if (remaining < 0L) {
                    return;
                }
            } else {
                remaining = nanos;
            }
            if (this.parked == 0 && JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 0, 1)) {
                try {
                    LockSupport.parkNanos(enhancedQueueExecutor, remaining);
                }
                finally {
                    this.parked = 0;
                }
            }
        }

        void unpark() {
            if (this.parked == 0 && JBossExecutors.unsafe.compareAndSwapInt(this, parkedOffset, 0, 2)) {
                return;
            }
            LockSupport.unpark(this.thread);
        }

        static {
            try {
                taskOffset = JBossExecutors.unsafe.objectFieldOffset(PoolThreadNode.class.getDeclaredField("task"));
                parkedOffset = JBossExecutors.unsafe.objectFieldOffset(PoolThreadNode.class.getDeclaredField("parked"));
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    }

    static final class TerminateWaiterNode
    extends QNode {
        TerminateWaiterNode() {
        }
    }

    final class ThreadBody
    implements Runnable {
        private Task initialTask;

        ThreadBody(Task initialTask) {
            this.initialTask = initialTask;
        }

        @Override
        public void run() {
            QNode node;
            Thread currentThread = Thread.currentThread();
            LongAdder spinMisses = EnhancedQueueExecutor.this.spinMisses;
            EnhancedQueueExecutor.this.runningThreads.add(currentThread);
            EnhancedQueueExecutor.nullToNop(this.getAndClearInitialTask()).run();
            PoolThreadNode nextPoolThreadNode = new PoolThreadNode(currentThread);
            block0: while (true) {
                if ((node = this.getOrAddNode(nextPoolThreadNode)) instanceof TaskNode) {
                    ((TaskNode)node).getAndClearTask().run();
                    continue;
                }
                if (node != nextPoolThreadNode) break;
                PoolThreadNode newNode = nextPoolThreadNode;
                nextPoolThreadNode = new PoolThreadNode(currentThread);
                long start = System.nanoTime();
                long elapsed = 0L;
                while (true) {
                    Runnable task = newNode.getTask();
                    assert (task != ACCEPTED && task != GAVE_UP && task != null);
                    if (task != WAITING && task != EXIT) {
                        if (newNode.compareAndSetTask(task, ACCEPTED)) {
                            task.run();
                            continue block0;
                        }
                        if (!UPDATE_STATISTICS) continue;
                        spinMisses.increment();
                        continue;
                    }
                    long timeoutNanos = EnhancedQueueExecutor.this.timeoutNanos;
                    long oldVal = EnhancedQueueExecutor.this.threadStatus;
                    if (elapsed >= timeoutNanos || task == EXIT || EnhancedQueueExecutor.currentSizeOf(oldVal) > EnhancedQueueExecutor.maxSizeOf(oldVal)) {
                        if (task == EXIT || EnhancedQueueExecutor.isShutdownRequested(oldVal) || EnhancedQueueExecutor.isAllowCoreTimeout(oldVal) || EnhancedQueueExecutor.currentSizeOf(oldVal) > EnhancedQueueExecutor.coreSizeOf(oldVal)) {
                            if (!newNode.compareAndSetTask(task, GAVE_UP)) continue;
                            while (true) {
                                if (EnhancedQueueExecutor.this.tryDeallocateThread(oldVal)) {
                                    EnhancedQueueExecutor.this.runningThreads.remove(currentThread);
                                    return;
                                }
                                if (UPDATE_STATISTICS) {
                                    spinMisses.increment();
                                }
                                oldVal = EnhancedQueueExecutor.this.threadStatus;
                            }
                        }
                        if (elapsed >= timeoutNanos) {
                            newNode.park(EnhancedQueueExecutor.this);
                        } else {
                            newNode.park(EnhancedQueueExecutor.this, timeoutNanos - elapsed);
                        }
                        Thread.interrupted();
                        elapsed = System.nanoTime() - start;
                        continue;
                    }
                    assert (task == WAITING);
                    newNode.park(EnhancedQueueExecutor.this, timeoutNanos - elapsed);
                    Thread.interrupted();
                    elapsed = System.nanoTime() - start;
                }
                break;
            }
            assert (node instanceof TerminateWaiterNode);
            EnhancedQueueExecutor.this.runningThreads.remove(currentThread);
            EnhancedQueueExecutor.this.deallocateThread();
        }

        private QNode getOrAddNode(PoolThreadNode nextPoolThreadNode) {
            while (true) {
                TaskNode head;
                QNode headNext;
                if ((headNext = (head = EnhancedQueueExecutor.this.head).getNext()) != head) {
                    if (headNext instanceof TaskNode) {
                        TaskNode taskNode = (TaskNode)headNext;
                        if (EnhancedQueueExecutor.this.compareAndSetHead(head, taskNode)) {
                            head.setNextOrdered(head);
                            if (!NO_QUEUE_LIMIT) {
                                EnhancedQueueExecutor.this.decreaseQueueSize();
                            }
                            return taskNode;
                        }
                    } else if (headNext instanceof PoolThreadNode || headNext == null) {
                        nextPoolThreadNode.setNextRelaxed(headNext);
                        if (head.compareAndSetNext(headNext, nextPoolThreadNode)) {
                            return nextPoolThreadNode;
                        }
                        if (headNext != null) {
                            nextPoolThreadNode.setNextRelaxed(null);
                        }
                    } else {
                        assert (headNext instanceof TerminateWaiterNode);
                        return headNext;
                    }
                }
                if (!UPDATE_STATISTICS) continue;
                EnhancedQueueExecutor.this.spinMisses.increment();
            }
        }

        private Runnable getAndClearInitialTask() {
            Task initial = this.initialTask;
            this.initialTask = null;
            return initial;
        }
    }

    static class MBeanUnregisterAction
    implements PrivilegedAction<Void> {
        private final Object handle;

        static void forceInit() {
        }

        MBeanUnregisterAction(Object handle) {
            this.handle = handle;
        }

        @Override
        public Void run() {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(((ObjectInstance)this.handle).getObjectName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    static final class QueueFullException
    extends RuntimeException {
        QueueFullException() {
            super(null, null, false, false);
        }
    }

    static class TreeSetQueue
    extends TreeSet<AbstractScheduledFuture<?>>
    implements ScheduledFutureQueue {
        TreeSetQueue(ScheduledFutureQueue original) {
            Collections.addAll(this, original.toArray());
        }

        TreeSetQueue() {
        }

        @Override
        public AbstractScheduledFuture<?>[] toArray() {
            return super.toArray(NO_FUTURES);
        }

        @Override
        public boolean insertAndCheckForFirst(AbstractScheduledFuture<?> item) {
            this.add(item);
            return item == this.first();
        }

        @Override
        public ScheduledFutureQueue grow() {
            return this;
        }
    }

    static final class ArrayQueue
    implements ScheduledFutureQueue {
        final AbstractScheduledFuture<?>[] array;
        int head;
        int size;

        ArrayQueue(int capacity) {
            capacity = Integer.highestOneBit(Math.max(capacity, 2) - 1) << 1;
            this.array = new AbstractScheduledFuture[capacity];
        }

        private ArrayQueue(ArrayQueue original, int newCapacity) {
            assert (Integer.bitCount(newCapacity) == 1);
            this.array = original.toArray(newCapacity);
            this.head = 0;
            this.size = original.size;
        }

        @Override
        public AbstractScheduledFuture<?>[] toArray() {
            return this.toArray(this.size());
        }

        public AbstractScheduledFuture<?>[] toArray(int size) {
            int head = this.head;
            int end = head + size;
            AbstractScheduledFuture<?>[] copy = Arrays.copyOfRange(this.array, head, end);
            if (end > this.array.length) {
                System.arraycopy(this.array, 0, copy, size - (this.array.length - head), size - this.array.length);
            }
            return copy;
        }

        @Override
        public void clear() {
            Arrays.fill(this.array, null);
            this.size = 0;
            this.head = 0;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public AbstractScheduledFuture<?> first() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            return this.array[this.head];
        }

        @Override
        public AbstractScheduledFuture<?> pollFirst() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            int head = this.head;
            AbstractScheduledFuture<?> item = this.array[head];
            this.array[head] = null;
            --this.size;
            int mask = this.array.length - 1;
            this.head = head + 1 & mask;
            return item;
        }

        @Override
        public boolean insertAndCheckForFirst(AbstractScheduledFuture<?> item) {
            int size = this.size;
            AbstractScheduledFuture<?>[] array = this.array;
            int arrayLen = array.length;
            if (size == arrayLen) {
                throw new QueueFullException();
            }
            int mask = arrayLen - 1;
            int idx = 0;
            int high = size - 1;
            int head = this.head;
            while (idx <= high) {
                int mid = idx + high >>> 1;
                AbstractScheduledFuture<?> testVal = array[head + mid & mask];
                int cmp = testVal.compareTo(item);
                if (cmp < 0) {
                    idx = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return false;
            }
            return this.insertAt(idx, item);
        }

        void moveForward(int idx, AbstractScheduledFuture<?> storeVal) {
            AbstractScheduledFuture<?>[] array = this.array;
            int size = this.size;
            int moveCnt = size - idx;
            int arrayLength = array.length;
            int mask = arrayLength - 1;
            int head = this.head;
            int start = head + idx;
            for (int i = moveCnt - 1; i >= 0; --i) {
                int pos = start + i;
                array[pos + 1 & mask] = array[pos & mask];
            }
            array[start & mask] = storeVal;
        }

        void moveBackward(int idx, AbstractScheduledFuture<?> storeVal) {
            AbstractScheduledFuture<?>[] array = this.array;
            int size = this.size;
            int moveCnt = size - idx + 1;
            int arrayLength = array.length;
            int mask = arrayLength - 1;
            int head = this.head;
            int start = head + idx - 1;
            for (int i = moveCnt - 1; i >= 0; --i) {
                int pos = start - i;
                array[pos - 1 & mask] = array[pos & mask];
            }
            array[start & mask] = storeVal;
            this.head = head - 1 & mask;
        }

        boolean insertAt(int idx, AbstractScheduledFuture<?> item) {
            int size = this.size;
            this.size = size + 1;
            int halfSize = size + 1 >> 1;
            if (idx >= halfSize) {
                this.moveForward(idx, item);
            } else {
                this.moveBackward(idx, item);
            }
            return idx == 0;
        }

        @Override
        public ScheduledFutureQueue grow() {
            if (this.array.length >= 256) {
                return new TreeSetQueue(this);
            }
            return new ArrayQueue(this, this.array.length << 1);
        }

        int testPoint_arrayLength() {
            return this.array.length;
        }

        int testPoint_head() {
            return this.head;
        }

        void testPoint_setHead(int newHead) {
            this.head = newHead;
        }

        void testPoint_setSize(int newSize) {
            this.size = newSize;
        }

        AbstractScheduledFuture<?> testPoint_getArrayItem(int index) {
            return this.array[index & this.array.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractScheduledFuture<?> testPoint_setArrayItem(int index, AbstractScheduledFuture<?> item) {
            try {
                AbstractScheduledFuture<?> abstractScheduledFuture = this.array[index & this.array.length - 1];
                return abstractScheduledFuture;
            }
            finally {
                this.array[index & this.array.length - 1] = item;
            }
        }
    }

    static interface ScheduledFutureQueue {
        public AbstractScheduledFuture<?>[] toArray();

        public void clear();

        public boolean isEmpty();

        public int size();

        public AbstractScheduledFuture<?> first();

        public AbstractScheduledFuture<?> pollFirst();

        public boolean insertAndCheckForFirst(AbstractScheduledFuture<?> var1) throws QueueFullException;

        public ScheduledFutureQueue grow();
    }

    abstract class RepeatingScheduledFuture<V>
    extends AbstractScheduledFuture<V> {
        final long period;

        RepeatingScheduledFuture(long delay, long period, TimeUnit unit) {
            super(delay, unit);
            this.period = unit.toNanos(period);
        }

        abstract void adjustTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            this.adjustTime();
            RepeatingScheduledFuture repeatingScheduledFuture = this;
            synchronized (repeatingScheduledFuture) {
                switch (this.state) {
                    case 3: {
                        this.state = 0;
                        EnhancedQueueExecutor.this.schedulerTask.schedule(this);
                        return;
                    }
                }
                return;
            }
        }

        @Override
        void finish(V result) {
        }

        @Override
        StringBuilder toString(StringBuilder b) {
            return super.toString(b.append("repeating "));
        }
    }

    static abstract class PoolThreadNodeBase
    extends QNode {
        int p00;
        int p01;
        int p02;
        int p03;
        int p04;
        int p05;
        int p06;
        int p07;
        int p08;
        int p09;
        int p0A;
        int p0B;
        int p0C;
        int p0D;
        int p0E;
        int p0F;

        PoolThreadNodeBase() {
        }
    }
}

