/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.starter.service.impl;

import org.dromara.easyes.common.enums.ProcessIndexStrategyEnum;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.core.biz.CreateIndexParam;
import org.dromara.easyes.core.biz.EntityInfo;
import org.dromara.easyes.core.biz.EsIndexInfo;
import org.dromara.easyes.core.toolkit.EntityInfoHelper;
import org.dromara.easyes.core.toolkit.IndexUtils;
import org.dromara.easyes.starter.service.AutoProcessIndexService;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnClass(value={RestHighLevelClient.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class AutoProcessIndexSmoothlyServiceImpl
implements AutoProcessIndexService {
    @Override
    public Integer getStrategyType() {
        return ProcessIndexStrategyEnum.SMOOTHLY.getStrategyType();
    }

    @Override
    public void processIndexAsync(Class<?> entityClass, RestHighLevelClient client) {
        LogUtils.info((String[])new String[]{"===> Smoothly process index mode activated"});
        IndexUtils.supplyAsync(this::process, entityClass, (RestHighLevelClient)client);
    }

    private synchronized boolean process(Class<?> entityClass, RestHighLevelClient client) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(entityClass);
        boolean existsIndex = IndexUtils.existsIndexWithRetryAndSetActiveIndex((EntityInfo)entityInfo, (RestHighLevelClient)client);
        if (existsIndex) {
            LogUtils.info((String[])new String[]{"===> Index exists, automatically updating index by easy-es..."});
            return this.doUpdateIndex(entityInfo, client);
        }
        LogUtils.info((String[])new String[]{"===> Index not exists, automatically creating index by easy-es..."});
        return this.doCreateIndex(entityInfo, client);
    }

    private boolean doUpdateIndex(EntityInfo entityInfo, RestHighLevelClient client) {
        boolean isIndexNeedChange;
        EsIndexInfo esIndexInfo = IndexUtils.getIndexInfo((RestHighLevelClient)client, (String)entityInfo.getIndexName());
        if (!esIndexInfo.getHasDefaultAlias().booleanValue()) {
            IndexUtils.addDefaultAlias((RestHighLevelClient)client, (String)entityInfo.getIndexName());
        }
        if (!(isIndexNeedChange = IndexUtils.isIndexNeedChange((EsIndexInfo)esIndexInfo, (EntityInfo)entityInfo))) {
            LogUtils.info((String[])new String[]{"===> index has nothing changed"});
            return Boolean.TRUE;
        }
        String releaseIndexName = this.generateReleaseIndexName(entityInfo.getIndexName());
        entityInfo.setReleaseIndexName(releaseIndexName);
        boolean isCreateIndexSuccess = this.doCreateIndex(entityInfo, client);
        if (!isCreateIndexSuccess) {
            LogUtils.error((String[])new String[]{"create release index failed", "releaseIndex:" + releaseIndexName});
            return Boolean.FALSE;
        }
        boolean isDataMigrationSuccess = this.doDataMigration(entityInfo.getIndexName(), releaseIndexName, client);
        if (!isDataMigrationSuccess) {
            LogUtils.error((String[])new String[]{"migrate data failed", "oldIndex:" + entityInfo.getIndexName(), "releaseIndex:" + releaseIndexName});
            return Boolean.FALSE;
        }
        boolean isChangeAliasSuccess = IndexUtils.changeAliasAtomic((RestHighLevelClient)client, (String)entityInfo.getIndexName(), (String)releaseIndexName);
        if (!isChangeAliasSuccess) {
            LogUtils.error((String[])new String[]{"change alias atomically failed", "oldIndex:" + entityInfo.getIndexName(), "releaseIndex:" + releaseIndexName});
            return Boolean.FALSE;
        }
        boolean isDeletedIndexSuccess = IndexUtils.deleteIndex((RestHighLevelClient)client, (String)entityInfo.getIndexName());
        if (!isDeletedIndexSuccess) {
            LogUtils.error((String[])new String[]{"delete old index failed", "oldIndex:" + entityInfo.getIndexName()});
            return Boolean.FALSE;
        }
        entityInfo.setIndexName(releaseIndexName);
        IndexUtils.saveReleaseIndex((String)releaseIndexName, (RestHighLevelClient)client);
        return Boolean.TRUE;
    }

    private String generateReleaseIndexName(String oldIndexName) {
        if (oldIndexName.endsWith("_s0")) {
            return oldIndexName.split("_s0")[0] + "_s1";
        }
        if (oldIndexName.endsWith("_s1")) {
            return oldIndexName.split("_s1")[0] + "_s0";
        }
        return oldIndexName + "_s0";
    }

    private boolean doDataMigration(String oldIndexName, String releaseIndexName, RestHighLevelClient client) {
        return IndexUtils.reindex((RestHighLevelClient)client, (String)oldIndexName, (String)releaseIndexName);
    }

    private boolean doCreateIndex(EntityInfo entityInfo, RestHighLevelClient client) {
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam((EntityInfo)entityInfo);
        return IndexUtils.createIndex((RestHighLevelClient)client, (EntityInfo)entityInfo, (CreateIndexParam)createIndexParam);
    }
}

