/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.coordinator.HmilyCoordinatorService;
import org.dromara.hmily.core.helper.SpringBeanUtils;

public final class HmilyTransactionGuavaCacheManager {
    private static final int MAX_COUNT = 1000000;
    private static final LoadingCache<String, HmilyTransaction> LOADING_CACHE = CacheBuilder.newBuilder().maximumWeight(1000000L).weigher((string, hmilyTransaction) -> HmilyTransactionGuavaCacheManager.getSize()).build((CacheLoader)new CacheLoader<String, HmilyTransaction>(){

        public HmilyTransaction load(String key) {
            return HmilyTransactionGuavaCacheManager.cacheHmilyTransaction(key);
        }
    });
    private static HmilyCoordinatorService coordinatorService = SpringBeanUtils.getInstance().getBean(HmilyCoordinatorService.class);
    private static final HmilyTransactionGuavaCacheManager TCC_TRANSACTION_CACHE_MANAGER = new HmilyTransactionGuavaCacheManager();

    private HmilyTransactionGuavaCacheManager() {
    }

    public static HmilyTransactionGuavaCacheManager getInstance() {
        return TCC_TRANSACTION_CACHE_MANAGER;
    }

    private static int getSize() {
        return (int)LOADING_CACHE.size();
    }

    private static HmilyTransaction cacheHmilyTransaction(String key) {
        return Optional.ofNullable(coordinatorService.findByTransId(key)).orElse(new HmilyTransaction());
    }

    public void cacheHmilyTransaction(HmilyTransaction hmilyTransaction) {
        LOADING_CACHE.put((Object)hmilyTransaction.getTransId(), (Object)hmilyTransaction);
    }

    public HmilyTransaction getHmilyTransaction(String key) {
        try {
            return (HmilyTransaction)LOADING_CACHE.get((Object)key);
        }
        catch (ExecutionException e) {
            return new HmilyTransaction();
        }
    }

    public void removeByKey(String key) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
            LOADING_CACHE.invalidate((Object)key);
        }
    }
}

