/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.concurrent;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dromara.hmily.core.concurrent.SingletonExecutor;

public final class ConsistentHashSelector {
    private static final int REPLICA_NUMBER = 160;
    private static final int FOUR = 4;
    private final TreeMap<Long, SingletonExecutor> virtualInvokers = new TreeMap();

    public ConsistentHashSelector(List<SingletonExecutor> selects) {
        for (SingletonExecutor executor : selects) {
            for (int i = 0; i < 40; ++i) {
                byte[] digest = this.md5(executor.getName() + i);
                for (int h = 0; h < 4; ++h) {
                    long m = this.hash(digest, h);
                    this.virtualInvokers.put(m, executor);
                }
            }
        }
    }

    public SingletonExecutor select(String key) {
        byte[] digest = this.md5(key);
        return this.selectForKey(this.hash(digest, 0));
    }

    private SingletonExecutor selectForKey(long hash) {
        Long key = hash;
        if (!this.virtualInvokers.containsKey(key)) {
            SortedMap<Long, SingletonExecutor> tailMap = this.virtualInvokers.tailMap(key);
            key = tailMap.isEmpty() ? this.virtualInvokers.firstKey() : tailMap.firstKey();
        }
        SingletonExecutor invoker = this.virtualInvokers.get(key);
        return invoker;
    }

    private long hash(byte[] digest, int number) {
        return ((long)(digest[3 + number * 4] & 0xFF) << 24 | (long)(digest[2 + number * 4] & 0xFF) << 16 | (long)(digest[1 + number * 4] & 0xFF) << 8 | (long)(digest[number * 4] & 0xFF)) & 0xFFFFFFFFL;
    }

    private byte[] md5(String value) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        md5.reset();
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        md5.update(bytes);
        return md5.digest();
    }
}

