/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.hmily.core.concurrent.threadpool.HmilyThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingletonExecutor.class);
    private static final int QUEUE_SIZE = 5000;
    private static final RejectedExecutionHandler HANDLER = (r, executor) -> {
        BlockingQueue<Runnable> queue = executor.getQueue();
        while (queue.size() >= 5000) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("SingletonExecutor closed");
            }
            try {
                ((SingletonExecutor)executor).onRejected();
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        executor.execute(r);
    };
    private String name;

    public SingletonExecutor(String poolName) {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), HmilyThreadFactory.create(poolName, false), HANDLER);
        this.name = poolName;
    }

    private void onRejected() {
        LOGGER.info("...thread:{}, Saturation occurs, actuator:{}", (Object)Thread.currentThread().getName(), (Object)this.name);
    }

    public String getName() {
        return this.name;
    }
}

