/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.coordinator.impl;

import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.coordinator.HmilyCoordinatorService;
import org.dromara.hmily.core.helper.SpringBeanUtils;
import org.dromara.hmily.core.service.HmilyApplicationService;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="hmilyCoordinatorService")
public class HmilyCoordinatorServiceImpl
implements HmilyCoordinatorService {
    private HmilyCoordinatorRepository coordinatorRepository;
    private final HmilyApplicationService hmilyApplicationService;

    @Autowired
    public HmilyCoordinatorServiceImpl(HmilyApplicationService hmilyApplicationService) {
        this.hmilyApplicationService = hmilyApplicationService;
    }

    @Override
    public void start(HmilyConfig hmilyConfig) {
        String repositorySuffix = this.buildRepositorySuffix(hmilyConfig.getRepositorySuffix());
        this.coordinatorRepository = SpringBeanUtils.getInstance().getBean(HmilyCoordinatorRepository.class);
        this.coordinatorRepository.init(repositorySuffix, hmilyConfig);
    }

    @Override
    public String save(HmilyTransaction hmilyTransaction) {
        int rows = this.coordinatorRepository.create(hmilyTransaction);
        if (rows > 0) {
            return hmilyTransaction.getTransId();
        }
        return null;
    }

    @Override
    public HmilyTransaction findByTransId(String transId) {
        return this.coordinatorRepository.findById(transId);
    }

    @Override
    public boolean remove(String id) {
        return this.coordinatorRepository.remove(id) > 0;
    }

    @Override
    public void update(HmilyTransaction hmilyTransaction) {
        this.coordinatorRepository.update(hmilyTransaction);
    }

    @Override
    public int updateParticipant(HmilyTransaction hmilyTransaction) {
        return this.coordinatorRepository.updateParticipant(hmilyTransaction);
    }

    @Override
    public int updateStatus(String id, Integer status) {
        return this.coordinatorRepository.updateStatus(id, status);
    }

    private String buildRepositorySuffix(String repositorySuffix) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{repositorySuffix})) {
            return repositorySuffix;
        }
        return this.hmilyApplicationService.acquireName();
    }
}

