/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.disruptor;

import com.lmax.disruptor.RingBuffer;
import org.dromara.hmily.core.disruptor.event.DataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorProvider<T> {
    private final RingBuffer<DataEvent<T>> ringBuffer;
    private Logger logger = LoggerFactory.getLogger(DisruptorProvider.class);

    DisruptorProvider(RingBuffer<DataEvent<T>> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void onData(T t) {
        long position = this.ringBuffer.next();
        try {
            DataEvent de = (DataEvent)this.ringBuffer.get(position);
            de.setT(t);
            this.ringBuffer.publish(position);
        }
        catch (Exception ex) {
            this.logger.error("push data error:", (Throwable)ex);
        }
    }
}

