/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import org.dromara.hmily.core.concurrent.threadpool.HmilyThreadFactory;
import org.dromara.hmily.core.disruptor.DisruptorConsumer;
import org.dromara.hmily.core.disruptor.DisruptorConsumerFactory;
import org.dromara.hmily.core.disruptor.DisruptorEventFactory;
import org.dromara.hmily.core.disruptor.DisruptorProvider;

public class DisruptorProviderManage<T> {
    public static final Integer DEFAULT_SIZE = 16384;
    private static final Integer DEFAULT_CONSUMER_SIZE = Runtime.getRuntime().availableProcessors() << 1;
    private final Integer size;
    private DisruptorProvider<T> provider;
    private Integer consumerSize;
    private DisruptorConsumerFactory consumerFactory;

    public DisruptorProviderManage(DisruptorConsumerFactory consumerFactory, Integer ringBufferSize) {
        this(consumerFactory, DEFAULT_CONSUMER_SIZE, ringBufferSize);
    }

    public DisruptorProviderManage(DisruptorConsumerFactory consumerFactory) {
        this(consumerFactory, DEFAULT_CONSUMER_SIZE, DEFAULT_SIZE);
    }

    public DisruptorProviderManage(DisruptorConsumerFactory consumerFactory, int consumerSize, int ringBufferSize) {
        this.consumerFactory = consumerFactory;
        this.size = ringBufferSize;
        this.consumerSize = consumerSize;
    }

    public void startup() {
        Disruptor disruptor = new Disruptor(new DisruptorEventFactory(), this.size.intValue(), HmilyThreadFactory.create("disruptor_consumer_" + this.consumerFactory.fixName(), false), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        WorkHandler[] consumers = new DisruptorConsumer[this.consumerSize.intValue()];
        for (int i = 0; i < this.consumerSize; ++i) {
            consumers[i] = new DisruptorConsumer(this.consumerFactory);
        }
        disruptor.handleEventsWithWorkerPool(consumers);
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new IgnoreExceptionHandler());
        disruptor.start();
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        this.provider = new DisruptorProvider(ringBuffer);
    }

    public DisruptorProvider<T> getProvider() {
        return this.provider;
    }
}

