/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.disruptor.handler;

import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.enums.EventTypeEnum;
import org.dromara.hmily.core.concurrent.ConsistentHashSelector;
import org.dromara.hmily.core.coordinator.HmilyCoordinatorService;
import org.dromara.hmily.core.disruptor.AbstractDisruptorConsumerExecutor;
import org.dromara.hmily.core.disruptor.DisruptorConsumerFactory;
import org.dromara.hmily.core.disruptor.event.HmilyTransactionEvent;

public class HmilyConsumerLogDataHandler
extends AbstractDisruptorConsumerExecutor<HmilyTransactionEvent>
implements DisruptorConsumerFactory {
    private ConsistentHashSelector executor;
    private final HmilyCoordinatorService coordinatorService;

    public HmilyConsumerLogDataHandler(ConsistentHashSelector executor, HmilyCoordinatorService coordinatorService) {
        this.executor = executor;
        this.coordinatorService = coordinatorService;
    }

    @Override
    public String fixName() {
        return "HmilyConsumerDataHandler";
    }

    public AbstractDisruptorConsumerExecutor create() {
        return this;
    }

    @Override
    public void executor(HmilyTransactionEvent event) {
        String transId = event.getHmilyTransaction().getTransId();
        this.executor.select(transId).execute(() -> {
            if (event.getType() == EventTypeEnum.SAVE.getCode()) {
                this.coordinatorService.save(event.getHmilyTransaction());
            } else if (event.getType() == EventTypeEnum.UPDATE_PARTICIPANT.getCode()) {
                this.coordinatorService.updateParticipant(event.getHmilyTransaction());
            } else if (event.getType() == EventTypeEnum.UPDATE_STATUS.getCode()) {
                HmilyTransaction hmilyTransaction = event.getHmilyTransaction();
                this.coordinatorService.updateStatus(hmilyTransaction.getTransId(), hmilyTransaction.getStatus());
            } else if (event.getType() == EventTypeEnum.DELETE.getCode()) {
                this.coordinatorService.remove(event.getHmilyTransaction().getTransId());
            }
            event.clear();
        });
    }
}

